/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.product.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.custproduct.entity.TmCustProductEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.product.service.TmCustProductService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MDM-\u4ea7\u54c1"}, description="CRM-MDM MDM\u4ea7\u54c1\u4fe1\u606f")
@RestController
@RequestMapping(value={"/custProductController"})
public class CustProductController {
    private static final Logger log = LoggerFactory.getLogger(CustProductController.class);
    @Autowired
    private TmCustProductService tmCustProductService;

    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u7269\u6599\u5217\u8868", notes="\u67e5\u8be2\u5ba2\u6237\u7269\u6599\u5217\u8868,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"findCustProductByPage"})
    public DataGrid findCustProductByPage(HttpServletRequest request, @RequestBody TmCustProductEntity vo) {
        log.info("\u67e5\u8be2\u5ba2\u6237\u7269\u6599\u5217\u8868findCustProductByPage");
        EuPage page = new EuPage(request);
        PageInfo<TmCustProductEntity> tmFunctionEntities = this.tmCustProductService.findCustProductByPage(vo, (Page)page);
        if (tmFunctionEntities != null) {
            return new DataGrid(tmFunctionEntities);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @ApiOperation(value="\u65b0\u589e\u66f4\u65b0\u5ba2\u6237\u7269\u6599", notes="\u65b0\u589e\u66f4\u65b0\u5ba2\u6237\u7269\u6599", httpMethod="POST")
    @PostMapping(value={"saveOrUpdate"})
    public AjaxJson saveOrUpdate(@RequestBody TmCustProductEntity vo) {
        log.info("\u4fdd\u5b58\u66f4\u65b0\u5ba2\u6237\u7269\u6599\u4fe1\u606fsaveOrUpdate");
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtils.isNotEmpty((CharSequence)vo.getId()) ? this.tmCustProductService.updateEntity(vo) : this.tmCustProductService.saveEntity(vo);
        return ajaxJson;
    }

    @ApiOperation(value="\u5220\u9664\u5ba2\u6237\u7269\u6599", notes="\u5220\u9664\u5ba2\u6237\u7269\u6599", httpMethod="POST")
    @PostMapping(value={"deleteCustProduct"})
    public AjaxJson deleteCustProduct(@RequestBody List<String> ids) {
        log.info("\u5220\u9664\u5ba2\u6237\u7269\u6599deleteCustProduct");
        AjaxJson ajaxJson = new AjaxJson();
        if (ids.size() > 0 && ids != null) {
            this.tmCustProductService.delByIdList(ids, TmCustProductEntity.class);
        }
        return ajaxJson;
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u5ba2\u6237\u7269\u6599\u4fe1\u606f", notes="\u901a\u8fc7id\u67e5\u8be2\u5ba2\u6237\u7269\u6599\u4fe1\u606f", httpMethod="GET")
    @GetMapping(value={"getCustProductById"})
    public AjaxJson getCustProductById(@RequestParam(value="id") String id) {
        log.info("\u901a\u8fc7id\u67e5\u8be2\u5ba2\u6237\u7269\u6599\u4fe1\u606fgetCustProductById");
        AjaxJson ajaxJson = new AjaxJson();
        TmCustProductEntity entity = this.tmCustProductService.getCustProductById(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }
}

