/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.registerToken.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.CookiesUtil;
import com.biz.eisp.base.utils.Md5EncryptionAndDecryption;
import com.biz.eisp.base.utils.Snippet;
import com.biz.eisp.org.dao.OrgDao;
import com.biz.eisp.org.entity.TmOrgEntity;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.position.service.PositionService;
import com.biz.eisp.registerToken.service.RegisterTokenApiService;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.user.dao.TmUserDao;
import com.biz.eisp.user.entity.TmUserEntity;
import java.net.URLEncoder;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RegisterTokenApiServiceImpl
implements RegisterTokenApiService {
    @Autowired
    private TmUserDao tmUserDao;
    @Autowired
    private RedisService redisService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrgDao orgDao;
    @Value(value="${tokenUrl:}")
    private String tokenUrl;

    @Override
    public String registerToken(String username, String password) throws Exception {
        TmUserEntity userEntity = new TmUserEntity();
        userEntity.setUsername(username);
        TmUserEntity result = (TmUserEntity)this.tmUserDao.selectOne(userEntity);
        if (null == result) {
            throw new BusinessException("\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        String pwd = result.getPassword();
        String md5Pwd = Md5EncryptionAndDecryption.encryPwd((String)password);
        if (!StringUtil.equals((String)md5Pwd, (String)pwd)) {
            throw new BusinessException("\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        String key = Snippet.aesEncrypt((String)CookiesUtil.getKeyFlag((String)username), (String)"1oR8uIM2O5qv65l2");
        TmPositionVo positionVo = this.positionService.getUserMainPositon(userEntity.getUsername(), userEntity.getId());
        UserRedis userRedis = this.createUserRedis(result, positionVo, Globals.LOGIN_SOURCE_PC);
        String value = JSON.toJSONString((Object)userRedis);
        this.redisService.setSeconds("LOGIN_SUCCESS_" + key, (Object)value, 3600L);
        return key;
    }

    private UserRedis createUserRedis(TmUserEntity tmUserEntity, TmPositionVo tmPositionVo, String loginSource) {
        List<TmUserVo> customer;
        UserRedis userRedis = new UserRedis();
        userRedis.setId(tmUserEntity.getId());
        userRedis.setRealname(tmUserEntity.getFullname());
        userRedis.setUsername(tmUserEntity.getUsername());
        userRedis.setStaffcode(tmUserEntity.getExtChar1());
        userRedis.setUsertype(Integer.valueOf(Integer.parseInt(tmUserEntity.getUserType())));
        if (tmPositionVo != null) {
            TmOrgEntity tmOrg;
            userRedis.setPosId(tmPositionVo.getId());
            userRedis.setPosCode(tmPositionVo.getPositionCode());
            userRedis.setPosName(tmPositionVo.getPositionName());
            userRedis.setPoscoderule(tmPositionVo.getCodeRule());
            if (StringUtil.isNotEmpty((CharSequence)tmPositionVo.getOrgId()) && null != (tmOrg = (TmOrgEntity)this.orgDao.selectByPrimaryKey(tmPositionVo.getOrgId()))) {
                userRedis.setOrgId(tmOrg.getId());
                userRedis.setOrgCode(tmOrg.getOrgCode());
                userRedis.setOrgcoderule(tmOrg.getCodeRule());
            }
        }
        if (tmUserEntity.getUserType().equals("1") && CollectionUtil.listNotEmptyNotSizeZero(customer = this.tmUserDao.findUserCustomer(tmUserEntity.getId()))) {
            userRedis.setCustcode(customer.get(0).getUsername());
        }
        userRedis.setLoginSource(loginSource);
        return userRedis;
    }

    @Override
    public String registerURLToken(String username) throws Exception {
        TmUserEntity userEntity = new TmUserEntity();
        userEntity.setUsername(username);
        TmUserEntity result = (TmUserEntity)this.tmUserDao.selectOne(userEntity);
        if (null == result) {
            throw new BusinessException("\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        String key = Snippet.aesEncrypt((String)CookiesUtil.getKeyFlag((String)username), (String)"1oR8uIM2O5qv65l2");
        UserRedis userRedis = this.createUserRedis(result, null, Globals.LOGIN_SOURCE_PC);
        String value = JSON.toJSONString((Object)userRedis);
        this.redisService.setSeconds("LOGIN_SUCCESS_" + key, (Object)value, 3600L);
        return this.tokenUrl + "?token=" + URLEncoder.encode(key, "utf-8");
    }
}

