/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.ware.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.org.entity.TmOrgEntity;
import com.biz.eisp.org.service.OrgService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.price.PriceParamVo;
import com.biz.eisp.price.PriceReturnVo;
import com.biz.eisp.price.PriceWareReturnVo;
import com.biz.eisp.product.entity.TmProductInfoEntity;
import com.biz.eisp.product.service.TmProductInfoService;
import com.biz.eisp.productPrice.service.TmProductPriceService;
import com.biz.eisp.ware.dao.TmWareInfoDao;
import com.biz.eisp.ware.dao.TmWarePicDao;
import com.biz.eisp.ware.dao.TmWareProductDao;
import com.biz.eisp.ware.dao.TmWareSalerangeDao;
import com.biz.eisp.ware.dao.TmWareTextDao;
import com.biz.eisp.ware.entity.TmWareInfoEntity;
import com.biz.eisp.ware.entity.TmWarePicEntity;
import com.biz.eisp.ware.entity.TmWareProductEntity;
import com.biz.eisp.ware.entity.TmWareSalerangeEntity;
import com.biz.eisp.ware.entity.TmWareTextEntity;
import com.biz.eisp.ware.service.TmWareInfoExpand;
import com.biz.eisp.ware.service.TmWareInfoForSelectExpand;
import com.biz.eisp.ware.service.TmWareInfoService;
import com.biz.eisp.ware.vo.FindWarePriceVo;
import com.biz.eisp.ware.vo.TmWareInfoPriceVo;
import com.biz.eisp.ware.vo.TmWareInfoVo;
import com.biz.eisp.ware.vo.TmWarePicVo;
import com.biz.eisp.ware.vo.TmWareProductVo;
import com.biz.eisp.ware.vo.TmWareSalerangeVo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TmWareInfoServiceImpl
implements TmWareInfoService {
    @Autowired
    private TmWareInfoDao tmWareInfoDao;
    @Autowired
    private TmWareProductDao tmWareProductDao;
    @Autowired
    private TmWareSalerangeDao tmWareSalerangeDao;
    @Autowired
    private TmWarePicDao tmWarePicDao;
    @Autowired
    private TmWareTextDao tmWareTextDao;
    @Autowired
    private OrgService orgService;
    @Autowired
    private TmProductPriceService tmProductPriceService;
    @Autowired
    private TmProductInfoService tmProductInfoService;
    @Autowired(required=false)
    private TmWareInfoExpand tmWareInfoExpand;
    @Autowired(required=false)
    private TmWareInfoForSelectExpand tmWareInfoForSelectExpand;

    @Override
    public PageInfo<TmWareInfoVo> findTmWareInfoPage(Map<String, Object> param, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.tmWareInfoDao.findTmWareInfoList(param), (Page)page);
    }

    @Override
    public PageInfo<TmWareInfoEntity> findTmWareInfoPageNew(Map<String, Object> param, Page page) {
        String expandSql;
        StringBuffer buffer = new StringBuffer();
        UserRedis userRedis = UserUtils.getUser();
        Boolean flagOr = true;
        if (this.tmWareInfoForSelectExpand != null && StringUtil.isNotEmpty((CharSequence)(expandSql = this.tmWareInfoForSelectExpand.getMainListAuth(param, userRedis, flagOr, buffer)))) {
            buffer.append(expandSql);
        }
        String aUsql = buffer.toString();
        return PageAutoHelperUtil.generatePage(() -> this.tmWareInfoDao.findTmWareInfoPageNew(param, aUsql), (Page)page);
    }

    @Override
    public PageInfo<TmWareInfoEntity> findWareInfoPriceByPage(Map<String, Object> param, Page page, List<String> notCodes) {
        String expandSql;
        TmWareInfoVo tmWareInfoVo = new TmWareInfoVo();
        if (StringUtil.isNotEmpty((Object)param.get("wareCode"))) {
            tmWareInfoVo.setWareCode(param.get("wareCode").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("wareName"))) {
            tmWareInfoVo.setWareName(param.get("wareName").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("barCode"))) {
            tmWareInfoVo.setBarCode(param.get("barCode").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("shelfStatus"))) {
            tmWareInfoVo.setShelfStatus(param.get("shelfStatus").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("rebateStatus"))) {
            tmWareInfoVo.setRebateStatus(param.get("rebateStatus").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("warePriority"))) {
            tmWareInfoVo.setWarePriority(param.get("warePriority").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("enableStatus"))) {
            tmWareInfoVo.setEnableStatus(param.get("enableStatus").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("brand"))) {
            tmWareInfoVo.setBrand(param.get("brand").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("category"))) {
            tmWareInfoVo.setCategory(param.get("category").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("budgetCode"))) {
            tmWareInfoVo.setBudgetCode(param.get("budgetCode").toString());
        }
        StringBuffer buffer = new StringBuffer();
        UserRedis userRedis = UserUtils.getUser();
        Boolean flagOr = true;
        if (this.tmWareInfoExpand != null && StringUtil.isNotEmpty((CharSequence)(expandSql = this.tmWareInfoExpand.getMaiListAuth(param, userRedis, flagOr, buffer)))) {
            buffer.append(expandSql);
        }
        String aUsql = buffer.toString();
        return PageAutoHelperUtil.generatePage(() -> this.tmWareInfoDao.findWareInfoPriceByPage(tmWareInfoVo, aUsql, notCodes), (Page)page);
    }

    @Override
    public List<TmWareInfoEntity> findTmWareInfoList(TmWareInfoVo vo) {
        Example example = new Example(TmWareInfoEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getWareCode())) {
            criteria.andEqualTo("wareCode", (Object)vo.getWareCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getWareName())) {
            criteria.andLike("wareName", "%" + vo.getWareName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getBarCode())) {
            criteria.andEqualTo("barCode", (Object)vo.getBarCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getShelfStatus())) {
            criteria.andEqualTo("shelfStatus", (Object)vo.getShelfStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getEnableStatus())) {
            criteria.andEqualTo("enableStatus", (Object)vo.getEnableStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getRebateStatus())) {
            criteria.andEqualTo("rebateStatus", (Object)vo.getRebateStatus());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getWarePriority())) {
            criteria.andEqualTo("warePriority", (Object)vo.getWarePriority());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getBrand())) {
            criteria.andEqualTo("brand", (Object)vo.getBrand());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getCategory())) {
            criteria.andEqualTo("category", (Object)vo.getCategory());
        }
        return this.tmWareInfoDao.selectByExample(example);
    }

    @Override
    public TmWareInfoEntity getTmWareInfoEntityById(String id) {
        return (TmWareInfoEntity)this.tmWareInfoDao.selectByPrimaryKey(id);
    }

    @Override
    public List<TmWareInfoVo> findTmWareInfoListByWareCodes(List<String> wareCodes) {
        if (CollectionUtil.listEmpty(wareCodes)) {
            return new ArrayList<TmWareInfoVo>();
        }
        return this.tmWareInfoDao.findTmWareInfoListByWareCodes(wareCodes);
    }

    @Override
    public boolean delete(String id) {
        TmWareInfoEntity tmWareInfoEntity = (TmWareInfoEntity)this.tmWareInfoDao.selectByPrimaryKey(id);
        int i = this.tmWareInfoDao.delete(tmWareInfoEntity);
        if (i > 0) {
            this.deleteWareProduct(tmWareInfoEntity.getWareCode());
            this.deleteWareSaleRange(tmWareInfoEntity.getWareCode());
            this.deleteWarePic(tmWareInfoEntity.getWareCode());
            this.deleteWareText(tmWareInfoEntity.getWareCode());
        }
        return i > 0;
    }

    @Override
    public boolean save(TmWareInfoVo vo) {
        int i = 0;
        TmWareInfoEntity entity = new TmWareInfoEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            entity = this.getTmWareInfoEntity(vo);
            if (StringUtil.isEmpty((String)entity.getEnableStatus())) {
                entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            }
            i = this.tmWareInfoDao.insertSelective(entity);
        }
        return i > 0;
    }

    @Override
    public boolean update(TmWareInfoVo vo) {
        int i = 0;
        TmWareInfoEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = this.getTmWareInfoEntity(vo);
            if (StringUtil.isEmpty((String)entity.getEnableStatus())) {
                entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
            }
            i = this.tmWareInfoDao.updateByPrimaryKeySelective(entity);
        }
        return i > 0;
    }

    private TmWareInfoEntity getTmWareInfoEntity(TmWareInfoVo vo) {
        TmWareInfoEntity entity = new TmWareInfoEntity();
        BeanUtils.copyProperties((Object)vo, (Object)entity);
        if (StringUtil.isNotEmpty((CharSequence)vo.getComposeType())) {
            entity.setComposeType(vo.getComposeType());
        } else {
            entity.setComposeType("30");
        }
        return entity;
    }

    @Override
    public AjaxJson saveWareProduct(TmWareInfoVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        boolean rs = false;
        String wareId = vo.getId();
        if (StringUtil.isNotEmpty((CharSequence)wareId)) {
            if (vo.getTmWareProductVos().size() > 1) {
                vo.setIsPortfolio(ConstantEnum.YesNoEnum.ONE.getValue());
            } else {
                vo.setIsPortfolio(ConstantEnum.YesNoEnum.ZERO.getValue());
            }
            rs = this.update(vo);
            if (!rs) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u6dfb\u52a0\u5546\u54c1\u4e3b\u8868\u5931\u8d25");
                return ajaxJson;
            }
            if (rs) {
                rs = this.saveWareProduct(vo.getWareCode(), vo.getTmWareProductVos());
            }
            if (!rs) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u6dfb\u52a0\u5546\u54c1\u7269\u6599\u5173\u8054\u8868\u5931\u8d25");
                return ajaxJson;
            }
            if (rs) {
                rs = this.saveWareSaleRange(vo.getWareCode(), vo.getTmWareSalerangeVos());
            }
            if (!rs) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u6dfb\u52a0\u5546\u54c1\u9500\u552e\u8303\u56f4\u5931\u8d25");
                return ajaxJson;
            }
            if (rs) {
                rs = this.saveWarePic(vo.getWareCode(), vo.getUrlPath(), vo.getTmWarePicVos());
            }
            if (!rs) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u6dfb\u52a0\u5546\u54c1\u56fe\u7247\u5931\u8d25");
                return ajaxJson;
            }
            if (rs) {
                rs = this.saveWareText(vo.getWareCode(), vo.getWareText());
            }
            if (!rs) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u6dfb\u52a0\u5546\u54c1\u5bcc\u6587\u672c\u5931\u8d25");
                return ajaxJson;
            }
        } else {
            TmWareInfoVo tmWareInfoVo = new TmWareInfoVo();
            tmWareInfoVo.setWareCode(vo.getWareCode());
            List<TmWareInfoEntity> tmWareInfoEntities = this.findTmWareInfoList(vo);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmWareInfoEntities)) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u8be5\u5546\u54c1\u7f16\u7801\u5df2\u5b58\u5728");
                return ajaxJson;
            }
            if (vo.getTmWareProductVos().size() > 1) {
                vo.setIsPortfolio(ConstantEnum.YesNoEnum.ONE.getValue());
            } else {
                vo.setIsPortfolio(ConstantEnum.YesNoEnum.ZERO.getValue());
            }
            rs = this.save(vo);
            if (!rs) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u6dfb\u52a0\u5546\u54c1\u4e3b\u8868\u5931\u8d25");
                return ajaxJson;
            }
            if (rs) {
                rs = this.saveWareProduct(vo.getWareCode(), vo.getTmWareProductVos());
            }
            if (!rs) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u6dfb\u52a0\u5546\u54c1\u7269\u6599\u5173\u8054\u8868\u5931\u8d25");
                return ajaxJson;
            }
            if (rs) {
                rs = this.saveWareSaleRange(vo.getWareCode(), vo.getTmWareSalerangeVos());
            }
            if (!rs) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u6dfb\u52a0\u5546\u54c1\u9500\u552e\u8303\u56f4\u5931\u8d25");
                return ajaxJson;
            }
            if (rs) {
                rs = this.saveWarePic(vo.getWareCode(), vo.getUrlPath(), vo.getTmWarePicVos());
            }
            if (!rs) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u6dfb\u52a0\u5546\u54c1\u56fe\u7247\u5931\u8d25");
                return ajaxJson;
            }
            if (rs) {
                rs = this.saveWareText(vo.getWareCode(), vo.getWareText());
            }
            if (!rs) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u6dfb\u52a0\u5546\u54c1\u5bcc\u6587\u672c\u5931\u8d25");
                return ajaxJson;
            }
        }
        return ajaxJson;
    }

    private boolean saveWareProduct(String wareCode, List<TmWareProductVo> tmWareProductVos) {
        int i = 0;
        this.deleteWareProduct(wareCode);
        ArrayList tmWareProductEntities = new ArrayList();
        if (CollectionUtil.listNotEmptyNotSizeZero(tmWareProductVos)) {
            tmWareProductVos.forEach(item -> {
                TmWareProductEntity entity = new TmWareProductEntity();
                BeanUtils.copyProperties((Object)item, (Object)entity);
                entity.setWareCode(wareCode);
                tmWareProductEntities.add(entity);
            });
            i = this.tmWareProductDao.insertList(tmWareProductEntities);
        } else {
            i = 1;
        }
        return i > 0;
    }

    private void deleteWareProduct(String wareCode) {
        Example exampleWareProduct = new Example(TmWareProductEntity.class);
        Example.Criteria criteria = exampleWareProduct.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)wareCode)) {
            criteria.andEqualTo("wareCode", (Object)wareCode);
        }
        List entities = this.tmWareProductDao.selectByExample(exampleWareProduct);
        entities.forEach(item -> this.tmWareProductDao.delete(item));
    }

    private boolean saveWareSaleRange(String wareCode, List<TmWareSalerangeVo> tmWareSalerangeVos) {
        int i = 0;
        this.deleteWareSaleRange(wareCode);
        ArrayList tmWareSalerangeEntities = new ArrayList();
        if (CollectionUtil.listNotEmptyNotSizeZero(tmWareSalerangeVos)) {
            tmWareSalerangeVos.forEach(item -> {
                TmWareSalerangeEntity entity = new TmWareSalerangeEntity();
                BeanUtils.copyProperties((Object)item, (Object)entity);
                entity.setWareCode(wareCode);
                tmWareSalerangeEntities.add(entity);
            });
            i = this.tmWareSalerangeDao.insertList(tmWareSalerangeEntities);
        } else {
            TmWareSalerangeEntity entity = new TmWareSalerangeEntity();
            entity.setOrgCode("ALL");
            entity.setContainStatus("1");
            entity.setContainObjType("0");
            entity.setWareCode(wareCode);
            i = this.tmWareSalerangeDao.insert(entity);
        }
        return i > 0;
    }

    private void deleteWareSaleRange(String wareCode) {
        Example exampleWareSalerange = new Example(TmWareSalerangeEntity.class);
        Example.Criteria criteria = exampleWareSalerange.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)wareCode)) {
            criteria.andEqualTo("wareCode", (Object)wareCode);
        }
        List entities = this.tmWareSalerangeDao.selectByExample(exampleWareSalerange);
        entities.forEach(item -> this.tmWareSalerangeDao.delete(item));
    }

    private boolean saveWarePic(String wareCode, String urlPath, List<TmWarePicVo> tmWarePicVos) {
        int i = 0;
        this.deleteWarePic(wareCode);
        TmWarePicEntity entity = new TmWarePicEntity();
        entity.setUrlPath(urlPath);
        entity.setWareCode(wareCode);
        entity.setPicType(ConstantEnum.picTypeEnum.INDEX.getValue());
        i = this.tmWarePicDao.insert(entity);
        if (i > 0) {
            ArrayList tmWarePicEntities = new ArrayList();
            if (CollectionUtil.listNotEmptyNotSizeZero(tmWarePicVos)) {
                tmWarePicVos.forEach(item -> {
                    TmWarePicEntity warePicEntity = new TmWarePicEntity();
                    BeanUtils.copyProperties((Object)item, (Object)warePicEntity);
                    warePicEntity.setPicType(ConstantEnum.picTypeEnum.DETAIL.getValue());
                    warePicEntity.setWareCode(wareCode);
                    tmWarePicEntities.add(warePicEntity);
                });
                i = this.tmWarePicDao.insertList(tmWarePicEntities);
            } else {
                i = 1;
            }
        }
        return i > 0;
    }

    private void deleteWarePic(String wareCode) {
        Example exampleWarePic = new Example(TmWarePicEntity.class);
        Example.Criteria criteria = exampleWarePic.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)wareCode)) {
            criteria.andEqualTo("wareCode", (Object)wareCode);
        }
        List entities = this.tmWarePicDao.selectByExample(exampleWarePic);
        entities.forEach(item -> this.tmWarePicDao.delete(item));
    }

    private boolean saveWareText(String wareCode, String wareText) {
        int i = 0;
        this.deleteWareText(wareCode);
        TmWareTextEntity entity = new TmWareTextEntity();
        entity.setWareText(wareText);
        entity.setWareCode(wareCode);
        i = this.tmWareTextDao.insert(entity);
        return i > 0;
    }

    private void deleteWareText(String wareCode) {
        Example exampleWareText = new Example(TmWareTextEntity.class);
        Example.Criteria criteria = exampleWareText.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)wareCode)) {
            criteria.andEqualTo("wareCode", (Object)wareCode);
        }
        List entities = this.tmWareTextDao.selectByExample(exampleWareText);
        entities.forEach(item -> this.tmWareTextDao.delete(item));
    }

    @Override
    public List<PriceWareReturnVo> getStandPriceReturnVos(PriceParamVo priceParamVo) {
        ArrayList<PriceWareReturnVo> priceWareReturnVos = new ArrayList<PriceWareReturnVo>();
        List productCodes = priceParamVo.getProductCodes();
        List<TmWareProductVo> tmWareProductVos = this.tmWareProductDao.getTmWareProductListByWareCodes(productCodes);
        ArrayList productInfoCodes = new ArrayList();
        tmWareProductVos.forEach(item -> productInfoCodes.add(item.getProductInfoCode()));
        PriceParamVo paramVo = new PriceParamVo();
        paramVo.setProductCodes(productInfoCodes);
        paramVo.setPriceGroup(priceParamVo.getPriceGroup());
        paramVo.setCustCode(priceParamVo.getCustCode());
        paramVo.setPriceType(priceParamVo.getPriceType());
        paramVo.setPriceDate(priceParamVo.getPriceDate());
        List<PriceReturnVo> priceReturnVos = this.tmProductPriceService.getPriceReturnVos(paramVo);
        HashMap productInfoCodeMap = new HashMap();
        priceReturnVos.forEach(item -> productInfoCodeMap.put(item.getProductInfoCode(), item.getPriceAmount()));
        HashMap listMap = new HashMap();
        List<TmWareInfoVo> tmWareInfoVos = this.tmWareInfoDao.findTmWareInfoListByWareCodes(productCodes);
        tmWareInfoVos.forEach(item -> listMap.put(item.getWareCode(), item.getTmWareProductVos()));
        if (!listMap.isEmpty()) {
            for (Map.Entry entry : listMap.entrySet()) {
                PriceWareReturnVo priceWareReturnVo = new PriceWareReturnVo();
                BigDecimal priceAmount = new BigDecimal(0);
                List wareProductVos = (List)entry.getValue();
                for (TmWareProductVo tmWareProductVo : wareProductVos) {
                    if (!productInfoCodeMap.containsKey(tmWareProductVo.getProductInfoCode())) {
                        priceAmount = new BigDecimal(0);
                        break;
                    }
                    if (!StringUtil.isNotEmpty((CharSequence)tmWareProductVo.getProductNum())) continue;
                    BigDecimal bigDecimal = ((BigDecimal)productInfoCodeMap.get(tmWareProductVo.getProductInfoCode())).multiply(new BigDecimal(tmWareProductVo.getProductNum()));
                    priceAmount = priceAmount.add(bigDecimal);
                }
                if (priceAmount.equals(BigDecimal.ZERO)) continue;
                priceWareReturnVo.setWareCode((String)entry.getKey());
                priceWareReturnVo.setPriceAmount(priceAmount);
                priceWareReturnVos.add(priceWareReturnVo);
            }
        }
        return priceWareReturnVos;
    }

    @Override
    public List<PriceWareReturnVo> getCustStandPriceReturnVos(PriceParamVo priceParamVo) {
        ArrayList<PriceWareReturnVo> priceWareReturnVos = new ArrayList<PriceWareReturnVo>();
        List productCodes = priceParamVo.getProductCodes();
        List<TmWareProductVo> tmWareProductVos = this.tmWareProductDao.getTmWareProductListByWareCodes(productCodes);
        ArrayList productInfoCodes = new ArrayList();
        tmWareProductVos.forEach(item -> productInfoCodes.add(item.getProductInfoCode()));
        PriceParamVo paramVo = new PriceParamVo();
        paramVo.setProductCodes(productInfoCodes);
        paramVo.setPriceGroup(priceParamVo.getPriceGroup());
        paramVo.setCustCode(priceParamVo.getCustCode());
        paramVo.setPriceType(priceParamVo.getPriceType());
        paramVo.setPriceDate(priceParamVo.getPriceDate());
        List<PriceReturnVo> priceReturnVos = this.tmProductPriceService.getCustPriceReturnVos(paramVo);
        HashMap productInfoCodeMap = new HashMap();
        priceReturnVos.forEach(item -> productInfoCodeMap.put(item.getProductInfoCode(), item.getPriceAmount()));
        HashMap listMap = new HashMap();
        List<TmWareInfoVo> tmWareInfoVos = this.tmWareInfoDao.findTmWareInfoListByWareCodes(productCodes);
        tmWareInfoVos.forEach(item -> listMap.put(item.getWareCode(), item.getTmWareProductVos()));
        if (!listMap.isEmpty()) {
            for (Map.Entry entry : listMap.entrySet()) {
                PriceWareReturnVo priceWareReturnVo = new PriceWareReturnVo();
                BigDecimal priceAmount = new BigDecimal(0);
                List wareProductVos = (List)entry.getValue();
                for (TmWareProductVo tmWareProductVo : wareProductVos) {
                    if (!productInfoCodeMap.containsKey(tmWareProductVo.getProductInfoCode())) {
                        priceAmount = new BigDecimal(0);
                        break;
                    }
                    if (!StringUtil.isNotEmpty((CharSequence)tmWareProductVo.getProductNum())) continue;
                    BigDecimal bigDecimal = ((BigDecimal)productInfoCodeMap.get(tmWareProductVo.getProductInfoCode())).multiply(new BigDecimal(tmWareProductVo.getProductNum()));
                    priceAmount = priceAmount.add(bigDecimal);
                }
                if (priceAmount.equals(BigDecimal.ZERO)) continue;
                priceWareReturnVo.setWareCode((String)entry.getKey());
                priceWareReturnVo.setPriceAmount(priceAmount);
                priceWareReturnVos.add(priceWareReturnVo);
            }
        }
        return priceWareReturnVos;
    }

    @Override
    public List<PriceWareReturnVo> getCostPriceReturnVos(PriceParamVo priceParamVo) {
        ArrayList<PriceWareReturnVo> priceWareReturnVos = new ArrayList<PriceWareReturnVo>();
        List productCodes = priceParamVo.getProductCodes();
        List<TmWareProductVo> tmWareProductVos = this.tmWareProductDao.getTmWareProductListByWareCodes(productCodes);
        ArrayList<String> productInfoCodes = new ArrayList<String>();
        tmWareProductVos.forEach(item -> productInfoCodes.add(item.getProductInfoCode()));
        List<TmProductInfoEntity> tmProductInfoEntities = this.tmProductInfoService.getTmProductInfoEntityByCodes(productInfoCodes);
        HashMap productInfoCodeMap = new HashMap();
        tmProductInfoEntities.forEach(item -> productInfoCodeMap.put(item.getProductInfoCode(), item.getCostPrice()));
        HashMap listMap = new HashMap();
        List<TmWareInfoVo> tmWareInfoVos = this.tmWareInfoDao.findTmWareInfoListByWareCodes(productCodes);
        tmWareInfoVos.forEach(item -> listMap.put(item.getWareCode(), item.getTmWareProductVos()));
        if (!listMap.isEmpty()) {
            for (Map.Entry entry : listMap.entrySet()) {
                PriceWareReturnVo priceWareReturnVo = new PriceWareReturnVo();
                BigDecimal priceAmount = new BigDecimal(0);
                List wareProductVos = (List)entry.getValue();
                for (TmWareProductVo tmWareProductVo : wareProductVos) {
                    if (StringUtil.isEmpty(productInfoCodeMap.get(tmWareProductVo.getProductInfoCode()))) {
                        priceAmount = new BigDecimal(0);
                        break;
                    }
                    if (!StringUtil.isNotEmpty((CharSequence)tmWareProductVo.getProductNum())) continue;
                    BigDecimal bigDecimal = ((BigDecimal)productInfoCodeMap.get(tmWareProductVo.getProductInfoCode())).multiply(new BigDecimal(tmWareProductVo.getProductNum()));
                    priceAmount = priceAmount.add(bigDecimal);
                }
                if (priceAmount.equals(BigDecimal.ZERO)) continue;
                priceWareReturnVo.setWareCode((String)entry.getKey());
                priceWareReturnVo.setPriceAmount(priceAmount);
                priceWareReturnVos.add(priceWareReturnVo);
            }
        }
        return priceWareReturnVos;
    }

    @Override
    public List<TmWareInfoEntity> getAllNoStandPriceWare(TmWareInfoVo tmWareInfoVo, List<PriceWareReturnVo> priceReturnVos) {
        TmWareInfoVo vo = new TmWareInfoVo();
        vo.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        List<TmWareInfoEntity> productInfoEntities = this.findTmWareInfoList(vo);
        List productCodes = productInfoEntities.stream().map(TmWareInfoEntity::getWareCode).collect(Collectors.toList());
        PriceParamVo priceParamVo = new PriceParamVo(productCodes, tmWareInfoVo.getPriceGroup(), tmWareInfoVo.getCustCode());
        ArrayList priceReturnVos1 = this.getStandPriceReturnVos(priceParamVo);
        priceReturnVos1 = priceReturnVos1 == null ? new ArrayList() : priceReturnVos1;
        priceReturnVos.addAll(priceReturnVos1);
        Map<String, String> mapPrice = priceReturnVos1.stream().collect(Collectors.toMap(PriceWareReturnVo::getWareCode, PriceWareReturnVo::getWareCode));
        for (int i = 0; i < productInfoEntities.size(); ++i) {
            if (!mapPrice.containsKey(productInfoEntities.get(i).getWareCode())) continue;
            productInfoEntities.remove(i);
            --i;
        }
        return productInfoEntities;
    }

    @Override
    public List<TmWareInfoEntity> getAllNoCostPriceWare(TmWareInfoVo tmWareInfoVo, List<PriceWareReturnVo> priceReturnVos) {
        TmWareInfoVo vo = new TmWareInfoVo();
        vo.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        List<TmWareInfoEntity> productInfoEntities = this.findTmWareInfoList(vo);
        List productCodes = productInfoEntities.stream().map(TmWareInfoEntity::getWareCode).collect(Collectors.toList());
        PriceParamVo priceParamVo = new PriceParamVo(productCodes, tmWareInfoVo.getPriceGroup(), tmWareInfoVo.getCustCode());
        ArrayList priceReturnVos1 = this.getCostPriceReturnVos(priceParamVo);
        priceReturnVos1 = priceReturnVos1 == null ? new ArrayList() : priceReturnVos1;
        priceReturnVos.addAll(priceReturnVos1);
        Map<String, String> mapPrice = priceReturnVos1.stream().collect(Collectors.toMap(PriceWareReturnVo::getWareCode, PriceWareReturnVo::getWareCode));
        for (int i = 0; i < productInfoEntities.size(); ++i) {
            if (!mapPrice.containsKey(productInfoEntities.get(i).getWareCode())) continue;
            productInfoEntities.remove(i);
            --i;
        }
        return productInfoEntities;
    }

    @Override
    public PageInfo<TmWareInfoVo> findWarePriceSelfList(TmWareInfoPriceVo tmWareInfoPriceVo) {
        String custCode = tmWareInfoPriceVo.getCustCode();
        FindWarePriceVo findWarePriceVo = new FindWarePriceVo();
        findWarePriceVo.setCustCode(custCode);
        findWarePriceVo.setCodesIn(tmWareInfoPriceVo.getCodesIn());
        findWarePriceVo.setCodesNotIn(tmWareInfoPriceVo.getCodesNotIn());
        Page page = new Page();
        page.setPage(tmWareInfoPriceVo.getPage());
        page.setRows(tmWareInfoPriceVo.getRows());
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.tmWareInfoDao.findWarePriceSelfList(tmWareInfoPriceVo.getCodesIn(), tmWareInfoPriceVo.getCodesNotIn(), findWarePriceVo), (Page)page);
        PriceParamVo priceParamVo = new PriceParamVo();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
            List codes = pageInfo.getList().stream().map(TmWareInfoVo::getWareCode).collect(Collectors.toList());
            priceParamVo.setProductCodes(codes);
            priceParamVo.setPriceDate(tmWareInfoPriceVo.getPriceDate());
            priceParamVo.setCustCode(custCode);
            List<PriceWareReturnVo> list = this.getStandPriceReturnVos(priceParamVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                Map<String, PriceWareReturnVo> map = list.stream().collect(Collectors.toMap(PriceWareReturnVo::getWareCode, item -> item));
                pageInfo.getList().forEach(item -> {
                    if (map.containsKey(item.getWareCode())) {
                        item.setPrice(((PriceWareReturnVo)map.get(item.getWareCode())).getPriceAmount());
                    }
                });
            }
        }
        return pageInfo;
    }

    @Override
    public PageInfo<TmWareInfoVo> findWarePriceList(TmWareInfoPriceVo tmWareInfoPriceVo) {
        String custCode = tmWareInfoPriceVo.getCustCode();
        List<TmOrgEntity> orgEntities = this.orgService.findOrgListByCustcode(custCode);
        ArrayList<String> orgCodes = new ArrayList<String>();
        orgCodes.add("ALL");
        if (CollectionUtil.listNotEmptyNotSizeZero(orgEntities)) {
            orgEntities.forEach(item -> {
                List<TmOrgVo> orgVos = this.orgService.getOrgUpById(item.getId());
                if (CollectionUtil.listNotEmptyNotSizeZero(orgVos)) {
                    orgVos.forEach(temp -> orgCodes.add(temp.getOrgCode()));
                }
            });
        }
        orgCodes.stream().distinct();
        List<String> noBuyCodes = this.tmWareSalerangeDao.findWareNoBuyList(orgCodes, custCode);
        FindWarePriceVo findWarePriceVo = new FindWarePriceVo();
        findWarePriceVo.setCustCode(custCode);
        Page page = new Page();
        page.setPage(tmWareInfoPriceVo.getPage());
        page.setRows(tmWareInfoPriceVo.getRows());
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.tmWareInfoDao.findWarePriceList(noBuyCodes, orgCodes, findWarePriceVo), (Page)page);
        PriceParamVo priceParamVo = new PriceParamVo();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
            List codes = pageInfo.getList().stream().map(TmWareInfoVo::getWareCode).collect(Collectors.toList());
            priceParamVo.setProductCodes(codes);
            priceParamVo.setPriceDate(tmWareInfoPriceVo.getPriceDate());
            priceParamVo.setCustCode(custCode);
            List<PriceWareReturnVo> list = this.getStandPriceReturnVos(priceParamVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                Map<String, PriceWareReturnVo> map = list.stream().collect(Collectors.toMap(PriceWareReturnVo::getWareCode, item -> item));
                pageInfo.getList().forEach(item -> {
                    if (map.containsKey(item.getWareCode())) {
                        item.setPrice(((PriceWareReturnVo)map.get(item.getWareCode())).getPriceAmount());
                    }
                });
            }
        }
        return pageInfo;
    }

    @Override
    public TmWareInfoEntity getTmWareInfoEntityByIdOrCode(String id, String code) {
        if (StringUtil.isNotBlank((CharSequence)id)) {
            return (TmWareInfoEntity)this.tmWareInfoDao.selectByPrimaryKey(id);
        }
        if (StringUtil.isNotBlank((CharSequence)code)) {
            Example example = new Example(TmWareInfoEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("wareCode", (Object)code);
            List wareInfoEntities = this.tmWareInfoDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)wareInfoEntities)) {
                return (TmWareInfoEntity)wareInfoEntities.get(0);
            }
        }
        return null;
    }

    @Override
    public AjaxJson startOrStop(TmWareInfoVo tmWareInfoVo) {
        AjaxJson j = new AjaxJson();
        TmWareInfoEntity tmWareInfoEntity = this.getTmWareInfoEntityByIdOrCode(tmWareInfoVo.getId(), "");
        if (StringUtil.isNotEmpty((Object)tmWareInfoEntity)) {
            if (tmWareInfoEntity.getEnableStatus().toString().equals(tmWareInfoVo.getEnableStatus().toString())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.equals(tmWareInfoVo.getEnableStatus()) ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                tmWareInfoEntity.setEnableStatus(tmWareInfoVo.getEnableStatus());
                this.tmWareInfoDao.updateByPrimaryKeySelective(tmWareInfoEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }
}

