/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.position.controller;

import com.biz.eisp.activiti.service.RoleActivitiService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.position.entity.TmPositionEntity;
import com.biz.eisp.position.service.PositionService;
import com.biz.eisp.user.TmUserVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MDM-\u804c\u4f4d"}, description="CRM-MDM MDM\u804c\u4f4d\u4fe1\u606f")
@RestController
@RequestMapping(value={"/mdmApi/positionApiController"})
public class PositionApiController {
    @Autowired
    private PositionService positionService;
    @Autowired
    private RoleActivitiService roleActivitiService;

    @ApiOperation(value="\u83b7\u53d6\u804c\u4f4d\u4fe1\u606f", notes="\u6839\u636e\u804c\u4f4dID\u6216\u8005\u804c\u4f4d\u7f16\u7801\u83b7\u53d6\u804c\u4f4d\u4fe1\u606f", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="posId", value="\u804c\u4f4dID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="posCode", value="\u804c\u4f4d\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getPosition"})
    public AjaxJson<TmPositionVo> getPosition(@RequestParam(value="posId", required=false) String posId, @RequestParam(value="posCode", required=false) String posCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TmPositionEntity tmPositionEntity = this.positionService.getTmPosition(posId, posCode);
        TmPositionVo tmPositionVo = new TmPositionVo();
        if (tmPositionVo == null) {
            ajaxJson.setObj(null);
        } else {
            BeanUtils.copyProperties((Object)tmPositionEntity, (Object)tmPositionVo);
            ajaxJson.setObj((Object)tmPositionVo);
        }
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u804c\u4f4d\u4fe1\u606f\u5217\u8868", notes="\u67e5\u8be2\u804c\u4f4d\u4fe1\u606f\u5217\u8868,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"findPositionByPage"})
    public AjaxJson<TmPositionVo> findPositionByPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmPositionVo> tmPositionEntitys = this.positionService.findTmPositionAndUserPage(param, page);
        ajaxJson.setPageInfo(tmPositionEntitys);
        return ajaxJson;
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u4f20\u804c\u4f4d\u7684\u4e0a\u7ea7\u804c\u4f4d\u7528\u6237", notes="\u83b7\u53d6\u6240\u4f20\u804c\u4f4d\u7684\u4e0a\u7ea7\u804c\u4f4d\u7528\u6237", httpMethod="POST")
    @PostMapping(value={"findUpPositionUser"})
    public AjaxJson<TmUserVo> findUpPositionUser(@RequestParam(value="posId", required=false) String posId) {
        AjaxJson<TmUserVo> ajaxJson = this.positionService.findUpPositionUser(posId);
        return ajaxJson;
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u6240\u6709\u804c\u4f4d\u4fe1\u606f", notes="\u7528\u6237\u6240\u6709\u804c\u4f4d\u4fe1\u606fObjList\uff0c\u4e0d\u6392\u9664\u505c\u7528", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="\u7528\u6237\u8d26\u53f7", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="id", value="\u7528\u6237ID", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getUserPositons"})
    public AjaxJson<TmPositionVo> getUserPositons(@RequestParam(value="userName", required=false) String userName, @RequestParam(value="id", required=false) String id) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmPositionVo> list = this.positionService.getUserPositons(userName, id);
        ajaxJson.setObjList(list);
        return ajaxJson;
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4e3b\u804c\u4f4d\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u4e3b\u804c\u4f4d\u4fe1\u606f\uff0c\u65e0\u7f13\u5b58\u3002 \u8fd4\u56de\u7ed3\u679cobj", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="\u7528\u6237\u8d26\u53f7", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="id", value="\u7528\u6237ID", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getUserMainPositon"})
    public AjaxJson<TmPositionVo> getUserMainPositon(@RequestParam(value="userName", required=false) String userName, @RequestParam(value="id", required=false) String id) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            TmPositionVo tmPositionVo = this.positionService.getUserMainPositon(userName, id);
            ajaxJson.setObj((Object)tmPositionVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u67e5\u8be2\u5931\u8d25");
        }
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u96c6\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u548c\u804c\u4f4d\u4fe1\u606f", notes="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u96c6\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u548c\u804c\u4f4d\u4fe1\u606f", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="posCodes", value="\u804c\u4f4d\u96c6", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"getUserAndPositionInfoByPosCodes"})
    public AjaxJson<TmPositionVo> getUserAndPositionInfoByPosCodes(@RequestParam(value="posCodes") String posCodes) {
        AjaxJson json = new AjaxJson();
        json.setObj((Object)this.positionService.getUserAndPositionInfoByPosCodes(posCodes));
        return json;
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u96c6\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u548c\u804c\u4f4d\u4fe1\u606f\u5217\u8868", notes="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u96c6\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u548c\u804c\u4f4d\u4fe1\u606f", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="posCodes", value="\u804c\u4f4d\u96c6", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"getUserAndPositionInfoByPosCodesList"})
    public AjaxJson<TmPositionVo> getUserAndPositionInfoByPosCodesList(@RequestParam(value="posCodes") String posCodes) {
        AjaxJson json = new AjaxJson();
        json.setList(this.positionService.getUserAndPositionInfoByPosCodesList(posCodes));
        return json;
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u83b7\u53d6\u804c\u4f4d\u5217\u8868", notes="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u83b7\u53d6\u804c\u4f4d\u5217\u8868,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\",\"roleCode\":\"\u89d2\u8272\u7f16\u7801\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"findPosByActRole"})
    public AjaxJson<TmPositionVo> findPosByActRole(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        String roleCode = param.get("roleCode").toString();
        PageInfo<TmPositionVo> pageInfo = this.roleActivitiService.findPosByActRole(roleCode, page);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\uff0c\u6216\u8005\u804c\u4f4d\u7f16\u7801\u83b7\u53d6 \u804c\u4f4d ", notes="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\uff0c\u6216\u8005\u804c\u4f4d\u7f16\u7801\u83b7\u53d6 \u804c\u4f4d", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u6d41\u7a0b\u89d2\u8272\u7f16\u7801", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="posId", value="\u804c\u4f4d", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getPositionByRoleCodeAndPositionId"})
    public AjaxJson<TmPositionVo> getPositionByRoleCodeAndPositionId(@RequestParam(value="roleCode", required=false) String roleCode, @RequestParam(value="posId", required=false) String posId) {
        AjaxJson json = new AjaxJson();
        json.setObj((Object)this.roleActivitiService.getPositionByRoleCodeAndPositionId(roleCode, posId));
        return json;
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\uff0c\u6216\u8005\u804c\u4f4d\u7f16\u7801\u83b7\u53d6 \u4e0a\u7ea7\u804c\u4f4d\u5217\u8868 ", notes="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\uff0c\u6216\u8005\u804c\u4f4d\u7f16\u7801\u83b7\u53d6 \u4e0a\u7ea7\u804c\u4f4d\u5217\u8868", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u6d41\u7a0b\u89d2\u8272\u7f16\u7801", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="posId", value="\u804c\u4f4d", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"findParentPositionByRoleCodeAndPositionId"})
    public AjaxJson<TmPositionVo> findParentPositionByRoleCodeAndPositionId(@RequestParam(value="roleCode", required=false) String roleCode, @RequestParam(value="posId", required=false) String posId) {
        AjaxJson json = new AjaxJson();
        json.setObjList(this.roleActivitiService.findParentPositionByRoleCodeAndPositionId(roleCode, posId));
        return json;
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\uff0c\u7ec4\u7ec7\uff0c\u7c7b\u578b\uff0c\u83b7\u53d6\u804c\u4f4d\u5217\u8868 ", notes="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\uff0c\u7ec4\u7ec7\uff0c\u7c7b\u578b\uff0c\u83b7\u53d6\u804c\u4f4d\u5217\u8868", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u6d41\u7a0b\u89d2\u8272\u7f16\u7801", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="orgId", value="\u7ec4\u7ec7", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="queryType", value="\u7c7b\u578b\uff0c0\uff1a\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\uff0c1\uff1a\u5f53\u524d\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\uff0c2\uff1a\u5f53\u524d\u7ec4\u7ec7\u53ca\u5176\u4e0a\u7ea7", required=false, dataType="Integer", paramType="query")})
    @GetMapping(value={"findPositionByRoleCodeAndOrgId"})
    public AjaxJson<TmPositionVo> findPositionByRoleCodeAndOrgId(@RequestParam(value="roleCode", required=false) String roleCode, @RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="queryType", required=false) Integer queryType) {
        AjaxJson json = new AjaxJson();
        json.setObjList(this.roleActivitiService.findPositionByRoleCodeAndOrgId(roleCode, orgId, queryType));
        return json;
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\uff0c\u83b7\u53d6\u804c\u4f4d\u5217\u8868\u53ca\u804c\u4f4d\u5bf9\u5e94\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u7ec4\u7ec7 ", notes="\u6839\u636e\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\uff0c\u7ec4\u7ec7\uff0c\u7c7b\u578b\uff0c\u83b7\u53d6\u804c\u4f4d\u5217\u8868", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u6d41\u7a0b\u89d2\u8272\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"findPositionAndOrgByRoleCode"})
    public AjaxJson<TmPositionVo> findPositionAndOrgByRoleCode(@RequestParam(value="roleCode") String roleCode) {
        AjaxJson json = new AjaxJson();
        json.setObjList(this.roleActivitiService.findPositionAndOrgByRoleCode(roleCode));
        return json;
    }

    @ApiOperation(value=" \u6839\u636e\u7528\u6237id\u6216\u8005\u7528\u6237\u767b\u5f55\u8d26\u53f7\u67e5\u8be2\u804c\u4f4d\u4e0b\u7ea7\u96c6\u5408 ", notes="\u6839\u636e\u7528\u6237id\u6216\u8005\u7528\u6237\u767b\u5f55\u8d26\u53f7\u67e5\u8be2\u804c\u4f4d\u4e0b\u7ea7\u96c6\u5408", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="userName", value="\u767b\u5f55\u8d26\u53f7", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="type", value="1\uff1a\u53ea\u67e5\u8be2\u4e3b\u804c\u4f4d\u53ca\u5176\u4e0b\u7ea7\uff0c0\uff1a\u67e5\u8be2\u6240\u6709\uff0c\u9ed8\u8ba4\u4e3a 0", required=false, dataType="Integer", paramType="query")})
    @GetMapping(value={"findAllPosByUser"})
    public AjaxJson<TmPositionVo> findAllPosByUser(@RequestParam(value="userId", required=false) String userId, @RequestParam(value="userName", required=false) String userName, @RequestParam(value="type", required=false) Integer type) {
        AjaxJson json = new AjaxJson();
        json.setObjList(this.positionService.findAllPosByUser(userId, userName, type));
        return json;
    }

    @ApiOperation(value=" \u6839\u636e\u7528\u6237id\u6216\u8005\u7528\u6237\u767b\u5f55\u8d26\u53f7\u67e5\u8be2\u804c\u4f4d\u4e0b\u7ea7 \u804c\u4f4d\u7f16\u7801\u96c6\u5408 ", notes="\u6839\u636e\u7528\u6237id\u6216\u8005\u7528\u6237\u767b\u5f55\u8d26\u53f7\u67e5\u8be2\u804c\u4f4d\u4e0b\u7ea7 \u804c\u4f4d\u7f16\u7801\u96c6\u5408", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="userName", value="\u767b\u5f55\u8d26\u53f7", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="type", value="1\uff1a\u53ea\u67e5\u8be2\u4e3b\u804c\u4f4d\u53ca\u5176\u4e0b\u7ea7\uff0c0\uff1a\u67e5\u8be2\u6240\u6709\uff0c\u9ed8\u8ba4\u4e3a 0", required=false, dataType="Integer", paramType="query")})
    @GetMapping(value={"findAllPosCodeByUser"})
    public AjaxJson<String> findAllPosCodeByUser(@RequestParam(value="userId", required=false) String userId, @RequestParam(value="userName", required=false) String userName, @RequestParam(value="type", required=false) Integer type) {
        AjaxJson json = new AjaxJson();
        List<Object> codes = new ArrayList();
        List<TmPositionVo> positionVos = this.positionService.findAllPosByUser(userId, userName, type);
        if (CollectionUtil.listNotEmptyNotSizeZero(positionVos)) {
            codes = positionVos.stream().map(TmPositionVo::getPositionCode).distinct().collect(Collectors.toList());
        }
        json.setObjList(codes);
        return json;
    }

    @ApiOperation(value=" \u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u6216\u8005\u7ec4\u7ec7id\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u6240\u6709\u5c97\u4f4d\u5217\u8868", notes="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u6216\u8005\u7ec4\u7ec7id\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u6240\u6709\u5c97\u4f4d\u5217\u8868", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgId", value="\u7ec4\u7ec7ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"findPosListByOrgDown"})
    public AjaxJson<TmPositionEntity> findPosListByOrgDown(@RequestParam(value="orgId", required=false) String orgId, @RequestParam(value="orgCode", required=false) String orgCode) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmPositionEntity> tmPositionEntities = this.positionService.findPosListByOrgDown(orgId, orgCode);
        ajaxJson.setList(tmPositionEntities);
        return ajaxJson;
    }

    @PostMapping(value={"findPositionListMainPage"})
    AjaxJson<TmPositionVo> findPositionListMainPage(@RequestBody TmPositionVo vo, @RequestParam(value="page") String page, @RequestParam(value="rows") String rows) {
        Page p = new Page();
        p.setPage(page);
        p.setRows(rows);
        AjaxJson ajaxJson = new AjaxJson();
        PageInfo pageInfo = this.positionService.findPositionListMainPage(vo, p);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @ApiOperation(value=" \u6839\u636e\u804c\u4f4d\u7f16\u7801\u6216\u8005ID\uff0c\u83b7\u53d6\u4e0a\u7ea7\u804c\u4f4d\u4fe1\u606f", notes="\u6839\u636e\u804c\u4f4d\u7f16\u7801\u6216\u8005ID\uff0c\u83b7\u53d6\u4e0a\u7ea7\u804c\u4f4d\u4fe1\u606f", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u804c\u4f4dID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="posCode", value="\u804c\u4f4d\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getParentByIdOrPosCode"})
    public AjaxJson<TmPositionEntity> getParentByIdOrPosCode(@RequestParam(value="id", required=false) String id, @RequestParam(value="posCode", required=false) String posCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TmPositionEntity tmPosition = this.positionService.getParentByIdOrPosCode(id, posCode);
        ajaxJson.setObj((Object)tmPosition);
        return ajaxJson;
    }
}

