/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.role.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.position.service.PositionService;
import com.biz.eisp.role.TmRoleVo;
import com.biz.eisp.role.dao.RoleDao;
import com.biz.eisp.role.service.RoleService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RoleServiceImpl
implements RoleService {
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private PositionService positionService;

    @Override
    public List<TmRoleVo> getRolesByPos(String posId, String posCode) {
        if (StringUtil.isEmpty((String)posId) && StringUtil.isEmpty((String)posCode)) {
            return null;
        }
        return this.roleDao.getRolesByPos(posId, posCode);
    }

    @Override
    public List<TmRoleVo> getRolesByUser(String userId, String username) {
        List<TmPositionVo> listPos = this.positionService.getUserPositons(username, userId);
        if (CollectionUtil.listEmpty(listPos)) {
            return null;
        }
        List<String> posIds = listPos.stream().map(TmPositionVo::getId).collect(Collectors.toList());
        return this.roleDao.getRolesByPosList(posIds);
    }
}

