/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.ware.controller;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.customer.TmCustomerVo;
import com.biz.eisp.customer.service.CustomerService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.price.PriceParamVo;
import com.biz.eisp.price.PriceWareReturnVo;
import com.biz.eisp.ware.entity.TmWareInfoEntity;
import com.biz.eisp.ware.service.GetWareStandPriceCommonExtend;
import com.biz.eisp.ware.service.TmWareInfoNoCostPriceWareExtend;
import com.biz.eisp.ware.service.TmWareInfoNoStandPriceWareExtend;
import com.biz.eisp.ware.service.TmWareInfoService;
import com.biz.eisp.ware.vo.TmWareInfoPriceVo;
import com.biz.eisp.ware.vo.TmWareInfoVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MDM-\u5546\u54c1"}, description="CRM-MDM MDM\u5546\u54c1\u4fe1\u606f")
@RestController
@RequestMapping(value={"/mdmApi/tmWareInfoApiController"})
public class TmWareInfoApiController {
    @Autowired
    private TmWareInfoService tmWareInfoService;
    @Autowired(required=false)
    private TmWareInfoNoStandPriceWareExtend tmWareInfoNoStandPriceWareExtend;
    @Autowired(required=false)
    private TmWareInfoNoCostPriceWareExtend tmWareInfoNoCostPriceWareExtend;
    @Autowired(required=false)
    private GetWareStandPriceCommonExtend getWareStandPriceCommonExtend;
    @Autowired
    private CustomerService customerService;

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u5546\u54c1\u4fe1\u606f", notes="\u6839\u636e\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\uff0c{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\"},\u8fd4\u56de\u503c\u5728PageInfo", httpMethod="POST")
    @PostMapping(value={"findTmWareInfoPage"})
    public AjaxJson<TmWareInfoEntity> findTmWareInfoPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmWareInfoEntity> pageInfo = this.tmWareInfoService.findTmWareInfoPageNew(param, page);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u4fe1\u606f", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u4fe1\u606f,\u8fd4\u56de\u503c\u5728objList", httpMethod="POST")
    @GetMapping(value={"findTmWareInfoList"})
    public AjaxJson<TmWareInfoEntity> findTmWareInfoList(@RequestBody TmWareInfoVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmWareInfoEntity> list = this.tmWareInfoService.findTmWareInfoList(vo);
        ajaxJson.setObjList(list);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5546\u54c1\u4fe1\u606f", notes="\u6839\u636eid\u67e5\u8be2\u5546\u54c1\u4fe1\u606f,\u8fd4\u56de\u503c\u5728obj", httpMethod="POST")
    @GetMapping(value={"getTmWareInfoEntityById"})
    public AjaxJson<TmWareInfoEntity> getTmWareInfoEntityById(@RequestParam(value="id", required=false) String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TmWareInfoEntity entity = this.tmWareInfoService.getTmWareInfoEntityById(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636eid\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5546\u54c1\u4fe1\u606f", notes="\u6839\u636eid\u67e5\u8be2\u5546\u54c1\u4fe1\u606f,\u8fd4\u56de\u503c\u5728obj", httpMethod="POST")
    @GetMapping(value={"getTmWareInfoEntityByIdOrCode"})
    public AjaxJson<TmWareInfoEntity> getTmWareInfoEntityByIdOrCode(@RequestParam(value="id", required=false) String id, @RequestParam(value="code", required=false) String code) {
        AjaxJson ajaxJson = new AjaxJson();
        TmWareInfoEntity entity = this.tmWareInfoService.getTmWareInfoEntityByIdOrCode(id, code);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @ApiOperation(value="\u65b0\u589e\u5546\u54c1\u4fe1\u606f", notes="\u65b0\u589e\u5546\u54c1\u4fe1\u606f", httpMethod="POST")
    @GetMapping(value={"saveTmWareInfo"})
    public AjaxJson saveTmWareInfo(@RequestBody TmWareInfoVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        this.tmWareInfoService.save(vo);
        return ajaxJson;
    }

    @ApiOperation(value="\u4fee\u6539\u5546\u54c1\u4fe1\u606f", notes="\u4fee\u6539\u5546\u54c1\u4fe1\u606f", httpMethod="POST")
    @GetMapping(value={"updateTmWareInfo"})
    public AjaxJson updateTmWareInfo(@RequestBody TmWareInfoVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        this.tmWareInfoService.update(vo);
        return ajaxJson;
    }

    @ApiOperation(value="\u5220\u9664\u5546\u54c1\u4fe1\u606f", notes="\u5220\u9664\u5546\u54c1\u4fe1\u606f", httpMethod="POST")
    @GetMapping(value={"deleteTmWareInfo"})
    public AjaxJson deleteTmWareInfo(@RequestParam(value="ids") String ids) {
        AjaxJson ajaxJson = new AjaxJson();
        boolean rs = this.tmWareInfoService.delete(ids);
        ajaxJson.setSuccess(rs);
        return ajaxJson;
    }

    @ApiOperation(value="\u4fdd\u5b58\u5546\u54c1\u4fe1\u606f\u53ca\u5176\u5173\u8054\u4fe1\u606f", notes="\u4fdd\u5b58\u5546\u54c1\u4fe1\u606f\u53ca\u5176\u5173\u8054\u4fe1\u606f", httpMethod="POST")
    @PostMapping(value={"saveWareProduct"})
    public AjaxJson saveWareProduct(@RequestBody TmWareInfoVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = this.tmWareInfoService.saveWareProduct(vo);
        return ajaxJson;
    }

    @ApiOperation(value="\u53d6\u5546\u54c1\u6807\u51c6\u4ef7\u683c", notes="\u516c\u7528\u83b7\u53d6\u5546\u54c1\u6807\u51c6\u4ef7\u683c,\u8fd4\u56de\u6570\u636e \u5728objList", httpMethod="POST")
    @PostMapping(value={"getWareStandPriceCommon"})
    public AjaxJson<PriceWareReturnVo> getWareStandPriceCommon(@RequestBody PriceParamVo priceParamVo) {
        TmCustomerVo tmCustomerVo;
        AjaxJson ajaxJson = new AjaxJson();
        List strings = priceParamVo.getProductCodes();
        if (StringUtil.isEmpty((String)priceParamVo.getPriceType())) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u4ef7\u683c\u7c7b\u578b\u4e0d\u5f97\u4e3a\u7a7a");
            return ajaxJson;
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)strings)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u5546\u54c1\u7f16\u7801\u4e0d\u5f97\u4e3a\u7a7a");
            return ajaxJson;
        }
        if (!StringUtils.isEmpty((CharSequence)priceParamVo.getCustCode()) && StringUtils.isEmpty((CharSequence)priceParamVo.getPriceGroup()) && null != (tmCustomerVo = this.customerService.getCustomerByIdOrCode(null, priceParamVo.getCustCode()))) {
            priceParamVo.setPriceGroup(tmCustomerVo.getPriceGroup());
        }
        List<Object> priceReturnVos = new ArrayList();
        priceReturnVos = this.getWareStandPriceCommonExtend != null ? this.getWareStandPriceCommonExtend.getStandPriceReturnVos(priceParamVo) : this.tmWareInfoService.getStandPriceReturnVos(priceParamVo);
        ajaxJson.setList(priceReturnVos);
        return ajaxJson;
    }

    @ApiOperation(value="\u53d6\u5546\u54c1\u6807\u51c6\u4ef7\u683c\u6307\u9488\u5bf9\u4ea7\u54c1+\u5ba2\u6237\u7ef4\u5ea6", notes="\u83b7\u53d6\u4ea7\u54c1+\u5ba2\u6237\u7ef4\u5ea6\u5546\u54c1\u6807\u51c6\u4ef7\u683c,\u8fd4\u56de\u6570\u636e \u5728objList", httpMethod="POST")
    @PostMapping(value={"getCustWareStandPriceCommon"})
    public AjaxJson<PriceWareReturnVo> getCustWareStandPriceCommon(@RequestBody PriceParamVo priceParamVo) {
        AjaxJson ajaxJson = new AjaxJson();
        List strings = priceParamVo.getProductCodes();
        if (StringUtil.isEmpty((String)priceParamVo.getPriceType())) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u4ef7\u683c\u7c7b\u578b\u4e0d\u5f97\u4e3a\u7a7a");
            return ajaxJson;
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)strings)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u5546\u54c1\u7f16\u7801\u4e0d\u5f97\u4e3a\u7a7a");
            return ajaxJson;
        }
        List<PriceWareReturnVo> priceReturnVos = this.tmWareInfoService.getCustStandPriceReturnVos(priceParamVo);
        ajaxJson.setList(priceReturnVos);
        return ajaxJson;
    }

    @ApiOperation(value="\u53d6\u5546\u54c1\u6210\u672c\u4ef7", notes="\u516c\u7528\u83b7\u53d6\u5546\u54c1\u6210\u672c\u4ef7,\u8fd4\u56de\u6570\u636e \u5728objList", httpMethod="POST")
    @PostMapping(value={"getWareCostPriceCommon"})
    public AjaxJson<PriceWareReturnVo> getWareCostPriceCommon(@RequestBody PriceParamVo priceParamVo) {
        AjaxJson ajaxJson = new AjaxJson();
        List strings = priceParamVo.getProductCodes();
        if (!CollectionUtil.listNotEmptyNotSizeZero((List)strings)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u5546\u54c1\u7f16\u7801\u4e0d\u5f97\u4e3a\u7a7a");
            return ajaxJson;
        }
        List<PriceWareReturnVo> priceReturnVos = this.tmWareInfoService.getCostPriceReturnVos(priceParamVo);
        ajaxJson.setList(priceReturnVos);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u5e26\u6807\u51c6\u4ef7\u5546\u54c1\u5217\u8868", notes="\u67e5\u8be2\u5e26\u6807\u51c6\u4ef7\u5546\u54c1\u5217\u8868,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"findWareInfoStandPriceByPage"})
    public AjaxJson<TmWareInfoEntity> findWareInfoStandPriceByPage(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        String priceType = param.containsKey("priceType") && param.get("priceType") != null ? param.get("priceType").toString() : "type1";
        String priceGroup = param.containsKey("priceGroup") && param.get("priceGroup") != null ? param.get("priceGroup").toString() : "";
        String custCode = param.containsKey("custCode") && param.get("custCode") != null ? param.get("custCode").toString() : "";
        String priceDate = param.containsKey("priceDate") && param.get("priceDate") != null ? param.get("priceDate").toString() : "";
        TmWareInfoVo tmWareInfoVo = new TmWareInfoVo();
        tmWareInfoVo.setPriceType(priceType);
        tmWareInfoVo.setPriceGroup(priceGroup);
        tmWareInfoVo.setCustCode(custCode);
        tmWareInfoVo.setPriceDate(priceDate);
        ArrayList<PriceWareReturnVo> priceReturnVos = new ArrayList<PriceWareReturnVo>();
        List<Object> list = new ArrayList();
        list = this.tmWareInfoNoStandPriceWareExtend != null ? this.tmWareInfoNoStandPriceWareExtend.getAllNoStandPriceWare(tmWareInfoVo, priceReturnVos) : this.tmWareInfoService.getAllNoStandPriceWare(tmWareInfoVo, priceReturnVos);
        list = list == null ? new ArrayList() : list;
        Map<String, BigDecimal> priceMap = priceReturnVos.stream().collect(Collectors.toMap(PriceWareReturnVo::getWareCode, PriceWareReturnVo::getPriceAmount));
        List<String> notCodes = list.stream().map(TmWareInfoEntity::getWareCode).collect(Collectors.toList());
        param.put("enableStatus", ConstantEnum.StatusEnum.NEW.getValue());
        PageInfo<TmWareInfoEntity> tmFunctionEntities = this.tmWareInfoService.findWareInfoPriceByPage(param, page, notCodes);
        tmFunctionEntities.getList().forEach(item -> item.setStandPrice((BigDecimal)priceMap.get(item.getWareCode())));
        ajaxJson.setPageInfo(tmFunctionEntities);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u5e26\u6210\u672c\u4ef7\u5546\u54c1\u5217\u8868", notes="\u67e5\u8be2\u5e26\u6210\u672c\u4ef7\u5546\u54c1\u5217\u8868,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="POST")
    @PostMapping(value={"findWareInfoCostPriceByPage"})
    public AjaxJson<TmWareInfoEntity> findWareInfoCostPriceByPage(@RequestBody Map<String, Object> param) {
        List<Object> list;
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        TmWareInfoVo tmWareInfoVo = new TmWareInfoVo();
        ArrayList<PriceWareReturnVo> priceReturnVos = new ArrayList<PriceWareReturnVo>();
        if (this.tmWareInfoNoCostPriceWareExtend != null) {
            tmWareInfoVo.setCustCode(String.valueOf(param.get("custCode")));
            tmWareInfoVo.setStartTime(String.valueOf(param.get("startTime")));
            list = this.tmWareInfoNoCostPriceWareExtend.getAllNoCostPriceWare(tmWareInfoVo, priceReturnVos);
        } else {
            list = this.tmWareInfoService.getAllNoCostPriceWare(tmWareInfoVo, priceReturnVos);
        }
        list = list == null ? new ArrayList() : list;
        Map<String, BigDecimal> priceMap = priceReturnVos.stream().collect(Collectors.toMap(PriceWareReturnVo::getWareCode, PriceWareReturnVo::getPriceAmount));
        List<String> notCodes = list.stream().map(TmWareInfoEntity::getWareCode).collect(Collectors.toList());
        param.put("enableStatus", ConstantEnum.StatusEnum.NEW.getValue());
        PageInfo<TmWareInfoEntity> tmFunctionEntities = this.tmWareInfoService.findWareInfoPriceByPage(param, page, notCodes);
        tmFunctionEntities.getList().forEach(item -> item.setCostPrice((BigDecimal)priceMap.get(item.getWareCode())));
        ajaxJson.setPageInfo(tmFunctionEntities);
        return ajaxJson;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5546\u54c1\u6570\u636e", notes="\u5206\u9875\u67e5\u8be2\u5546\u54c1\u6570\u636e\u5305\u542b\u4ef7\u683c", httpMethod="POST")
    @PostMapping(value={"findWarePriceList"})
    public AjaxJson<TmWareInfoVo> findWarePriceList(@RequestBody TmWareInfoPriceVo tmWareInfoPriceVo) {
        AjaxJson ajaxJson = new AjaxJson();
        PageInfo<TmWareInfoVo> tmWareInfoVoPageInfo = this.tmWareInfoService.findWarePriceList(tmWareInfoPriceVo);
        ajaxJson.setPageInfo(tmWareInfoVoPageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u5206\u9875\u81ea\u5b9a\u4e49\u8303\u56f4\u67e5\u8be2\u5546\u54c1\u6570\u636e", notes="\u5206\u9875\u81ea\u5b9a\u4e49\u8303\u56f4\u67e5\u8be2\u5546\u54c1\u6570\u636e", httpMethod="POST")
    @PostMapping(value={"findWarePriceSelfList"})
    public AjaxJson<TmWareInfoVo> findWarePriceSelfList(@RequestBody TmWareInfoPriceVo tmWareInfoPriceVo) {
        AjaxJson ajaxJson = new AjaxJson();
        PageInfo<TmWareInfoVo> tmWareInfoVoPageInfo = this.tmWareInfoService.findWarePriceSelfList(tmWareInfoPriceVo);
        ajaxJson.setPageInfo(tmWareInfoVoPageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u4fee\u6539\u5546\u54c1\u72b6\u6001\u662f\u542f\u7528\u8fd8\u662f\u505c\u7528", notes="\u4fee\u6539\u5546\u54c1\u72b6\u6001\u662f\u542f\u7528\u8fd8\u662f\u505c\u7528", httpMethod="POST")
    @PostMapping(value={"startOrStop"})
    public AjaxJson startOrStop(@RequestBody TmWareInfoVo tmWareInfoVo) {
        AjaxJson json = new AjaxJson();
        try {
            json = this.tmWareInfoService.startOrStop(tmWareInfoVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return json;
    }

    @RequestMapping(value={"findTmWareInfoListPage"})
    public DataGrid findTmWareInfoListPage(HttpServletRequest request, TmWareInfoVo tmWareInfoVo) {
        EuPage page = new EuPage(request);
        HashMap<String, Object> param = new HashMap<String, Object>();
        MyBeanUtils.copyBean2Map(param, (Object)tmWareInfoVo);
        PageInfo<TmWareInfoVo> wareInfoPage = this.tmWareInfoService.findTmWareInfoPage(param, (Page)page);
        return new DataGrid(wareInfoPage);
    }
}

