/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.product.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.custproduct.entity.TmCustProductEntity;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.product.dao.TmCustProductDao;
import com.biz.eisp.product.service.TmCustProductService;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TmCustProductServiceImpl
extends BaseServiceImpl
implements TmCustProductService {
    private static final Logger log = LoggerFactory.getLogger(TmCustProductServiceImpl.class);
    @Autowired
    private TmCustProductDao tmCustProductDao;

    @Override
    public PageInfo<TmCustProductEntity> findCustProductByPage(TmCustProductEntity vo, Page page) {
        List<TmCustProductEntity> list = this.tmCustProductDao.findCustProductList(vo);
        return PageAutoHelperUtil.generatePage(() -> list, (Page)page);
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TmCustProductServiceImpl.class)
    public AjaxJson saveEntity(TmCustProductEntity vo) {
        AjaxJson ajaxjson = new AjaxJson();
        int num = this.tmCustProductDao.insertSelective(vo);
        if (num > 0) {
            ajaxjson.setMsg("\u4fdd\u5b58\u6210\u529f");
        } else {
            ajaxjson.setMsg("\u4fdd\u5b58\u5931\u8d25");
        }
        return ajaxjson;
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=TmCustProductServiceImpl.class)
    public boolean delete(String ids) {
        if (!ids.isEmpty()) {
            int i = this.tmCustProductDao.deleteByIds(ids);
            return i > 0;
        }
        return false;
    }

    @Override
    public TmCustProductEntity getCustProductById(String id) {
        TmCustProductEntity entity = null;
        if (StringUtil.isEmpty((String)id)) {
            return entity;
        }
        entity = (TmCustProductEntity)this.tmCustProductDao.selectByPrimaryKey(id);
        return entity;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TmCustProductServiceImpl.class)
    public AjaxJson updateEntity(TmCustProductEntity vo) {
        TmCustProductEntity tmCustProductEntity = (TmCustProductEntity)this.tmCustProductDao.selectByPrimaryKey(vo.getId());
        AjaxJson ajaxjson = new AjaxJson();
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)vo, (Object)tmCustProductEntity);
        }
        catch (Exception e) {
            log.error("\u5bf9\u8c61\u8f6c\u6362\u51fa\u9519");
            ajaxjson.setErrMsg("TmCustProductServiceImpl>>updateEntity:\u5bf9\u8c61\u8f6c\u6362\u51fa\u9519");
        }
        this.tmCustProductDao.updateByPrimaryKey(tmCustProductEntity);
        return ajaxjson;
    }
}

