/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.terminal.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.terminal.TmTermCustPostVo;
import com.biz.eisp.terminal.TmTerminalVo;
import com.biz.eisp.terminal.entity.TmTerminalEntity;
import com.biz.eisp.terminal.service.TerminalService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MDM-\u7ec8\u7aef"}, description="CRM-MDM MDM\u7ec8\u7aef")
@RestController
@RequestMapping(value={"/mdmApi/terminalController"})
public class TerminalController {
    @Autowired
    private TerminalService terminalService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u95e8\u5e97\u5217\u8868", notes="\u5206\u9875\u67e5\u8be2\u95e8\u5e97\u5217\u8868", httpMethod="POST")
    @PostMapping(value={"findTmApiTerminalPage"})
    public DataGrid findTmApiTerminalPage(HttpServletRequest request, TmTerminalVo tmTerminalVo) {
        PageInfo<TmTerminalVo> info;
        EuPage page = new EuPage(request);
        ArrayList<String> custCodes = new ArrayList<String>();
        if (StringUtil.isNotEmpty((CharSequence)tmTerminalVo.getCustList())) {
            String[] cust_str = tmTerminalVo.getCustList().toString().split(",");
            for (int i = 0; i < cust_str.length; ++i) {
                custCodes.add(cust_str[i]);
            }
        }
        if ((info = this.terminalService.getTerminalPage(tmTerminalVo, (Page)page, custCodes)) != null) {
            return new DataGrid(info);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f", notes="\u6839\u636eid\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\uff0c\u8fd4\u56deObj", httpMethod="GET")
    @GetMapping(value={"getTerminalById"})
    public AjaxJson<TmTerminalEntity> getTerminalById(@RequestParam(value="clientId") String clientId) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setObj((Object)this.terminalService.getTerminalById(clientId));
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u5217\u8868\u67e5\u8be2\u5bf9\u5e94\u7684\u95e8\u5e97\u5217\u8868", notes="\u6839\u636e\u7ec4\u7ec7\u5217\u8868\u67e5\u8be2\u5bf9\u5e94\u7684\u95e8\u5e97\u5217\u8868\uff0c\u8fd4\u56deObjList", httpMethod="POST")
    @PostMapping(value={"findTerminalsByOrgCodes"})
    public AjaxJson<String> findTerminalsByOrgCodes(@RequestBody List<String> orgCodes) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setObjList(this.terminalService.findTerminalsByOrgCodes(orgCodes));
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u95e8\u5e97Code\u67e5\u8be2\u95e8\u5e97\u5197\u4f59\u4fe1\u606f", notes="\u6839\u636e\u95e8\u5e97Code\u67e5\u8be2\u95e8\u5e97\u5197\u4f59\u4fe1\u606f\uff0c\u95e8\u5e97\u4fe1\u606f\u5728list", httpMethod="GET")
    @GetMapping(value={"getTerminalsDetailByCode"})
    public AjaxJson<TmTermCustPostVo> getTerminalsDetailByCode(@RequestParam(value="terminalCode", required=false) String terminalCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TmTerminalVo tmTerminalVo = this.terminalService.getTerminalByCode(terminalCode);
        if (tmTerminalVo != null) {
            List<TmTermCustPostVo> tmTermCustPostVos = this.terminalService.findTermCustPostList(tmTerminalVo.getId());
            ajaxJson.setObjList(tmTermCustPostVos);
        }
        return ajaxJson;
    }
}

