/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.user.controller;

import com.biz.eisp.actuser.vo.MdmActIdUserVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.mdm.user.NowUserVo;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.org.service.OrgService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.position.service.PositionService;
import com.biz.eisp.user.TmUserQueryVo;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.user.entity.TmUserEntity;
import com.biz.eisp.user.service.UserService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MDM-\u7528\u6237"}, description="CRM-MDM MDM\u7528\u6237\u4fe1\u606f")
@RestController
@RequestMapping(value={"/mdmApi/userApiController"})
public class UserApiController {
    private static final Logger log = LoggerFactory.getLogger(UserApiController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrgService orgService;

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u552f\u4e00\u7528\u6237\u4fe1\u606f", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u552f\u4e00\u7528\u6237\u4fe1\u606fobj,\u7528\u6237\u81ea\u8eab\u5c5e\u6027\u9ad8\u4e8e\u5176\u4ed6\u5c5e\u6027", httpMethod="POST")
    @PostMapping(value={"getTmUser"})
    public AjaxJson<TmUserVo> getTmUser(@RequestBody TmUserQueryVo tmUserQueryVo) {
        AjaxJson ajaxJson = new AjaxJson();
        TmUserVo tmUserVo = this.userService.getTmUser(tmUserQueryVo);
        ajaxJson.setObj((Object)tmUserVo);
        return ajaxJson;
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u542f\u7528\u7528\u6237", notes="\u83b7\u53d6\u6240\u6709\u542f\u7528\u7528\u6237", httpMethod="GET")
    @PostMapping(value={"getAllUserList"})
    public AjaxJson<TmUserVo> getAllUserList(@RequestBody TmUserQueryVo tmUserQueryVo) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmUserVo> tmUserVos = this.userService.getAllUserList(tmUserQueryVo);
        ajaxJson.setObjList(tmUserVos);
        return ajaxJson;
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u542f\u7528\u7528\u6237\u5e26\u5206\u9875", notes="\u83b7\u53d6\u6240\u6709\u542f\u7528\u7528\u6237\u5e26\u5206\u9875", httpMethod="GET")
    @PostMapping(value={"findAllUserDetailPage"})
    public AjaxJson<TmUserVo> findAllUserDetailPage(@RequestBody TmUserQueryVo tmUserQueryVo) {
        AjaxJson ajaxJson = new AjaxJson();
        EuPage page = new EuPage();
        PageInfo<TmUserVo> pageInfo = this.userService.findAllUserDetailPage(tmUserQueryVo, (Page)page);
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u542f\u7528\u7528\u6237\u53ca\u5176\u804c\u4f4d", notes="\u83b7\u53d6\u6240\u6709\u542f\u7528\u7528\u6237\u53ca\u5176\u804c\u4f4d,{\"page\":\"\u5f53\u524d\u9875\",\"rows\":\"\u6bcf\u9875\u884c\u6570\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728pageInfo", httpMethod="GET")
    @PostMapping(value={"getAllUserAndPositionList"})
    public AjaxJson<TmUserVo> getAllUserAndPositionList(@RequestBody Map<String, Object> param) {
        AjaxJson ajaxJson = new AjaxJson();
        Page page = new Page(param);
        PageInfo<TmUserVo> tmUserVos = this.userService.getAllUserAndPositionList(param, page);
        ajaxJson.setPageInfo(tmUserVos);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u67e5\u8be2\u7528\u6237", notes="\u6839\u636e\u804c\u4f4d\u67e5\u8be2\u7528\u6237\u8fd4\u56de\u7ed3\u679cobj", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="posId", value="\u804c\u4f4did", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"findPositionUser"})
    public AjaxJson<TmUserVo> findPositionUser(@RequestParam(value="posId", required=false) String posId) {
        return this.positionService.findPositionUser(posId);
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u67e5\u8be2\u7528\u6237", notes="\u6839\u636e\u804c\u4f4d\u67e5\u8be2\u7528\u6237\u8fd4\u56de\u7ed3\u679cobj", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="posId", value="\u804c\u4f4did", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="posCode", value="\u804c\u4f4d\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"findPositionUserByIdOrCode"})
    public AjaxJson<TmUserEntity> findPositionUserByIdOrCode(@RequestParam(value="posId", required=false) String posId, @RequestParam(value="posCode", required=false) String posCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TmUserEntity entity = this.positionService.findPositionUserByIdOrCode(posId, posCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @ApiOperation(value="\u5de5\u4f5c\u6d41\u67e5\u8be2\u7528\u6237", notes="\u5de5\u4f5c\u6d41\u67e5\u8be2\u7528\u6237", httpMethod="POST")
    @PostMapping(value={"/findMdmActIdUserPageListByVoUseuser"})
    public AjaxJson<MdmActIdUserVo> findMdmActIdUserPageListByVoUseuser(@RequestBody MdmActIdUserVo voInfo, @RequestParam(value="pageNum") String pageNum, @RequestParam(value="pageSize") String pageSize) {
        AjaxJson json = new AjaxJson();
        Page pageFront = new Page(pageNum, pageSize);
        json.setPageInfo(this.userService.findMdmActIdUserPageListByVoUseuser(voInfo, pageFront));
        return json;
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0b\u7ea7\u6240\u6709\u4eba\u5458", notes="\u67e5\u8be2\u4e0b\u7ea7\u6240\u6709\u4eba\u5458", httpMethod="POST")
    @PostMapping(value={"getDownUserByCon"})
    public AjaxJson<TmUserVo> getDownUserByCon(@RequestBody Map<String, Object> param) {
        AjaxJson j = new AjaxJson();
        try {
            j.setPageInfo(this.userService.getDownUserByCon(param));
        }
        catch (BusinessException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f", notes="\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f", httpMethod="POST")
    @PostMapping(value={"getOwnUserinfo"})
    public AjaxJson<TmUserQueryVo> getOwnUserinfo() {
        AjaxJson j = new AjaxJson();
        try {
            j.setObjList(this.userService.getOwnUserinfo());
        }
        catch (BusinessException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801", notes="\u4fee\u6539\u5bc6\u7801\uff0c\u4f20\u9012\u8d26\u53f7username\uff0c\u8001\u5bc6\u7801oldPas\uff0c\u65b0\u5bc6\u7801newPas", httpMethod="POST")
    @PostMapping(value={"changeUserPassword"})
    public AjaxJson changeUserPassword(@RequestParam(value="username") String username, @RequestParam(value="oldPas") String oldPas, @RequestParam(value="newPas") String newPas) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.userService.changeUserPassword(username, oldPas, newPas);
        }
        catch (BusinessException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55", notes="\u4fee\u6539\u5bc6\u7801", httpMethod="POST")
    @PostMapping(value={"signOut"})
    public AjaxJson signOut() {
        AjaxJson j = new AjaxJson();
        try {
            j = this.userService.signOut();
        }
        catch (BusinessException e) {
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            j.setSuccess(false);
            j.setMsg(e.getMessage());
        }
        return j;
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4d\u96c6\u5408List\u83b7\u53d6\u5bf9\u5e94\u7528\u6237", notes="\u6839\u636e\u804c\u4f4d\u96c6\u5408List\u83b7\u53d6\u5bf9\u5e94\u7528\u6237", httpMethod="POST")
    @PostMapping(value={"posFindUserByPositons"})
    public AjaxJson<TmUserEntity> posFindUserByPositons(@RequestBody List<String> positions) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmUserEntity> entities = this.userService.findUserByPositons(positions);
        ajaxJson.setList(entities);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4fe1\u606f \u9644\u4ef6\u4e0d\u540c\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", notes="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u4fe1\u606f \u9644\u4ef6\u4e0d\u540c\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", httpMethod="POST")
    @PostMapping(value={"posNowUserVo"})
    public AjaxJson<NowUserVo> posNowUserVo(@RequestBody List<String> orgTypes) {
        AjaxJson ajaxJson = new AjaxJson();
        NowUserVo nowUserVo = new NowUserVo();
        UserRedis userRedis = UserUtils.getUser();
        nowUserVo.setUserRedis(userRedis);
        Map<String, TmOrgVo> orgMap = this.orgService.mapOrgByOrgtypeUp(orgTypes, userRedis.getPosCode());
        ArrayList tmOrgVos = new ArrayList();
        orgMap.forEach((k, v) -> tmOrgVos.add(v));
        nowUserVo.setOrgVos(tmOrgVos);
        ajaxJson.setObj((Object)nowUserVo);
        return ajaxJson;
    }
}

