/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.ware.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.ware.dao.TmWareProductDao;
import com.biz.eisp.ware.entity.TmWareProductEntity;
import com.biz.eisp.ware.service.TmWareProductService;
import com.biz.eisp.ware.vo.TmWareProductVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TmWareProductServiceImpl
implements TmWareProductService {
    @Autowired
    private TmWareProductDao tmWareProductDao;

    @Override
    public List<TmWareProductEntity> findTmWareProductList(TmWareProductVo vo) {
        Example example = new Example(TmWareProductEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getWareCode())) {
            criteria.andEqualTo("wareCode", (Object)vo.getWareCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getWareName())) {
            criteria.andLike("wareName", "%" + vo.getWareName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getProductInfoCode())) {
            criteria.andEqualTo("productInfoCode", (Object)vo.getProductInfoCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getProductInfoName())) {
            criteria.andLike("productInfoName", "%" + vo.getProductInfoName() + "%");
        }
        return this.tmWareProductDao.selectByExample(example);
    }

    @Override
    public TmWareProductEntity getTmWareProductEntityById(String id) {
        return (TmWareProductEntity)this.tmWareProductDao.selectByPrimaryKey(id);
    }

    @Override
    public boolean delete(String id) {
        TmWareProductEntity tmWareProductEntity = (TmWareProductEntity)this.tmWareProductDao.selectByPrimaryKey(id);
        int i = this.tmWareProductDao.delete(tmWareProductEntity);
        return i > 0;
    }

    @Override
    public void save(TmWareProductVo vo) {
        TmWareProductEntity entity = new TmWareProductEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            entity = this.getTmWareProductEntity(vo);
            this.tmWareProductDao.insertSelective(entity);
        }
    }

    @Override
    public void update(TmWareProductVo vo) {
        TmWareProductEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = this.getTmWareProductEntity(vo);
            this.tmWareProductDao.updateByPrimaryKeySelective(entity);
        }
    }

    private TmWareProductEntity getTmWareProductEntity(TmWareProductVo vo) {
        TmWareProductEntity entity = new TmWareProductEntity();
        entity.setId(vo.getId());
        entity.setEnableStatus(vo.getEnableStatus());
        entity.setWareId(vo.getWareId());
        entity.setWareCode(vo.getWareCode());
        entity.setWareName(vo.getWareName());
        entity.setProductInfoId(vo.getProductInfoId());
        entity.setProductInfoCode(vo.getProductInfoCode());
        entity.setProductInfoName(vo.getProductInfoName());
        entity.setProductNum(vo.getProductNum());
        return entity;
    }
}

