/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.ware.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.ware.dao.TmWareTextDao;
import com.biz.eisp.ware.entity.TmWareTextEntity;
import com.biz.eisp.ware.service.TmWareTextService;
import com.biz.eisp.ware.vo.TmWareTextVo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TmWareTextServiceImpl
implements TmWareTextService {
    @Autowired
    private TmWareTextDao tmWareTextDao;

    @Override
    public List<TmWareTextEntity> findTmWareTextList(TmWareTextVo vo) {
        Example example = new Example(TmWareTextEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getWareCode())) {
            criteria.andEqualTo("wareCode", (Object)vo.getWareCode());
        }
        return this.tmWareTextDao.selectByExample(example);
    }

    @Override
    public TmWareTextEntity getTmWareTextEntityById(String id) {
        return (TmWareTextEntity)this.tmWareTextDao.selectByPrimaryKey(id);
    }

    @Override
    public boolean delete(String id) {
        TmWareTextEntity tmWareTextEntity = (TmWareTextEntity)this.tmWareTextDao.selectByPrimaryKey(id);
        int i = this.tmWareTextDao.delete(tmWareTextEntity);
        return i > 0;
    }

    @Override
    public void save(TmWareTextVo vo) {
        TmWareTextEntity entity = new TmWareTextEntity();
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            entity = this.getTmWareTextEntity(vo);
            this.tmWareTextDao.insertSelective(entity);
        }
    }

    @Override
    public void update(TmWareTextVo vo) {
        TmWareTextEntity entity = null;
        if (StringUtils.isNotBlank((CharSequence)vo.getId())) {
            entity = this.getTmWareTextEntity(vo);
            this.tmWareTextDao.updateByPrimaryKeySelective(entity);
        }
    }

    private TmWareTextEntity getTmWareTextEntity(TmWareTextVo vo) {
        TmWareTextEntity entity = new TmWareTextEntity();
        entity.setId(vo.getId());
        entity.setEnableStatus(vo.getEnableStatus());
        entity.setWareCode(vo.getWareCode());
        entity.setWareId(vo.getWareId());
        entity.setWareText(vo.getWareText());
        return entity;
    }
}

