/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.wx;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.user.LoginUserVo;
import com.biz.eisp.wx.TmWxOpenIdVo;
import com.biz.eisp.wx.dao.TmWxOpenIdDao;
import com.biz.eisp.wx.entity.TmWxOpenIdEntity;
import com.biz.eisp.wx.service.LoginService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tk.mybatis.mapper.entity.Example;

@Api(tags={"MDM-\u7ec8\u7aef"})
@RestController
@RequestMapping(value={"/mdmApi/wxLoginController"})
public class WxLoginController {
    private static final Logger log = LoggerFactory.getLogger(WxLoginController.class);
    @Autowired
    private LoginService loginService;
    @Autowired
    private TmWxOpenIdDao tmWxOpenIdDao;

    @ApiOperation(value="\u5fae\u4fe1\u767b\u5f55\u5904\u7406", httpMethod="POST")
    @PostMapping(value={"loginWx"})
    public AjaxJson loginWx(@RequestBody LoginUserVo loginUserVo) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            if (loginUserVo == null || StringUtil.isEmpty((String)loginUserVo.getPassword()) || StringUtil.isEmpty((String)loginUserVo.getUsername()) || StringUtil.isEmpty((String)loginUserVo.getOpenId())) {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u53c2\u6570\u9519\u8bef");
                return ajaxJson;
            }
            ajaxJson = this.loginService.validateUserWx(loginUserVo);
        }
        catch (BusinessException be) {
            log.error("", (Throwable)be);
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg(be.getMessage());
        }
        catch (Exception e) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u53c2\u6570\u9519\u8bef");
            log.error("", (Throwable)e);
        }
        return ajaxJson;
    }

    @ApiOperation(value="\u5fae\u4fe1\u81ea\u52a8\u767b\u5f55\u5904\u7406", httpMethod="POST")
    @PostMapping(value={"autoLoginWx"})
    public AjaxJson autoLoginWx(@RequestParam(value="openId") String openId) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            ajaxJson = this.loginService.autoLoginWx(openId);
        }
        catch (BusinessException be) {
            log.error("", (Throwable)be);
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg(be.getMessage());
        }
        catch (Exception e) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u53c2\u6570\u9519\u8bef");
            log.error("", (Throwable)e);
        }
        return ajaxJson;
    }

    @ApiOperation(value="\u5fae\u4fe1\u7ed1\u5b9a\u83b7\u53d6", httpMethod="POST")
    @PostMapping(value={"findWxOpenIdVo"})
    public AjaxJson<TmWxOpenIdVo> findWxOpenIdVo(@RequestBody TmWxOpenIdVo openIdVo) {
        AjaxJson json = new AjaxJson();
        try {
            TmWxOpenIdVo vo = new TmWxOpenIdVo();
            TmWxOpenIdEntity entity = new TmWxOpenIdEntity();
            if (StringUtil.isNotEmpty((CharSequence)openIdVo.getId())) {
                entity = (TmWxOpenIdEntity)this.tmWxOpenIdDao.selectByPrimaryKey(openIdVo.getId());
            } else {
                Example example = new Example(TmWxOpenIdEntity.class);
                Example.Criteria criteria = example.createCriteria();
                if (StringUtil.isNotEmpty((CharSequence)openIdVo.getUsername())) {
                    criteria.andEqualTo("username", (Object)openIdVo.getUsername());
                }
                if (StringUtil.isNotEmpty((CharSequence)openIdVo.getOpenid())) {
                    criteria.andEqualTo("username", (Object)openIdVo.getOpenid());
                }
                entity = (TmWxOpenIdEntity)this.tmWxOpenIdDao.selectOneByExample(example);
            }
            MyBeanUtils.copyBeanNotNull2Bean((Object)entity, (Object)vo);
            json.setObj((Object)vo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return json;
    }

    @ApiOperation(value="\u5fae\u4fe1\u7ed1\u5b9a\u89e3\u9664", httpMethod="POST")
    @PostMapping(value={"cleadBindOau"})
    public AjaxJson<String> cleadBindOau(@RequestParam(value="ids") String ids) {
        AjaxJson json = new AjaxJson();
        try {
            if (StringUtil.isNotEmpty((CharSequence)ids)) {
                String[] arr = ids.split(",");
                for (int i = 0; i < arr.length; ++i) {
                    this.tmWxOpenIdDao.deleteByIds(ids);
                }
            } else {
                json.setSuccess(false);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            json.setSuccess(false);
            json.setMsg(e.getMessage());
        }
        return json;
    }
}

