/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.positionCustOrg.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.custOrg.dao.CustOrgApiDao;
import com.biz.eisp.custOrg.entity.TmCustomerOrgEntity;
import com.biz.eisp.position.dao.PositionDao;
import com.biz.eisp.position.entity.TmPositionEntity;
import com.biz.eisp.positionCustOrg.dao.TmPositionCustOrgDao;
import com.biz.eisp.positionCustOrg.entity.TmPositionCustOrgEntity;
import com.biz.eisp.positionCustOrg.service.TmPositionCustOrgService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(rollbackFor={Exception.class})
public class TmPositionCustOrgServiceImpl
implements TmPositionCustOrgService {
    private static final Logger log = LoggerFactory.getLogger(TmPositionCustOrgServiceImpl.class);
    @Autowired
    private TmPositionCustOrgDao tmPositionCustOrgDao;
    @Autowired
    private PositionDao positionDao;
    @Autowired
    private CustOrgApiDao custOrgApiDao;

    @Override
    public List<String> getCustCodeByPosition(String positionId, String positionCode) {
        List<String> result = new ArrayList<String>();
        if (StringUtil.isEmpty((String)positionId) && StringUtil.isEmpty((String)positionCode)) {
            return result;
        }
        Example example = new Example(TmPositionEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isEmpty((String)positionCode)) {
            TmPositionEntity positionEntity = (TmPositionEntity)this.positionDao.selectByPrimaryKey(positionId);
            if (positionEntity == null) {
                return result;
            }
            positionCode = positionEntity.getPositionCode();
        }
        criteria.andEqualTo("positionCode", (Object)positionCode);
        List positionCustOrgEntities = this.tmPositionCustOrgDao.selectByExample(example);
        for (TmPositionCustOrgEntity entity : positionCustOrgEntities) {
            result.add(entity.getCustOrgCode());
        }
        result = result.stream().distinct().collect(Collectors.toList());
        return result;
    }

    @Override
    public List<String> getCustCodeDownByPosition(String positionId, String positionCode) {
        List<String> parentResult = this.getCustCodeByPosition(positionId, positionCode);
        List<String> result = new ArrayList<String>();
        if (CollectionUtil.listEmpty(parentResult)) {
            return result;
        }
        for (String s : parentResult) {
            Example example = new Example(TmCustomerOrgEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("custOrgCode", (Object)s);
            List customerOrgEntityList = this.custOrgApiDao.selectByExample(example);
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)customerOrgEntityList)) continue;
            TmCustomerOrgEntity customerOrgEntity = (TmCustomerOrgEntity)customerOrgEntityList.get(0);
            HashMap<String, TmCustomerOrgEntity> mapCustOrg = new HashMap<String, TmCustomerOrgEntity>();
            HashMap<String, String> hadQuery = new HashMap<String, String>();
            mapCustOrg.put(customerOrgEntity.getId(), customerOrgEntity);
            this.findDownCustOrgCode(mapCustOrg, hadQuery, result);
        }
        result = result.stream().distinct().collect(Collectors.toList());
        return result;
    }

    private void findDownCustOrgCode(Map<String, TmCustomerOrgEntity> parentEntitys, Map<String, String> hadQuery, List<String> result) {
        if (parentEntitys != null && parentEntitys.size() > 0) {
            TmCustomerOrgEntity entity = null;
            Iterator<TmCustomerOrgEntity> iterator = parentEntitys.values().iterator();
            if (iterator.hasNext()) {
                TmCustomerOrgEntity value;
                entity = value = iterator.next();
                parentEntitys.remove(value.getId());
            }
            String parentId = entity.getId();
            result.add(entity.getCustOrgCode());
            hadQuery.put(parentId, parentId);
            Example example = new Example(TmCustomerOrgEntity.class);
            Example.Criteria criteriaCust = example.createCriteria();
            criteriaCust.andEqualTo("parentId", (Object)parentId);
            List parentEntityList = this.custOrgApiDao.selectByExample(example);
            if (CollectionUtil.listEmpty((List)parentEntityList)) {
                this.findDownCustOrgCode(parentEntitys, hadQuery, result);
            } else {
                for (TmCustomerOrgEntity parentEntity : parentEntityList) {
                    if (parentEntity.getId().equals(parentEntity.getParentId()) || hadQuery.containsKey(parentEntity.getId())) continue;
                    parentEntitys.put(parentEntity.getId(), parentEntity);
                }
                this.findDownCustOrgCode(parentEntitys, hadQuery, result);
            }
        } else {
            return;
        }
    }
}

