/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.positionOrg.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.positionOrg.dao.PositionOrgDao;
import com.biz.eisp.positionOrg.entity.TmPositionOrgEntity;
import com.biz.eisp.positionOrg.service.PositionOrgService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional(rollbackFor={Exception.class})
public class PositionOrgServiceImpl
implements PositionOrgService {
    @Autowired
    private PositionOrgDao positionOrgDao;

    @Override
    public List<String> getPositionCodesByOrgCodes(List<String> orgCodes) {
        List<String> result = new ArrayList<String>();
        if (CollectionUtil.listEmpty(orgCodes)) {
            return result;
        }
        result = this.positionOrgDao.getPositionCodesByOrgCodes(orgCodes);
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodes)) {
            result = result.stream().distinct().collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<TmPositionOrgEntity> getPositionOrgByCodes(Set<String> orgCodes, Set<String> positionCodes) {
        if (CollectionUtils.isEmpty(orgCodes) && CollectionUtils.isEmpty(positionCodes)) {
            return Lists.newArrayList();
        }
        Example param = new Example(TmPositionOrgEntity.class);
        Example.Criteria builder = param.createCriteria();
        if (!CollectionUtils.isEmpty(orgCodes)) {
            builder.andIn("orgCode", orgCodes);
        }
        if (!CollectionUtils.isEmpty(positionCodes)) {
            builder.andIn("positionCode", positionCodes);
        }
        return this.positionOrgDao.selectByExample(param);
    }
}

