/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.customer.controller;

import com.biz.eisp.base.ImpExpController;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.util.ExcelProgressUtil;
import com.biz.eisp.base.vo.ExcelDate;
import com.biz.eisp.customer.TmCustomerPositionImportVo;
import com.biz.eisp.customer.entity.TmRCustPosBGEntity;
import com.biz.eisp.customer.service.CustomerService;
import com.biz.eisp.customer.service.TmCustomerPositionImportCheckExtend;
import com.biz.eisp.customer.service.TmCustomerPositionImportExtend;
import com.biz.eisp.customer.service.TmRCustPosBGService;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.position.entity.TmPositionEntity;
import com.biz.eisp.position.service.PositionService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"tmCustomerPositionImportController"})
public class TmCustomerPositionImportController
extends ImpExpController {
    @Autowired
    private CustomerService customerService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private TmRCustPosBGService tmRCustPosBGService;
    @Autowired(required=false)
    private TmCustomerPositionImportCheckExtend tmCustomerPositionImportCheckExtend;
    @Autowired(required=false)
    private TmCustomerPositionImportExtend tmCustomerPositionImportExtend;

    protected AjaxJson checkImportList(List importList, ExcelDate excelDate) {
        if (null != this.tmCustomerPositionImportCheckExtend) {
            return this.tmCustomerPositionImportCheckExtend.checkImportList(importList, excelDate);
        }
        return this.check(importList, excelDate);
    }

    private AjaxJson check(List<TmCustomerPositionImportVo> importList, ExcelDate excelDate) {
        if (CollectionUtils.isEmpty(importList)) {
            ExcelProgressUtil.progress((boolean)true, (String)"\u6570\u636e\u4e3a\u7a7a", (String)excelDate.getExcelUuid(), null);
            AjaxJson json = new AjaxJson();
            json.setSuccess(false);
            return json;
        }
        return new AjaxJson();
    }

    protected AjaxJson doImportList(List importList, ExcelDate excelDate) {
        if (null != this.tmCustomerPositionImportExtend) {
            return this.tmCustomerPositionImportExtend.doImportList(importList, excelDate);
        }
        return this.importList(importList, excelDate);
    }

    private AjaxJson importList(List<TmCustomerPositionImportVo> importList, ExcelDate excelDate) {
        Map<String, List<TmCustomerPositionImportVo>> groupData = importList.stream().filter(v -> StringUtil.isNotBlank((CharSequence)v.getCustomerCode())).collect(Collectors.groupingBy(TmCustomerPositionImportVo::getCustomerCode));
        Set positionCodes = importList.stream().filter(v -> StringUtil.isNotBlank((CharSequence)v.getPositionCode())).map(TmCustomerPositionImportVo::getPositionCode).collect(Collectors.toSet());
        Map<String, TmPositionEntity> positionEntitys = this.positionService.getPositionList(null, Lists.newArrayList(positionCodes)).stream().collect(Collectors.toMap(TmPositionEntity::getPositionCode, v -> v, (t, t2) -> t2));
        Map<String, TmCustomerEntity> customerEntitys = this.customerService.getCustomerListByCustomerCodeOrId(Lists.newArrayList(groupData.keySet()), null).stream().collect(Collectors.toMap(TmCustomerEntity::getCustomerCode, v -> v, (t, t2) -> t2));
        Map<String, Set<String>> dbPosidGroupCust = this.tmRCustPosBGService.getPosiIdsByCustIds(customerEntitys.values().stream().map(TmCustomerEntity::getId).collect(Collectors.toSet()));
        HashMap excelDateCheckedMap = Maps.newHashMap();
        Integer index = 1;
        ArrayList newPositionlist = Lists.newArrayList();
        for (TmCustomerPositionImportVo vo : importList) {
            try {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                TmPositionEntity tmPositionEntity = positionEntitys.get(vo.getPositionCode());
                TmCustomerEntity tmCustomerEntity = customerEntitys.get(vo.getCustomerCode());
                String errorMsg = "";
                if (null == tmPositionEntity) {
                    errorMsg = StringUtil.isBlank((CharSequence)vo.getPositionCode()) ? "\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01" : "\u4e0d\u5b58\u5728\u7684\u804c\u4f4d\u4fe1\u606f[" + vo.getPositionCode() + "]";
                }
                if (null == tmCustomerEntity) {
                    if (StringUtil.isNotBlank((CharSequence)errorMsg)) {
                        errorMsg = errorMsg + ",";
                    }
                    errorMsg = StringUtil.isBlank((CharSequence)vo.getCustomerCode()) ? errorMsg + "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01" : errorMsg + "\u4e0d\u5b58\u5728\u7684\u5ba2\u6237\u4fe1\u606f[" + vo.getCustomerCode() + "]";
                }
                if (StringUtil.isNotBlank((CharSequence)errorMsg)) {
                    throw new IllegalArgumentException(errorMsg);
                }
                Set<String> posids = dbPosidGroupCust.get(tmCustomerEntity.getId());
                if (null != posids && posids.contains(tmPositionEntity.getId())) {
                    throw new IllegalArgumentException("\u5ba2\u6237[" + vo.getCustomerCode() + "]\u4e0b\u5df2\u5b58\u5728\u8be5\u804c\u4f4d[" + vo.getPositionCode() + "]");
                }
                String checkedKey = vo.getCustomerCode() + vo.getPositionCode();
                if (excelDateCheckedMap.containsKey(checkedKey)) {
                    throw new IllegalArgumentException("\u4e0e\u7b2c[" + excelDateCheckedMap.get(checkedKey) + "]\u884c\u91cd\u590d\uff01");
                }
                excelDateCheckedMap.put(checkedKey, index);
                TmRCustPosBGEntity entity = new TmRCustPosBGEntity();
                entity.setCustomerId(tmCustomerEntity.getId());
                entity.setPositionId(tmPositionEntity.getId());
                entity.setOrgId(tmCustomerEntity.getOrgId());
                newPositionlist.add(entity);
            }
            catch (Exception e) {
                ExcelProgressUtil.progress((boolean)true, (String)("\u7b2c" + index + "\u884c\u5bfc\u5165\u5931\u8d25\uff1a" + e.getLocalizedMessage()), (String)excelDate.getExcelUuid(), null);
            }
        }
        AjaxJson<TmRCustPosBGEntity> json = this.tmRCustPosBGService.insertButch(newPositionlist);
        if (json.isSuccess()) {
            ExcelProgressUtil.progress((boolean)false, (String)("\u5bfc\u5165\u6210\u529f\u6761\u6570: " + newPositionlist.size()), (String)excelDate.getExcelUuid(), null);
        } else {
            ExcelProgressUtil.progress((boolean)false, (String)("\u5bfc\u5165\u5931\u8d25: " + json.getMsg()), (String)excelDate.getExcelUuid(), null);
        }
        return new AjaxJson();
    }
}

