/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.terminal.controller;

import com.biz.eisp.base.ImpExpController;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.util.ExcelProgressUtil;
import com.biz.eisp.base.vo.ExcelDate;
import com.biz.eisp.position.entity.TmPositionEntity;
import com.biz.eisp.position.service.PositionService;
import com.biz.eisp.terminal.TmRTermCustPosBGEntity;
import com.biz.eisp.terminal.TmTerminalPositionImportVo;
import com.biz.eisp.terminal.entity.TmTerminalEntity;
import com.biz.eisp.terminal.service.TerminalService;
import com.biz.eisp.terminal.service.TmTerminalPositionImportCheckExtend;
import com.biz.eisp.terminal.service.TmTerminalPositionImportExtend;
import com.biz.eisp.terminalCusPos.service.TmRTermCustPosBgService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"tmTerminalPositionImportController"})
public class TmTerminalPositionImportController
extends ImpExpController {
    @Autowired
    private TerminalService terminalService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private TmRTermCustPosBgService tmRTermCustPosBgService;
    @Autowired(required=false)
    private TmTerminalPositionImportCheckExtend tmTerminalPositionImportCheckExtend;
    @Autowired(required=false)
    private TmTerminalPositionImportExtend tmTerminalPositionImportExtend;

    protected AjaxJson checkImportList(List importList, ExcelDate excelDate) {
        if (null != this.tmTerminalPositionImportCheckExtend) {
            return this.tmTerminalPositionImportCheckExtend.checkImportList(importList, excelDate);
        }
        return this.check(importList, excelDate);
    }

    private AjaxJson check(List<TmTerminalPositionImportVo> importList, ExcelDate excelDate) {
        if (CollectionUtils.isEmpty(importList)) {
            ExcelProgressUtil.progress((boolean)true, (String)"\u6570\u636e\u4e3a\u7a7a", (String)excelDate.getExcelUuid(), null);
            AjaxJson json = new AjaxJson();
            json.setSuccess(false);
            return json;
        }
        return new AjaxJson();
    }

    protected AjaxJson doImportList(List importList, ExcelDate excelDate) {
        if (null != this.tmTerminalPositionImportExtend) {
            return this.tmTerminalPositionImportExtend.doImportList(importList, excelDate);
        }
        return this.importList(importList, excelDate);
    }

    private AjaxJson importList(List<TmTerminalPositionImportVo> importList, ExcelDate excelDate) {
        Map<String, List<TmTerminalPositionImportVo>> groupData = importList.stream().filter(v -> StringUtil.isNotBlank((CharSequence)v.getTerminalCode())).collect(Collectors.groupingBy(TmTerminalPositionImportVo::getTerminalCode));
        Set positionCodes = importList.stream().filter(v -> StringUtil.isNotBlank((CharSequence)v.getPositionCode())).map(TmTerminalPositionImportVo::getPositionCode).collect(Collectors.toSet());
        Map<String, TmPositionEntity> positionEntitys = this.positionService.getPositionList(null, Lists.newArrayList(positionCodes)).stream().collect(Collectors.toMap(TmPositionEntity::getPositionCode, v -> v, (t, t2) -> t2));
        Map<String, TmTerminalEntity> terminalEntitys = this.terminalService.getTerminalByCodes(groupData.keySet()).stream().collect(Collectors.toMap(TmTerminalEntity::getTerminalCode, v -> v, (t, t2) -> t2));
        Map<String, Set<String>> dbPosidGroupCust = this.tmRTermCustPosBgService.getPosiIdsByTerminalIds(terminalEntitys.values().stream().map(TmTerminalEntity::getId).collect(Collectors.toSet()));
        HashMap excelDateCheckedMap = Maps.newHashMap();
        Integer index = 1;
        ArrayList newPositionlist = Lists.newArrayList();
        for (TmTerminalPositionImportVo vo : importList) {
            try {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                TmPositionEntity tmPositionEntity = positionEntitys.get(vo.getPositionCode());
                TmTerminalEntity tmTerminalEntity = terminalEntitys.get(vo.getTerminalCode());
                String errorMsg = "";
                if (null == tmPositionEntity) {
                    errorMsg = StringUtil.isBlank((CharSequence)vo.getPositionCode()) ? "\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01" : "\u4e0d\u5b58\u5728\u7684\u804c\u4f4d\u4fe1\u606f[" + vo.getPositionCode() + "]";
                }
                if (null == tmTerminalEntity) {
                    if (StringUtil.isNotBlank((CharSequence)errorMsg)) {
                        errorMsg = errorMsg + ",";
                    }
                    errorMsg = StringUtil.isBlank((CharSequence)vo.getTerminalCode()) ? errorMsg + "\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01" : errorMsg + "\u4e0d\u5b58\u5728\u7684\u7ec8\u7aef\u4fe1\u606f[" + vo.getTerminalCode() + "]";
                }
                if (StringUtil.isNotBlank((CharSequence)errorMsg)) {
                    throw new IllegalArgumentException(errorMsg);
                }
                Set<String> posids = dbPosidGroupCust.get(tmTerminalEntity.getId());
                if (null != posids && posids.contains(tmPositionEntity.getId())) {
                    throw new IllegalArgumentException("\u7ec8\u7aef[" + vo.getTerminalCode() + "]\u4e0b\u5df2\u5b58\u5728\u8be5\u804c\u4f4d[" + vo.getPositionCode() + "]");
                }
                String checkedKey = vo.getTerminalCode() + vo.getPositionCode();
                if (excelDateCheckedMap.containsKey(checkedKey)) {
                    throw new IllegalArgumentException("\u4e0e\u7b2c[" + excelDateCheckedMap.get(checkedKey) + "]\u884c\u91cd\u590d\uff01");
                }
                excelDateCheckedMap.put(checkedKey, index);
                TmRTermCustPosBGEntity entity = new TmRTermCustPosBGEntity();
                entity.setTerminalId(tmTerminalEntity.getId());
                entity.setPositionId(tmPositionEntity.getId());
                entity.setOrgId(tmTerminalEntity.getOrgId());
                newPositionlist.add(entity);
            }
            catch (Exception e) {
                ExcelProgressUtil.progress((boolean)true, (String)("\u7b2c" + index + "\u884c\u5bfc\u5165\u5931\u8d25\uff1a" + e.getLocalizedMessage()), (String)excelDate.getExcelUuid(), null);
            }
        }
        AjaxJson<TmRTermCustPosBGEntity> json = this.tmRTermCustPosBgService.insertButch(newPositionlist);
        if (json.isSuccess()) {
            ExcelProgressUtil.progress((boolean)false, (String)("\u5bfc\u5165\u6210\u529f\u6761\u6570: " + newPositionlist.size()), (String)excelDate.getExcelUuid(), null);
        } else {
            ExcelProgressUtil.progress((boolean)false, (String)("\u5bfc\u5165\u5931\u8d25: " + json.getMsg()), (String)excelDate.getExcelUuid(), null);
        }
        return new AjaxJson();
    }
}

