/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.productLevel.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.product.TmProductVo;
import com.biz.eisp.productLevel.dao.TmProductDao;
import com.biz.eisp.productLevel.entity.TmProductEntity;
import com.biz.eisp.productLevel.service.ProductLevelfindProductListByPageExtend;
import com.biz.eisp.productLevel.service.TmProductService;
import com.biz.eisp.tk.utils.CollectionUtils;
import com.biz.eisp.tree.TreeGrid;
import com.biz.eisp.tree.TreeGridModel;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TmProductServiceImpl
implements TmProductService {
    @Autowired
    private TmProductDao tmProductDao;
    @Autowired(required=false)
    private ProductLevelfindProductListByPageExtend productLevelfindProductListByPageExtend;

    @Override
    public List<TmProductEntity> getTmProductList(String productId, String productCode) {
        List<TmProductEntity> tmProductEntities = this.tmProductDao.selectAll();
        if (StringUtil.isEmpty((String)productCode) && StringUtil.isEmpty((String)productId)) {
            tmProductEntities = this.createProductList(tmProductEntities, null);
        } else if (StringUtil.isEmpty((String)productId) && StringUtil.isNotEmpty((CharSequence)productCode)) {
            Example example = new Example(TmProductEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("productCode", (Object)productCode);
            TmProductEntity tmProductEntity = (TmProductEntity)this.tmProductDao.selectOneByExample(example);
            if (tmProductEntity != null) {
                tmProductEntities = this.createProductList(tmProductEntities, tmProductEntity.getId());
            }
        } else {
            TmProductEntity tmProductEntity = (TmProductEntity)this.tmProductDao.selectByPrimaryKey(productId);
            if (tmProductEntity != null) {
                tmProductEntities = this.createProductList(tmProductEntities, tmProductEntity.getId());
            }
        }
        return tmProductEntities;
    }

    @Override
    public List<TmProductEntity> getTmProductLevelList(String productId, String productCode) {
        List<TmProductEntity> tmProductEntities = this.tmProductDao.selectAll();
        if (StringUtil.isEmpty((String)productCode) && StringUtil.isEmpty((String)productId)) {
            tmProductEntities = this.createProductList(tmProductEntities, null);
        } else if (StringUtil.isEmpty((String)productId) && StringUtil.isNotEmpty((CharSequence)productCode)) {
            Example example = new Example(TmProductEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("productCode", (Object)productCode);
            TmProductEntity tmProductEntity = (TmProductEntity)this.tmProductDao.selectOneByExample(example);
            if (tmProductEntity != null) {
                tmProductEntities = this.createProductLevelList(tmProductEntities, tmProductEntity.getId());
            }
        } else {
            TmProductEntity tmProductEntity = (TmProductEntity)this.tmProductDao.selectByPrimaryKey(productId);
            if (tmProductEntity != null) {
                tmProductEntities = this.createProductLevelList(tmProductEntities, tmProductEntity.getId());
            }
        }
        return tmProductEntities;
    }

    private List<TmProductEntity> createProductList(List<TmProductEntity> tmProductEntities, String targetId) {
        List<Object> productVos = new ArrayList<TmProductEntity>();
        HashMap<String, List<TmProductEntity>> productListMap = new HashMap<String, List<TmProductEntity>>();
        tmProductEntities.stream().collect(Collectors.groupingBy(TmProductEntity::getParentIdDef, Collectors.toList())).forEach((parentIdDef, list) -> productListMap.put((String)parentIdDef, (List<TmProductEntity>)list));
        if (StringUtil.isEmpty((String)targetId)) {
            List productVosTemp = (List)productListMap.get("1");
            productVosTemp.forEach(item -> this.createchildList((Map<String, List<TmProductEntity>>)productListMap, (TmProductEntity)item));
            productVos = productVosTemp;
        } else {
            TmProductEntity tmProductEntity = (TmProductEntity)this.tmProductDao.selectByPrimaryKey(targetId);
            if (tmProductEntity != null) {
                this.createchildList(productListMap, tmProductEntity);
                productVos.add(tmProductEntity);
            }
        }
        return productVos;
    }

    private List<TmProductEntity> createProductLevelList(List<TmProductEntity> tmProductEntities, String targetId) {
        List<Object> productVos = new ArrayList<TmProductEntity>();
        HashMap<String, List<TmProductEntity>> productListMap = new HashMap<String, List<TmProductEntity>>();
        tmProductEntities.stream().collect(Collectors.groupingBy(TmProductEntity::getParentId, Collectors.toList())).forEach((parentId, list) -> productListMap.put((String)parentId, (List<TmProductEntity>)list));
        if (StringUtil.isEmpty((String)targetId)) {
            List productVosTemp = (List)productListMap.get("1");
            for (TmProductEntity item : productVosTemp) {
                this.createchildLevelList(productListMap, item, productVos);
            }
            productVos = productVosTemp;
        } else {
            TmProductEntity tmProductEntity = (TmProductEntity)this.tmProductDao.selectByPrimaryKey(targetId);
            if (tmProductEntity != null) {
                this.createchildLevelList(productListMap, tmProductEntity, productVos);
                productVos.add(tmProductEntity);
            }
        }
        return productVos;
    }

    private void createchildLevelList(Map<String, List<TmProductEntity>> productListMap, TmProductEntity entity, List<TmProductEntity> productVos) {
        List<TmProductEntity> list = productListMap.get(entity.getId());
        entity.setTmProductList(list);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> {
                this.createchildList(productListMap, (TmProductEntity)item);
                productVos.add((TmProductEntity)item);
            });
        }
    }

    private void createchildList(Map<String, List<TmProductEntity>> productListMap, TmProductEntity entity) {
        List<TmProductEntity> list = productListMap.get(entity.getId());
        entity.setTmProductList(list);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> this.createchildList(productListMap, (TmProductEntity)item));
        }
    }

    @Override
    public List<TreeGrid> findTmProductVoNameList(TmProductVo tmProductEntity) {
        List<TreeGrid> treeGrids = null;
        String productId = tmProductEntity.getId();
        String productCode = tmProductEntity.getProductCode();
        List<TmProductEntity> tmProductList = this.getTmProductList(productId, productCode);
        ArrayList<TmProductVo> tmProductVos = new ArrayList<TmProductVo>();
        Object ajaxJson = null;
        if (StringUtils.isNotBlank((CharSequence)productId)) {
            for (TmProductEntity entity : tmProductList) {
                TmProductVo tmProductVo = new TmProductVo();
                BeanUtils.copyProperties((Object)entity, (Object)tmProductVo);
                tmProductVos.add(tmProductVo);
            }
            if (tmProductVos != null) {
                for (TmProductVo productEntity : tmProductVos) {
                    treeGrids = this.treeGridModelName(productEntity.getTmProductList());
                }
            }
        } else {
            for (TmProductEntity entity : tmProductList) {
                TmProductVo tmProductVo = new TmProductVo();
                BeanUtils.copyProperties((Object)entity, (Object)tmProductVo);
                tmProductVos.add(tmProductVo);
            }
            if (tmProductVos != null) {
                treeGrids = this.treeGridModelName(tmProductVos);
            }
        }
        return treeGrids;
    }

    @Override
    public List<TreeGrid> findTmProductVoList(TmProductVo tmProductEntity) {
        List<TreeGrid> treeGrids = null;
        String productId = tmProductEntity.getId();
        String productCode = tmProductEntity.getProductCode();
        List<TmProductEntity> tmProductList = this.getTmProductList(productId, productCode);
        ArrayList<TmProductVo> tmProductVos = new ArrayList<TmProductVo>();
        Object ajaxJson = null;
        if (StringUtils.isNotBlank((CharSequence)productId)) {
            for (TmProductEntity entity : tmProductList) {
                TmProductVo tmProductVo = new TmProductVo();
                BeanUtils.copyProperties((Object)entity, (Object)tmProductVo);
                tmProductVos.add(tmProductVo);
            }
            if (tmProductVos != null) {
                for (TmProductVo productEntity : tmProductVos) {
                    treeGrids = this.treeGridModel(productEntity.getTmProductList());
                }
            }
        } else {
            for (TmProductEntity entity : tmProductList) {
                TmProductVo tmProductVo = new TmProductVo();
                BeanUtils.copyProperties((Object)entity, (Object)tmProductVo);
                tmProductVos.add(tmProductVo);
            }
            if (tmProductVos != null) {
                treeGrids = this.treeGridModel(tmProductVos);
            }
        }
        return treeGrids;
    }

    private List<TreeGrid> treeGridModel(List<TmProductVo> productList) {
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("productCode");
        treeGridModel.setSrc("productName");
        treeGridModel.setParentId("parentId");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("tmProductList");
        treeGridModel.setCostRate("costRate");
        List<TreeGrid> treeGrids = this.treegrid(productList, treeGridModel);
        return treeGrids;
    }

    private List<TreeGrid> treeGridModelName(List<TmProductVo> productList) {
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("productName");
        treeGridModel.setSrc("productCode");
        treeGridModel.setParentId("parentId");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("tmProductList");
        List<TreeGrid> treeGrids = this.treegrid(productList, treeGridModel);
        return treeGrids;
    }

    private List<TreeGrid> treegrid(List all, TreeGridModel treeGridModel) {
        ArrayList<TreeGrid> treegrid = new ArrayList<TreeGrid>();
        for (Object obj : all) {
            List childList;
            Object icon;
            String text;
            ReflectHelper reflectHelper = new ReflectHelper(obj);
            TreeGrid tg = new TreeGrid();
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getCode())) {
                String code = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getCode()));
                tg.setCode(code);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getOrder())) {
                String order = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getOrder()));
                tg.setOrder(order);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getIdField())) {
                String id = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getIdField()));
                tg.setId(id);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getSrc())) {
                String src = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getSrc()));
                tg.setSrc(src);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getTextField())) {
                text = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getTextField()));
                tg.setText(text);
            }
            if (StringUtil.isNotEmpty((CharSequence)treeGridModel.getCostRate())) {
                text = OConvertUtils.getString((Object)reflectHelper.getMethodValue(treeGridModel.getCostRate()));
                tg.setCostRate(text);
            }
            if (treeGridModel.getParentId() != null) {
                Object pid = TmProductServiceImpl.fieldNametoValues(treeGridModel.getParentId(), obj);
                if (pid != null) {
                    tg.setParentId(pid.toString());
                } else {
                    tg.setParentId("");
                }
            }
            if (treeGridModel.getIcon() != null && (icon = TmProductServiceImpl.fieldNametoValues(treeGridModel.getIcon(), obj)) != null) {
                tg.setIcon(icon.toString());
            }
            if ((childList = (List)reflectHelper.getMethodValue(treeGridModel.getChildList())) != null && childList.size() > 0) {
                tg.setState("closed");
            }
            if (treeGridModel.getFieldMap() != null) {
                tg.setFieldMap(new HashMap());
                for (Map.Entry entry : treeGridModel.getFieldMap().entrySet()) {
                    Object fieldValue = reflectHelper.getMethodValue(entry.getValue().toString());
                    tg.getFieldMap().put(entry.getKey(), fieldValue);
                }
            }
            treegrid.add(tg);
        }
        return treegrid;
    }

    public static Object fieldNametoValues(String FiledName, Object o) {
        Object value = "";
        String fieldName = "";
        String childFieldName = null;
        ReflectHelper reflectHelper = new ReflectHelper(o);
        if (FiledName.indexOf("_") == -1) {
            if (FiledName.indexOf(".") == -1) {
                fieldName = FiledName;
            } else {
                fieldName = FiledName.substring(0, FiledName.indexOf("."));
                childFieldName = FiledName.substring(FiledName.indexOf(".") + 1);
            }
        } else {
            fieldName = FiledName.substring(0, FiledName.indexOf("_"));
            childFieldName = FiledName.substring(FiledName.indexOf("_") + 1);
        }
        Object object = value = reflectHelper.getMethodValue(fieldName) == null ? "" : reflectHelper.getMethodValue(fieldName);
        if (value != null && (FiledName.indexOf("_") != -1 || FiledName.indexOf(".") != -1)) {
            if (value instanceof List) {
                String tempValue = "";
                for (Object listValue : (List)value) {
                    tempValue = tempValue.toString() + TmProductServiceImpl.fieldNametoValues(childFieldName, listValue) + ",";
                }
                value = tempValue;
            } else {
                value = TmProductServiceImpl.fieldNametoValues(childFieldName, value);
            }
        }
        if (value != "" && value != null) {
            value = value.toString().replaceAll("\r\n", "");
        }
        return value;
    }

    @Override
    public PageInfo<TmProductEntity> findProductByPage(Map<String, Object> param, Page page) {
        Example example = new Example(TmProductEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((Object)param.get("id"))) {
            criteria.andEqualTo("id", param.get("id"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("productCode"))) {
            criteria.andEqualTo("productCode", (Object)param.get("productCode").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("productName"))) {
            criteria.andLike("productName", "%" + param.get("productName").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("productLevel"))) {
            criteria.andEqualTo("productLevel", (Object)param.get("productLevel").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("productAttribute1"))) {
            criteria.andEqualTo("productAttribute1", (Object)param.get("productAttribute1").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("productAttribute2"))) {
            criteria.andEqualTo("productAttribute2", (Object)param.get("productAttribute2").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("productAttribute3"))) {
            criteria.andEqualTo("productAttribute3", (Object)param.get("productAttribute3").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("productAttribute4"))) {
            criteria.andEqualTo("productAttribute4", (Object)param.get("productAttribute4").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("remark"))) {
            criteria.andLike("remark", "%" + param.get("remark").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("createName"))) {
            criteria.andLike("createName", "%" + param.get("createName").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("updateName"))) {
            criteria.andLike("updateName", "%" + param.get("updateName").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("enableStatus"))) {
            criteria.andEqualTo("enableStatus", (Object)param.get("enableStatus").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("isLeaf"))) {
            criteria.andEqualTo("isLeaf", (Object)param.get("isLeaf").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("parentId"))) {
            criteria.andEqualTo("parentId", (Object)param.get("parentId").toString());
        }
        return PageAutoHelperUtil.generatePage(() -> this.tmProductDao.selectByExample(example), (Page)page);
    }

    @Override
    public PageInfo<TmProductEntity> findProductListByPage(TmProductEntity entity, Page page) {
        if (this.productLevelfindProductListByPageExtend != null) {
            return this.productLevelfindProductListByPageExtend.findProductListByPage(entity, page);
        }
        return PageAutoHelperUtil.generatePage(() -> this.tmProductDao.findProductByPage(entity), (Page)page);
    }

    @Override
    public TmProductEntity getTmProductEntity(String id, String code) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)code)) {
            return null;
        }
        Example example = new Example(TmProductEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)code)) {
            criteria.andEqualTo("productCode", (Object)code);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.tmProductDao.selectByExample(example)))) {
            return (TmProductEntity)list.get(0);
        }
        return null;
    }

    @Override
    public List<TmProductEntity> list() {
        List<TmProductEntity> list = this.tmProductDao.list();
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<TmProductEntity>();
        }
        return list;
    }

    @Override
    public List<String> findSubCode(String productCode) {
        Example example = new Example(TmProductEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("productCode", (Object)productCode);
        TmProductEntity tmProductEntity = (TmProductEntity)this.tmProductDao.selectOneByExample(example);
        if (tmProductEntity != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(tmProductEntity.getProductCode());
            this.findSubCode(tmProductEntity, list);
            return list;
        }
        return Collections.emptyList();
    }

    private void findSubCode(TmProductEntity productEntity, List<String> codeList) {
        Example example = new Example(TmProductEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("parentId", (Object)productEntity.getId());
        List productEntityList = this.tmProductDao.selectByExample(example);
        if (!CollectionUtils.isEmpty((Collection)productEntityList)) {
            for (TmProductEntity tmProductEntity : productEntityList) {
                codeList.add(tmProductEntity.getProductCode());
                this.findSubCode(tmProductEntity, codeList);
            }
        }
    }
}

