/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.position.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.utils.ListCopyUtil;
import com.biz.eisp.org.entity.TmOrgEntity;
import com.biz.eisp.org.service.OrgService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.position.dao.PositionDao;
import com.biz.eisp.position.dao.UserPositionDao;
import com.biz.eisp.position.entity.TmPositionEntity;
import com.biz.eisp.position.entity.TmUserPositionEntity;
import com.biz.eisp.position.service.PositionService;
import com.biz.eisp.user.TmUserQueryVo;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.user.dao.TmUserDao;
import com.biz.eisp.user.entity.TmUserEntity;
import com.biz.eisp.user.service.UserService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class PositionServiceImpl
implements PositionService {
    @Autowired
    private UserService userService;
    @Autowired
    private PositionDao positionDao;
    @Autowired
    private UserPositionDao userPositionDao;
    @Autowired
    private TmUserDao tmUserDao;
    @Autowired
    private OrgService orgService;

    @Override
    public TmPositionEntity getTmPosition(String id, String posCode) {
        Example example = new Example(TmPositionEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            return (TmPositionEntity)this.positionDao.selectByPrimaryKey(id);
        }
        if (StringUtil.isNotEmpty((CharSequence)posCode)) {
            criteria.andEqualTo("positionCode", (Object)posCode);
            List list = this.positionDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                return (TmPositionEntity)list.get(0);
            }
        }
        return null;
    }

    @Override
    public TmPositionEntity getParentByIdOrPosCode(String id, String posCode) {
        if (StringUtil.isBlank((CharSequence)id) && StringUtil.isBlank((CharSequence)posCode)) {
            return null;
        }
        return this.positionDao.getParentByIdOrPosCode(id, posCode);
    }

    @Override
    public List<TmPositionVo> getUserPositons(String username, String id) {
        if (StringUtil.isEmpty((String)username) && StringUtil.isEmpty((String)id)) {
            return null;
        }
        if (StringUtil.isEmpty((String)id)) {
            TmUserQueryVo tmUserQueryVo = new TmUserQueryVo();
            tmUserQueryVo.setUsername(username);
            TmUserVo tmUserVo = this.userService.getTmUser(tmUserQueryVo);
            id = tmUserVo.getId();
        }
        Example example = new Example(TmUserPositionEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("userId", (Object)id);
        List listUserPos = this.userPositionDao.selectByExample(example);
        if (CollectionUtil.listEmpty((List)listUserPos)) {
            return null;
        }
        List listId = listUserPos.stream().map(TmUserPositionEntity::getPositionId).collect(Collectors.toList());
        Example examplePos = new Example(TmPositionEntity.class);
        Example.Criteria criteriaPos = examplePos.createCriteria();
        criteriaPos.andIn("id", listId);
        List tmPositionEntitys = this.positionDao.selectByExample(examplePos);
        ArrayList<TmPositionVo> positionVos = new ArrayList<TmPositionVo>();
        tmPositionEntitys.forEach(item -> {
            TmPositionVo tmPositionVo = new TmPositionVo();
            BeanUtils.copyProperties((Object)item, (Object)tmPositionVo);
            positionVos.add(tmPositionVo);
        });
        return positionVos;
    }

    @Override
    public TmPositionVo getUserMainPositon(String username, String id) {
        if (StringUtil.isEmpty((String)username) && StringUtil.isEmpty((String)id)) {
            return null;
        }
        TmUserVo tmUserVo = new TmUserVo();
        if (StringUtil.isEmpty((String)id)) {
            TmUserQueryVo tmUserQueryVo = new TmUserQueryVo();
            tmUserQueryVo.setUsername(username);
            tmUserVo = this.userService.getTmUser(tmUserQueryVo);
            id = tmUserVo.getId();
        } else {
            TmUserEntity user = (TmUserEntity)this.tmUserDao.selectByPrimaryKey(id);
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)user, (Object)tmUserVo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Example example = new Example(TmUserPositionEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("userId", (Object)id);
        criteria.andEqualTo("isMain", (Object)ConstantEnum.YesNoEnum.ZERO.getValue());
        List listUserPos = this.userPositionDao.selectByExample(example);
        if (CollectionUtil.listEmpty((List)listUserPos)) {
            return null;
        }
        List listId = listUserPos.stream().map(TmUserPositionEntity::getPositionId).collect(Collectors.toList());
        Example examplePos = new Example(TmPositionEntity.class);
        Example.Criteria criteriaPos = examplePos.createCriteria();
        criteriaPos.andIn("id", listId);
        List tmPositionEntitys = this.positionDao.selectByExample(examplePos);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)tmPositionEntitys)) {
            TmPositionVo tmPositionVo = new TmPositionVo();
            BeanUtils.copyProperties(tmPositionEntitys.get(0), (Object)tmPositionVo);
            tmPositionVo.setUserId(tmUserVo.getId());
            tmPositionVo.setUserName(tmUserVo.getUsername());
            tmPositionVo.setFullname(tmUserVo.getFullname());
            return tmPositionVo;
        }
        return null;
    }

    @Override
    public PageInfo<TmPositionEntity> findTmPositionPage(Map<String, Object> param, Page page) {
        Example example = new Example(TmPositionEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((Object)param.get("id"))) {
            criteria.andEqualTo("id", param.get("id"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("positionCode"))) {
            criteria.andLike("positionCode", "%" + param.get("positionCode").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("positionName"))) {
            criteria.andLike("positionName", "%" + param.get("positionName").toString() + "%");
        }
        return PageAutoHelperUtil.generatePage(() -> this.positionDao.selectByExample(example), (Page)page);
    }

    @Override
    public PageInfo<TmPositionVo> findTmPositionAndUserPage(Map<String, Object> param, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.positionDao.findTmPositionAndUserPage(param), (Page)page);
    }

    @Override
    public AjaxJson<TmUserVo> findUpPositionUser(String posId) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)posId)) {
            ajaxJson.setErrMsg("\u804c\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        TmPositionEntity entity = (TmPositionEntity)this.positionDao.selectByPrimaryKey(posId);
        if (StringUtil.isEmpty((String)entity.getParentId())) {
            TmUserQueryVo tmUserQueryVo = new TmUserQueryVo();
            tmUserQueryVo.setPosId(entity.getId());
            TmUserVo tmUserVo = this.userService.getTmUser(tmUserQueryVo);
            tmUserVo.setPosId(entity.getId());
            ajaxJson.setObj((Object)tmUserVo);
        } else {
            TmUserQueryVo tmUserQueryVo = new TmUserQueryVo();
            tmUserQueryVo.setPosId(entity.getParentId());
            TmUserVo tmUserVo = this.userService.getTmUser(tmUserQueryVo);
            tmUserVo.setPosId(entity.getParentId());
            ajaxJson.setObj((Object)tmUserVo);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson<TmUserVo> findPositionUser(String posId) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)posId)) {
            ajaxJson.setErrMsg("\u804c\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        TmPositionEntity entity = (TmPositionEntity)this.positionDao.selectByPrimaryKey(posId);
        if (entity == null) {
            ajaxJson.setErrMsg("\u672a\u627e\u5230\u804c\u4f4d");
            return ajaxJson;
        }
        TmUserQueryVo tmUserQueryVo = new TmUserQueryVo();
        tmUserQueryVo.setPosId(entity.getId());
        TmUserVo tmUserVo = this.userService.getTmUser(tmUserQueryVo);
        tmUserVo.setPosId(entity.getId());
        tmUserVo.setPosName(entity.getPositionName());
        ajaxJson.setObj((Object)tmUserVo);
        return ajaxJson;
    }

    @Override
    public TmUserEntity findPositionUserByIdOrCode(String posId, String posCode) {
        if (StringUtil.isBlank((CharSequence)posId) && StringUtil.isBlank((CharSequence)posCode)) {
            return null;
        }
        return this.tmUserDao.findPositionUserByIdOrCode(posId, posCode);
    }

    @Override
    public TmPositionVo getUserAndPositionInfoByPosCodes(String posCodes) {
        TmPositionVo tmPositionVo = new TmPositionVo();
        List posCodeList = StringUtil.stringToStringListBySlipStr((String)",", (String)posCodes);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)posCodeList)) {
            tmPositionVo = this.positionDao.getUserAndPositionInfoByPosCodes(posCodeList);
            tmPositionVo.setPositionName(this.specTheStr(tmPositionVo.getPositionNames()));
            tmPositionVo.setUserNames(this.specTheStr(tmPositionVo.getUserNames()));
            tmPositionVo.setFullNames(this.specTheStr(tmPositionVo.getFullNames()));
        }
        return tmPositionVo;
    }

    @Override
    public List<TmPositionVo> getUserAndPositionInfoByPosCodesList(String posCodes) {
        List posCodeList = StringUtil.stringToStringListBySlipStr((String)",", (String)posCodes);
        return this.positionDao.getUserAndPositionInfoByPosCodesList(posCodeList);
    }

    private String specTheStr(String str) {
        int length = str.length();
        String strTemp = str.substring(length - 1);
        if (strTemp.equals(",")) {
            return str.substring(0, length);
        }
        return str;
    }

    @Override
    public List<TmPositionVo> findAllPosByUser(String userId, String userName, Integer type) {
        List<Object> positionVos = new ArrayList();
        if ((type = Integer.valueOf(type == null ? 0 : type)) == 0) {
            positionVos = this.getUserPositons(userName, userId);
            if (CollectionUtil.listEmpty(positionVos)) {
                return new ArrayList<TmPositionVo>();
            }
            List<String> posId = positionVos.stream().map(TmPositionVo::getId).collect(Collectors.toList());
            this.getPosChirld(posId, positionVos);
            return positionVos;
        }
        if (type == 1) {
            TmPositionVo tmPositionVo = this.getUserMainPositon(userName, userId);
            if (tmPositionVo == null) {
                return positionVos;
            }
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(tmPositionVo.getId());
            positionVos.add(tmPositionVo);
            this.getPosChirld(ids, positionVos);
            return positionVos;
        }
        return positionVos;
    }

    @Override
    public List<TmPositionEntity> findPosListByOrgDown(String orgId, String orgCode) {
        List<TmOrgEntity> orgEntities = this.orgService.getOrgListDown(orgId, orgCode);
        if (CollectionUtil.listNotEmptyNotSizeZero(orgEntities)) {
            List orgIds = orgEntities.stream().map(TmOrgEntity::getId).distinct().collect(Collectors.toList());
            Example example = new Example(TmPositionEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andIn("orgId", orgIds);
            return this.positionDao.selectByExample(example);
        }
        return null;
    }

    @Override
    public PageInfo findPositionListMainPage(TmPositionVo vo, Page page) {
        return PageAutoHelperUtil.generatePage(() -> this.positionDao.findPositionListMainPage(vo), (Page)page);
    }

    public void getPosChirld(List<String> posIds, List<TmPositionVo> positionVos) {
        if (CollectionUtil.listEmpty(posIds)) {
            return;
        }
        Example example = new Example(TmPositionEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("parentId", posIds);
        List entities = this.positionDao.selectByExample(example);
        if (CollectionUtil.listEmpty((List)entities)) {
            return;
        }
        List positionChirlds = ListCopyUtil.batchTransform(TmPositionVo.class, (List)entities);
        positionVos.addAll(positionChirlds);
        List<String> parentIds = entities.stream().map(TmPositionEntity::getId).collect(Collectors.toList());
        this.getPosChirld(parentIds, positionVos);
    }

    @Override
    public List<TmPositionEntity> getPositionList(List<String> posIds, List<String> posCodes) {
        if (CollectionUtil.listEmpty(posIds) && CollectionUtil.listEmpty(posCodes)) {
            return new ArrayList<TmPositionEntity>();
        }
        Example example = new Example(TmPositionEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (CollectionUtil.listNotEmptyNotSizeZero(posIds)) {
            criteria.orIn("id", posIds);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(posCodes)) {
            criteria.orIn("positionCode", posCodes);
        }
        return this.positionDao.selectByExample(example);
    }
}

