/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.customer.service.impl;

import com.biz.eisp.auth.entity.TmFunAuthEntity;
import com.biz.eisp.auth.service.TmFunAuthService;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MapChangeUtil;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.customer.CustomerFindVo;
import com.biz.eisp.customer.TmCustPostVo;
import com.biz.eisp.customer.TmCustomerResultVo;
import com.biz.eisp.customer.TmCustomerVo;
import com.biz.eisp.customer.TmRCustPosBgDetailVo;
import com.biz.eisp.customer.dao.CustomerDao;
import com.biz.eisp.customer.dao.TmRCustPosBgDetailDao;
import com.biz.eisp.customer.service.CustomerComSelectExpand;
import com.biz.eisp.customer.service.CustomerSelectCustExtend;
import com.biz.eisp.customer.service.CustomerService;
import com.biz.eisp.mdm.customer.entity.TmAddressEntity;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBgDetailEntity;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.service.TmRoleFunctionService;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.org.service.OrgService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.position.entity.TmPositionEntity;
import com.biz.eisp.position.service.PositionService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class CustomerServiceImpl
implements CustomerService {
    private static final Logger log = Logger.getLogger(CustomerServiceImpl.class.getName());
    @Autowired
    private CustomerDao customerDao;
    @Autowired
    private TmFunAuthService tmFunAuthService;
    @Autowired
    private TmRoleFunctionService tmRoleFunctionService;
    @Autowired
    private OrgService orgService;
    @Autowired
    private PositionService positionService;
    @Autowired(required=false)
    private CustomerSelectCustExtend customerSelectCustExtend;
    @Autowired(required=false)
    private CustomerComSelectExpand customerComSelectExpand;
    @Autowired
    private TmRCustPosBgDetailDao tmRCustPosBgDetailDao;

    private boolean checAll(List<OperationAuthobj> authobjs) {
        for (OperationAuthobj item : authobjs) {
            if (!"10".equals(item.getAuthobjValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public PageInfo<TmCustomerEntity> getCustomerPage(Map<String, Object> param, Page page) {
        CustomerFindVo customerFindVo = new CustomerFindVo();
        try {
            customerFindVo = (CustomerFindVo)MapChangeUtil.mapToBean(param, CustomerFindVo.class);
            return this.getCustomerComSelectPage(customerFindVo, page);
        }
        catch (Exception e) {
            e.printStackTrace();
            PageInfo pageInfo = new PageInfo();
            return pageInfo;
        }
    }

    @Override
    public PageInfo<TmCustomerResultVo> getCustomerByPosIdPage(Map<String, Object> param, Page page) {
        TmCustomerVo vo = new TmCustomerVo();
        ArrayList<String> posList = new ArrayList<String>();
        String posId = OConvertUtils.getString((Object)param.get("posId"));
        if (StringUtil.isNotEmpty((CharSequence)posId)) {
            String[] array;
            for (String id : array = posId.split(",")) {
                posList.add(id);
            }
        }
        ArrayList<String> inIdList = new ArrayList<String>();
        String inIds = OConvertUtils.getString((Object)param.get("inIds"));
        if (StringUtil.isNotEmpty((CharSequence)inIds)) {
            String[] inIdArray;
            for (String id : inIdArray = inIds.split(",")) {
                inIdList.add(id);
            }
        }
        ArrayList<String> notIdList = new ArrayList<String>();
        String notIds = OConvertUtils.getString((Object)param.get("notIds"));
        if (StringUtil.isNotEmpty((CharSequence)notIds)) {
            String[] notIdArray;
            for (String id : notIdArray = notIds.split(",")) {
                notIdList.add(id);
            }
        }
        vo.setPosId(OConvertUtils.getString((Object)param.get("posId")));
        vo.setCustomerCode(OConvertUtils.getString((Object)param.get("customerCode")));
        vo.setCustomerName(OConvertUtils.getString((Object)param.get("customerName")));
        vo.setExtChar16(OConvertUtils.getString((Object)param.get("custLevel")));
        vo.setExtChar4(OConvertUtils.getString((Object)param.get("custType")));
        return PageAutoHelperUtil.generatePage(() -> this.customerDao.getCustomerByPosIdPage(posList, inIdList, notIdList, vo), (Page)page);
    }

    @Override
    public PageInfo<TmCustomerResultVo> getCustomerByPosPage(Map<String, Object> param, Page page) {
        TmCustomerVo vo = new TmCustomerVo();
        String posId = OConvertUtils.getString((Object)param.get("posId"));
        String[] array = posId.split(",");
        ArrayList posList = new ArrayList(array.length);
        Collections.addAll(posList, array);
        vo.setPosId(OConvertUtils.getString((Object)param.get("posId")));
        vo.setCustomerCode(OConvertUtils.getString((Object)param.get("customerCode")));
        vo.setCustomerName(OConvertUtils.getString((Object)param.get("customerName")));
        vo.setExtChar16(OConvertUtils.getString((Object)param.get("custLevel")));
        vo.setExtChar4(OConvertUtils.getString((Object)param.get("custType")));
        return PageAutoHelperUtil.generatePage(() -> this.customerDao.getCustomerByPosPage(posList, vo), (Page)page);
    }

    @Override
    public PageInfo<TmCustomerEntity> getCustomerComSelectPage(CustomerFindVo customerFindVo, Page page) {
        List<TmFunAuthEntity> authEntities;
        String clickFunctionId = customerFindVo.getClickFunctionId();
        StringBuffer stringBuffer = new StringBuffer();
        UserRedis userRedis = UserUtils.getUser();
        if (Objects.nonNull(this.customerComSelectExpand)) {
            this.customerComSelectExpand.customerParam(customerFindVo);
        }
        if (StringUtil.isNotBlank((CharSequence)clickFunctionId) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername()) && CollectionUtil.listNotEmptyNotSizeZero(authEntities = this.tmFunAuthService.findListByFunidAndFuncode(clickFunctionId, Globals.SELECTCUST))) {
            List<OperationAuthobj> authobjs = this.tmRoleFunctionService.findAuthobjUserAndFunIdAndFuncode(userRedis.getId(), clickFunctionId, Globals.SELECTCUST);
            if (CollectionUtil.listNotEmptyNotSizeZero(authobjs)) {
                if (!this.checAll(authobjs)) {
                    Map<Object, Object> auValMap;
                    List items;
                    HashMap<String, List<OperationAuthobj>> auMap = new HashMap<String, List<OperationAuthobj>>();
                    authobjs.stream().collect(Collectors.groupingBy(OperationAuthobj::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put((String)parentId, (List<OperationAuthobj>)list));
                    boolean flagOr = false;
                    stringBuffer.append(" and  (");
                    if (auMap.containsKey("position")) {
                        flagOr = true;
                        stringBuffer.append("  EXISTS( select aa.id from tm_r_cust_pos_bg aa left join tm_position bb on aa.POSITION_ID = bb.id where t.id = aa.CUSTOMER_ID ");
                        items = (List)auMap.get("position");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("40")) {
                            stringBuffer.append(" and bb.code_rule like '" + userRedis.getPoscoderule() + "%' ");
                        } else if (auValMap.containsKey("50")) {
                            stringBuffer.append(" and bb.id = '" + userRedis.getPosId() + "' ");
                        }
                        stringBuffer.append(")");
                    }
                    if (auMap.containsKey("org")) {
                        if (flagOr) {
                            stringBuffer.append(" or ");
                        }
                        flagOr = true;
                        stringBuffer.append(" EXISTS( select b.id from tm_org b where t.org_id = b.id  ");
                        items = (List)auMap.get("org");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("20")) {
                            stringBuffer.append(" and b.code_rule like '" + userRedis.getOrgcoderule() + "%' ");
                        } else if (auValMap.containsKey("30")) {
                            stringBuffer.append(" and b.id = '" + userRedis.getOrgId() + "' ");
                        }
                        stringBuffer.append(")");
                    }
                    if (this.customerSelectCustExtend != null) {
                        String sql = this.customerSelectCustExtend.getCustomerComSelectPage(customerFindVo, auMap, flagOr, userRedis, stringBuffer);
                        stringBuffer.append(sql);
                    }
                    stringBuffer.append(" )");
                }
            } else {
                stringBuffer.append(" and 1=2");
            }
        }
        return PageAutoHelperUtil.generatePage(() -> this.customerDao.getCustomerPage(customerFindVo, stringBuffer.toString()), (Page)page);
    }

    @Override
    public TmCustomerVo getCustomerByIdOrCode(String id, String customerCode) {
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)customerCode)) {
            return null;
        }
        TmCustomerEntity entity = null;
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            entity = (TmCustomerEntity)this.customerDao.selectByPrimaryKey(id);
        } else {
            Example example = new Example(TmCustomerEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("customerCode", (Object)customerCode);
            List list = this.customerDao.selectByExample(example);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
                entity = (TmCustomerEntity)list.get(0);
            } else {
                return null;
            }
        }
        TmCustomerVo tmCustomerVo = new TmCustomerVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)tmCustomerVo);
            return tmCustomerVo;
        }
        return null;
    }

    @Override
    public List<TmCustPostVo> findTmCustPostDetailList(String customerId) {
        return this.customerDao.findTmCustPostDetailList(customerId);
    }

    @Override
    public List<TmCustomerEntity> getCustListByOrgCodes(List<String> orgCodes) {
        return this.customerDao.getCustListByOrgCodes(orgCodes);
    }

    @Override
    public List<TmCustomerEntity> getCustListByCurrentUser(String userId, String userName) {
        return this.customerDao.getCustListByCurrentUser(userId, userName);
    }

    @Override
    public List<TmAddressEntity> getCustAddressListByCustomerCodeOrId(String customerCode, String customerId) {
        return this.customerDao.getCustAddressListByCustomerCodeOrId(customerCode, customerId);
    }

    @Override
    public PageInfo<TmCustomerEntity> getCustomerByCompanyCodes(Map<String, Object> param, Page page) {
        TmCustomerVo vo = new TmCustomerVo();
        String companyCodes = OConvertUtils.getString((Object)param.get("companyCodes"));
        ArrayList companyCodeList = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)companyCodes)) {
            String[] array = companyCodes.split(",");
            Collections.addAll(companyCodeList, array);
        }
        String posIds = OConvertUtils.getString((Object)param.get("posIds"));
        ArrayList posIdList = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)posIds)) {
            String[] array = posIds.split(",");
            Collections.addAll(posIdList, array);
        }
        String posCodes = OConvertUtils.getString((Object)param.get("posCodes"));
        ArrayList posCodeList = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)posCodes)) {
            String[] array = posCodes.split(",");
            Collections.addAll(posCodeList, array);
        }
        String userIds = OConvertUtils.getString((Object)param.get("userIds"));
        ArrayList userIdList = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)userIds)) {
            String[] array = userIds.split(",");
            Collections.addAll(userIdList, array);
        }
        String userNames = OConvertUtils.getString((Object)param.get("userNames"));
        ArrayList userNameList = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)userNames)) {
            String[] array = userNames.split(",");
            Collections.addAll(userNameList, array);
        }
        vo.setCustomerCode(OConvertUtils.getString((Object)param.get("customerCode")));
        vo.setCustomerName(OConvertUtils.getString((Object)param.get("customerName")));
        vo.setExtChar16(OConvertUtils.getString((Object)param.get("custLevel")));
        vo.setExtChar4(OConvertUtils.getString((Object)param.get("custType")));
        return PageAutoHelperUtil.generatePage(() -> this.customerDao.getCustomerByCompanyCodes(companyCodeList, posIdList, posCodeList, userIdList, userNameList, vo), (Page)page);
    }

    @Override
    public PageInfo<TmRCustPosBgDetailVo> getCustomerBusinesGroup(Map<String, Object> param, Page page) {
        TmCustomerVo vo = new TmCustomerVo();
        vo.setId(OConvertUtils.getString((Object)param.get("customerId")));
        vo.setCustomerCode(OConvertUtils.getString((Object)param.get("customerCode")));
        return PageAutoHelperUtil.generatePage(() -> this.customerDao.getCustomerBusinesGroup(vo), (Page)page);
    }

    @Override
    public List<TmCustomerEntity> getCustListByPosCodes(List<String> codes) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(codes)) {
            codes.add("_");
        }
        return this.customerDao.getCustListByPosCodes(codes);
    }

    @Override
    public List<TmCustomerEntity> getCustListByOrgDown(String orgId, String orgCode) {
        TmOrgVo tmOrgVo = this.orgService.getOrgByIdOrCode(orgId, orgCode);
        return this.customerDao.getCustListByOrgDown(tmOrgVo.getCodeRule());
    }

    @Override
    public List<TmCustomerEntity> getCustListByOrg(String orgId, String orgCode) {
        TmOrgVo tmOrgVo = this.orgService.getOrgByIdOrCode(orgId, orgCode);
        Example example = new Example(TmCustomerEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("orgId", (Object)tmOrgVo.getId());
        return this.customerDao.selectByExample(example);
    }

    @Override
    public List<TmCustomerEntity> getCustListByPosDown(String posId, String posCode) {
        TmPositionEntity positionEntity = this.positionService.getTmPosition(posId, posCode);
        return this.customerDao.getCustListByPosDown(positionEntity.getCodeRule());
    }

    @Override
    public List<TmCustomerEntity> getCustListByPos(String posId, String posCode) {
        TmPositionEntity positionEntity = this.positionService.getTmPosition(posId, posCode);
        return this.customerDao.getCustListByPos(positionEntity.getId());
    }

    @Override
    public List<TmRCustPosBgDetailEntity> getTmRCustPosBgDetail(String custCode, List<String> typeCode) {
        return this.tmRCustPosBgDetailDao.getTmRCustPosBgDetail(custCode, typeCode);
    }

    @Override
    public List<TmCustomerEntity> getCustomerListByCustomerCodeOrId(List<String> customerCodes, List<String> customerIds) {
        if (CollectionUtil.listEmpty(customerCodes) && CollectionUtil.listEmpty(customerIds)) {
            return new ArrayList<TmCustomerEntity>();
        }
        Example example = new Example(TmCustomerEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (CollectionUtil.listNotEmptyNotSizeZero(customerCodes)) {
            criteria.orIn("customerCode", customerCodes);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(customerIds)) {
            criteria.orIn("id", customerIds);
        }
        return this.customerDao.selectByExample(example);
    }

    @Override
    public List<TmCustomerVo> findCustomerByOrgCodes(List<String> orgCodes) {
        return this.customerDao.findCustomerByOrgCodes(orgCodes);
    }
}

