/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.productPrice.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.price.PriceParamVo;
import com.biz.eisp.price.PriceReturnVo;
import com.biz.eisp.productPrice.dao.TmProductPriceDao;
import com.biz.eisp.productPrice.entity.TmProductPriceEntity;
import com.biz.eisp.productPrice.service.TmProductPriceService;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class TmProductPriceServiceImpl
implements TmProductPriceService {
    @Autowired
    private TmProductPriceDao tmProductPriceDao;

    @Override
    public PageInfo<TmProductPriceEntity> findProductPriceByPage(Map<String, Object> param, Page page) {
        Example example = new Example(TmProductPriceEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((Object)param.get("id"))) {
            criteria.andEqualTo("id", param.get("id"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("productInfoCode"))) {
            criteria.andLike("productInfoCode", "%" + param.get("productInfoCode").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("productInfoName"))) {
            criteria.andLike("productInfoName", "%" + param.get("productInfoName").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("saleCompany"))) {
            criteria.andLike("saleCompany", "%" + param.get("saleCompany").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("priceGroup"))) {
            criteria.andLike("priceGroup", "%" + param.get("priceGroup").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("customerCode"))) {
            criteria.andLike("customerCode", "%" + param.get("customerCode").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("beginDate"))) {
            criteria.andGreaterThan("endTime", (Object)param.get("beginDate").toString());
        }
        if (StringUtil.isNotEmpty((Object)param.get("beginDate"))) {
            criteria.andLessThan("beginTime", (Object)param.get("beginDate").toString());
        }
        example.setOrderByClause("price_priority ASC,end_time DESC");
        return PageAutoHelperUtil.generatePage(() -> this.tmProductPriceDao.selectByExample(example), (Page)page);
    }

    @Override
    public List<TmProductPriceEntity> findProductPriceList(PriceParamVo priceParamVo) {
        Example example = new Example(TmProductPriceEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)priceParamVo.getPriceDimension())) {
            criteria.andEqualTo("priceDimension", (Object)priceParamVo.getPriceDimension());
        }
        if (StringUtil.isNotEmpty((CharSequence)priceParamVo.getPriceGroup())) {
            criteria.andEqualTo("priceGroup", (Object)priceParamVo.getPriceGroup());
        }
        if (StringUtil.isNotEmpty((CharSequence)priceParamVo.getCustCode())) {
            criteria.andEqualTo("customerCode", (Object)priceParamVo.getCustCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)priceParamVo.getPriceDate())) {
            criteria.andGreaterThan("endTime", (Object)priceParamVo.getPriceDate());
        }
        if (StringUtil.isNotEmpty((CharSequence)priceParamVo.getPriceDate())) {
            criteria.andLessThan("beginTime", (Object)priceParamVo.getPriceDate());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)priceParamVo.getProductCodes())) {
            criteria.andIn("productInfoCode", (Iterable)priceParamVo.getProductCodes());
        }
        criteria.andEqualTo("deleteStatus", (Object)"0");
        example.setOrderByClause("price_priority ASC,end_time DESC");
        return this.tmProductPriceDao.selectByExample(example);
    }

    @Override
    public List<PriceReturnVo> getPriceReturnVos(PriceParamVo priceParamVo) {
        ArrayList<PriceReturnVo> priceReturnVos = new ArrayList<PriceReturnVo>();
        List<String> strings = priceParamVo.getProductCodes();
        strings = strings.stream().distinct().collect(Collectors.toList());
        ArrayList<String> newStrings = new ArrayList<String>();
        List list = DictUtil.getDictList((String)"price_dimension");
        for (int i = 0; i < list.size(); ++i) {
            KnlDictDataEntity temp = (KnlDictDataEntity)list.get(i);
            Object o = temp.getExtendMap().get("priority");
            if (o != null && !StringUtil.isBlank((CharSequence)o.toString())) continue;
            list.remove(i);
            --i;
        }
        list.sort(new Comparator<KnlDictDataEntity>(){

            @Override
            public int compare(KnlDictDataEntity o1, KnlDictDataEntity o2) {
                Integer o1sort = Integer.valueOf(String.valueOf(o1.getExtendMap().get("priority")));
                Integer o2sort = Integer.valueOf(String.valueOf(o2.getExtendMap().get("priority")));
                return o1sort.compareTo(o2sort);
            }
        });
        for (KnlDictDataEntity entity : list) {
            PriceReturnVo priceReturnVo;
            List<TmProductPriceEntity> tmProductPriceEntities;
            PriceParamVo priceParamVoTemp;
            if (!CollectionUtil.listNotEmptyNotSizeZero(strings)) break;
            if (StringUtil.equals((String)entity.getDictCode(), (String)ConstantEnum.PriceDimensionEnum.CUSTOMER.getValue())) {
                if (StringUtil.isEmpty((String)priceParamVo.getCustCode()) || strings.size() == 0) continue;
                newStrings = new ArrayList();
                priceParamVoTemp = new PriceParamVo();
                priceParamVoTemp.setProductCodes(strings);
                priceParamVoTemp.setCustCode(priceParamVo.getCustCode());
                priceParamVoTemp.setPriceDate(priceParamVo.getPriceDate());
                priceParamVoTemp.setPriceDimension(ConstantEnum.PriceDimensionEnum.CUSTOMER.getValue());
                tmProductPriceEntities = this.findProductPriceList(priceParamVoTemp);
                if (CollectionUtil.listNotEmptyNotSizeZero(tmProductPriceEntities)) {
                    for (TmProductPriceEntity tmProductPriceEntity : tmProductPriceEntities) {
                        newStrings.add(tmProductPriceEntity.getProductInfoCode());
                        priceReturnVo = new PriceReturnVo();
                        priceReturnVo.setPriceAmount(tmProductPriceEntity.getUnitPrice());
                        priceReturnVo.setProductInfoCode(tmProductPriceEntity.getProductInfoCode());
                        priceReturnVo.setProductInfoName(tmProductPriceEntity.getProductInfoName());
                        priceReturnVos.add(priceReturnVo);
                    }
                }
                this.getList(strings, newStrings);
                continue;
            }
            if (StringUtil.equals((String)entity.getDictCode(), (String)ConstantEnum.PriceDimensionEnum.PRICEGROUP.getValue())) {
                if (StringUtil.isEmpty((String)priceParamVo.getPriceGroup()) || strings.size() == 0) continue;
                newStrings = new ArrayList();
                priceParamVoTemp = new PriceParamVo();
                priceParamVoTemp.setProductCodes(strings);
                priceParamVoTemp.setPriceGroup(priceParamVo.getPriceGroup());
                priceParamVoTemp.setPriceDate(priceParamVo.getPriceDate());
                priceParamVoTemp.setPriceDimension(ConstantEnum.PriceDimensionEnum.PRICEGROUP.getValue());
                tmProductPriceEntities = this.findProductPriceList(priceParamVoTemp);
                if (CollectionUtil.listNotEmptyNotSizeZero(tmProductPriceEntities)) {
                    for (TmProductPriceEntity tmProductPriceEntity : tmProductPriceEntities) {
                        newStrings.add(tmProductPriceEntity.getProductInfoCode());
                        priceReturnVo = new PriceReturnVo();
                        priceReturnVo.setPriceAmount(tmProductPriceEntity.getUnitPrice());
                        priceReturnVo.setProductInfoCode(tmProductPriceEntity.getProductInfoCode());
                        priceReturnVo.setProductInfoName(tmProductPriceEntity.getProductInfoName());
                        priceReturnVos.add(priceReturnVo);
                    }
                }
                this.getList(strings, newStrings);
                continue;
            }
            if (!StringUtil.equals((String)entity.getDictCode(), (String)ConstantEnum.PriceDimensionEnum.PRODUCT.getValue()) || strings.size() <= 0) continue;
            priceParamVoTemp = new PriceParamVo();
            priceParamVoTemp.setProductCodes(strings);
            priceParamVoTemp.setPriceDate(priceParamVo.getPriceDate());
            priceParamVoTemp.setPriceDimension(ConstantEnum.PriceDimensionEnum.PRODUCT.getValue());
            newStrings = new ArrayList();
            tmProductPriceEntities = this.findProductPriceList(priceParamVoTemp);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmProductPriceEntities)) {
                for (TmProductPriceEntity tmProductPriceEntity : tmProductPriceEntities) {
                    newStrings.add(tmProductPriceEntity.getProductInfoCode());
                    priceReturnVo = new PriceReturnVo();
                    priceReturnVo.setPriceAmount(tmProductPriceEntity.getUnitPrice());
                    priceReturnVo.setProductInfoCode(tmProductPriceEntity.getProductInfoCode());
                    priceReturnVo.setProductInfoName(tmProductPriceEntity.getProductInfoName());
                    priceReturnVos.add(priceReturnVo);
                }
            }
            this.getList(strings, newStrings);
        }
        return priceReturnVos;
    }

    @Override
    public List<PriceReturnVo> getCustPriceReturnVos(PriceParamVo priceParamVo) {
        ArrayList<PriceReturnVo> priceReturnVos = new ArrayList<PriceReturnVo>();
        List strings = priceParamVo.getProductCodes();
        strings = strings.stream().distinct().collect(Collectors.toList());
        PriceParamVo priceParamVoTemp = new PriceParamVo();
        priceParamVoTemp.setProductCodes(strings);
        priceParamVoTemp.setCustCode(priceParamVo.getCustCode());
        priceParamVoTemp.setPriceDate(priceParamVo.getPriceDate());
        priceParamVoTemp.setPriceDimension(ConstantEnum.PriceDimensionEnum.CUSTOMER.getValue());
        List<TmProductPriceEntity> tmProductPriceEntities = this.findProductPriceList(priceParamVoTemp);
        if (CollectionUtil.listNotEmptyNotSizeZero(tmProductPriceEntities)) {
            for (TmProductPriceEntity tmProductPriceEntity : tmProductPriceEntities) {
                PriceReturnVo priceReturnVo = new PriceReturnVo();
                priceReturnVo.setPriceAmount(tmProductPriceEntity.getUnitPrice());
                priceReturnVo.setProductInfoCode(tmProductPriceEntity.getProductInfoCode());
                priceReturnVo.setProductInfoName(tmProductPriceEntity.getProductInfoName());
                priceReturnVos.add(priceReturnVo);
            }
        }
        return priceReturnVos;
    }

    private List<String> getList(List<String> mAllList, List<String> mSubList) {
        int i;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (i = 0; i < mAllList.size(); ++i) {
            map.put(mAllList.get(i), i);
        }
        for (i = 0; i < mSubList.size(); ++i) {
            Integer pos = (Integer)map.get(mSubList.get(i));
            if (pos == null) continue;
            mAllList.set(pos, null);
        }
        for (i = mAllList.size() - 1; i >= 0; --i) {
            if (mAllList.get(i) != null) continue;
            mAllList.remove(i);
        }
        return mAllList;
    }

    @Override
    public List<String> deleteProductForList(List<String> productCodes, String type) {
        ArrayList<String> list = new ArrayList<String>();
        if ("0".equals(type)) {
            // empty if block
        }
        return list;
    }
}

