/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.custOrg.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.custOrg.entity.TmCustomerOrgEntity;
import com.biz.eisp.custOrg.service.CustOrgApiService;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"MDM-\u5ba2\u6237\u7ec4\u7ec7"}, description="CRM-MDM MDM\u5ba2\u6237\u7ec4\u7ec7\u5173\u7cfb")
@RestController
@RequestMapping(value={"/mdmApi/custOrgApiController"})
public class CustOrgApiController {
    @Autowired
    private CustOrgApiService custOrgApiService;

    @PostMapping(value={"getCustOrgPageList"})
    public AjaxJson<TmCustomerOrgEntity> findCustOrgList(@RequestBody TmCustomerOrgEntity tmCustomerOrgEntity, @RequestParam(value="page") String page, @RequestParam(value="rows") String rows) {
        AjaxJson ajaxJson = new AjaxJson();
        Page pageEm = new Page();
        pageEm.setPage(page);
        pageEm.setRows(rows);
        PageInfo<TmCustomerOrgEntity> orgEntities = this.custOrgApiService.getCustOrgList(tmCustomerOrgEntity, pageEm);
        ajaxJson.setPageInfo(orgEntities);
        return ajaxJson;
    }

    @PostMapping(value={"getCustOrgList"})
    public AjaxJson<TmCustomerOrgEntity> getCustOrgList(@RequestBody TmCustomerOrgEntity tmOrgEntity) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmCustomerOrgEntity> orgEntities = this.custOrgApiService.getCustOrgList(tmOrgEntity);
        ajaxJson.setObjList(orgEntities);
        return ajaxJson;
    }

    @PostMapping(value={"findCustOrgEntityByIdOrCode"})
    public AjaxJson<TmCustomerOrgEntity> findCustOrgEntityByIdOrCode(@RequestBody TmCustomerOrgEntity tmCustomerOrgEntity) {
        AjaxJson<TmCustomerOrgEntity> ajaxJson = this.custOrgApiService.findCustOrgEntityByIdOrCode(tmCustomerOrgEntity);
        return ajaxJson;
    }

    @PostMapping(value={"findListCustOrgAndChild"})
    public AjaxJson<TmCustomerOrgEntity> findListCustOrgAndChild(@RequestBody TmCustomerOrgEntity tmCustomerOrgEntity) {
        AjaxJson<TmCustomerOrgEntity> ajaxJson = this.custOrgApiService.findListCustOrgAndChild(tmCustomerOrgEntity);
        return ajaxJson;
    }

    @PostMapping(value={"findTreeCustOrgAndChild"})
    public AjaxJson<TmCustomerOrgEntity> findTreeCustOrgAndChild(@RequestBody TmCustomerOrgEntity tmCustomerOrgEntity) {
        AjaxJson<TmCustomerOrgEntity> ajaxJson = this.custOrgApiService.findTreeCustOrgAndChild(tmCustomerOrgEntity);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u7ec4\u7ec7\u4fe1\u606f", notes="\u67e5\u8be2\u5ba2\u6237\u7ec4\u7ec7\u4fe1\u606f,{\"id\":\"ID\",\"custOrgCode\":\"\u5ba2\u6237\u7f16\u7801\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728obj", httpMethod="GET")
    @GetMapping(value={"getTmCustomerOrgByIdOrCode"})
    public AjaxJson<TmCustomerOrgEntity> getTmCustomerOrgByIdOrCode(@RequestParam(value="id", required=false) String id, @RequestParam(value="custOrgCode", required=false) String custOrgCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TmCustomerOrgEntity entity = this.custOrgApiService.getTmCustomerOrgByIdOrCode(id, custOrgCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @ApiOperation(value="\u67e5\u8be2\u5ba2\u6237\u7ec4\u7ec7\u5217\u8868", notes="\u67e5\u8be2\u5ba2\u6237\u7ec4\u7ec7\u5217\u8868,{\"ids\":\"\u5ba2\u6237\u7ec4\u7ec7ID\u96c6\u5408\",\"custOrgCodes\":\"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\"},\u8fd4\u56de\u5206\u9875\u6570\u636e \u5728objList", httpMethod="GET")
    @GetMapping(value={"getTmCustomerOrgListByIdOrCode"})
    public AjaxJson<TmCustomerOrgEntity> getTmCustomerOrgListByIdOrCode(@RequestParam(value="ids", required=false) List<String> ids, @RequestParam(value="custOrgCodes", required=false) List<String> custOrgCodes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TmCustomerOrgEntity> result = this.custOrgApiService.getTmCustomerOrgListByIdOrCode(ids, custOrgCodes);
        ajaxJson.setObjList(result);
        return ajaxJson;
    }
}

