/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.function.service.impl;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.function.FunctionQueryVo;
import com.biz.eisp.function.TmFunctionVo;
import com.biz.eisp.function.dao.FunctionDao;
import com.biz.eisp.function.entity.TmFunctionEntity;
import com.biz.eisp.function.service.FunctionService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class FunctionServiceImpl
implements FunctionService {
    @Autowired
    private FunctionDao functionDao;

    @Override
    public List<TmFunctionVo> getFunctionsByParam(FunctionQueryVo functionQueryVo) {
        Example example = new Example(TmFunctionEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)functionQueryVo.getId())) {
            criteria.andEqualTo("id", (Object)functionQueryVo.getId());
        }
        if (StringUtil.isNotEmpty((CharSequence)functionQueryVo.getFunctionName())) {
            criteria.andLike("functionName", "%" + functionQueryVo.getFunctionName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)functionQueryVo.getFunctionModule())) {
            criteria.andEqualTo("functionModule", (Object)functionQueryVo.getFunctionModule());
        }
        if (StringUtil.isNotEmpty((CharSequence)functionQueryVo.getFunctionLevel())) {
            criteria.andEqualTo("functionLevel", (Object)functionQueryVo.getFunctionLevel());
        }
        if (StringUtil.isNotEmpty((CharSequence)functionQueryVo.getIsSystem())) {
            criteria.andEqualTo("isSystem", (Object)functionQueryVo.getIsSystem());
        }
        if (StringUtil.isNotEmpty((CharSequence)functionQueryVo.getParentId())) {
            criteria.andEqualTo("parentId", (Object)functionQueryVo.getParentId());
        }
        List listEntitys = this.functionDao.selectByExample(example);
        ArrayList<TmFunctionVo> functionVos = new ArrayList<TmFunctionVo>();
        listEntitys.forEach(item -> {
            TmFunctionVo vo = new TmFunctionVo();
            BeanUtils.copyProperties((Object)item, (Object)vo);
            functionVos.add(vo);
        });
        return functionVos;
    }

    @Override
    public PageInfo<TmFunctionEntity> getFunctionsByParam(Map<String, Object> param, Page page) {
        Example example = new Example(TmFunctionEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((Object)param.get("id"))) {
            criteria.andEqualTo("id", param.get("id"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("functionName"))) {
            criteria.andLike("functionName", "%" + param.get("functionName").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("functionUrl"))) {
            criteria.andLike("functionUrl", "%" + param.get("functionUrl").toString() + "%");
        }
        if (StringUtil.isNotEmpty((Object)param.get("functionModule"))) {
            criteria.andEqualTo("functionModule", param.get("functionModule"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("functionLevel"))) {
            criteria.andEqualTo("functionLevel", param.get("functionLevel"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("parentId"))) {
            criteria.andEqualTo("parentId", param.get("parentId"));
        }
        if (StringUtil.isNotEmpty((Object)param.get("isConfigure"))) {
            criteria.andEqualTo("isConfigure", param.get("isConfigure"));
        }
        criteria.andEqualTo("isSystem", (Object)0);
        criteria.andIsNotNull("functionUrl");
        return PageAutoHelperUtil.generatePage(() -> this.functionDao.selectByExample(example), (Page)page);
    }
}

