/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.exceptions;

import com.sap.conn.jco.util.FastStringBuffer;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcIoErrorCode;
import com.sap.conn.rfc.exceptions.RfcRc;
import java.io.IOException;

public class RfcIoException
extends IOException
implements RfcIoErrorCode,
RfcRc {
    private static final long serialVersionUID = 300012082005L;
    private int ioRc;
    private int errorGroup;
    private String key;

    public RfcIoException(int iorc, String message) {
        this(iorc, message, true);
    }

    public RfcIoException(int iorc, String message, boolean trace) {
        super(message == null ? "no message received" : message);
        this.ioRc = iorc;
        this.processIoRC();
        if (trace) {
            Trc.criticalTrace(null, this.toString());
        }
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer(300);
        buf.append("\n>RfcIoException:");
        buf.append("\n    message: ");
        buf.append(this.getMessage());
        buf.append("\n    Return code: ");
        buf.append(this.getIoRcAsString());
        buf.append("(");
        buf.append(this.ioRc);
        buf.append(")");
        buf.append("<\n\n");
        return buf.toString();
    }

    public String getIoRcAsString() {
        switch (this.ioRc) {
            case 0: {
                return "RFCIO_O_K";
            }
            case 1: {
                return "RFCIO_ERROR_TOOLONG";
            }
            case 2: {
                return "RFCIO_ERROR_NOMEM";
            }
            case 3: {
                return "RFCIO_ERROR_INTERNAL";
            }
            case 4: {
                return "RFCIO_ERROR_NOHANDLE";
            }
            case 5: {
                return "RFCIO_ERROR_SYSERROR";
            }
            case 6: {
                return "RFCIO_ERROR_ALREADY_WAITING";
            }
            case 7: {
                return "RFCIO_ERROR_ENDREAD";
            }
            case 8: {
                return "RFCIO_ERROR_NO_DATA";
            }
            case 9: {
                return "RFCIO_ERROR_ILL_TYPE";
            }
            case 10: {
                return "RFCIO_ERROR_DEALLOCATED";
            }
            case 11: {
                return "RFCIO_ERROR_NO_WAIT";
            }
            case 12: {
                return "RFCIO_ERROR_NO_ABORT";
            }
            case 13: {
                return "RFCIO_ERROR_DRV_NAME";
            }
            case 14: {
                return "RFCIO_ERROR_DRV";
            }
            case 15: {
                return "RFCIO_ERROR_NO_BUFFER";
            }
            case 16: {
                return "RFCIO_ERROR_ILLEGAL_NAME";
            }
            case 17: {
                return "RFCIO_NO_DATA";
            }
            case 18: {
                return "RFCIO_NO_DRIVER";
            }
            case 19: {
                return "RFCIO_ERROR_SAPTEMU_TOO_MUCH";
            }
            case 20: {
                return "RFCIO_ERROR_SAPTEMU_ILLEGAL";
            }
            case 21: {
                return "RFCIO_ERROR_VERSION_MISMATCH";
            }
            case 22: {
                return "RFCIO_ERROR_RFCLG_INTERNAL";
            }
            case 23: {
                return "RFCIO_ERROR_CANCELLED";
            }
            case 24: {
                return "RFCIO_ERROR_BUSY";
            }
            case 25: {
                return "RFCIO_ERROR_CONVERSION";
            }
            case 26: {
                return "RFCIO_ERROR_CONVERSION_REPL";
            }
            case 27: {
                return "RFCIO_ERROR_MESSAGE";
            }
            case 28: {
                return "RFCIO_ERROR_SHM_PLUGIN";
            }
            case 29: {
                return "RFCIO_ERROR_DEALLOCATED_NORMAL";
            }
            case 30: {
                return "RFCIO_ERROR_TH_VMC";
            }
            case 31: {
                return "RFCIO_ERROR_IOCONTROL";
            }
            case 32: {
                return "RFCIO_ERROR_JAVA";
            }
            case 33: {
                return "RFCIO_ERROR_DEALLOCATED_REMOTE_ERROR";
            }
            case 34: {
                return "RFCIO_ERROR_CONNECTION_CANCELLED";
            }
            case 35: {
                return "RFCIO_ERROR_REGISTRATION_DENIED";
            }
        }
        return "Unknown IORC return code " + this.ioRc;
    }

    public int getIoRc() {
        return this.ioRc;
    }

    public String getKey() {
        return this.key;
    }

    public int getErrorGroup() {
        return this.errorGroup;
    }

    private void processIoRC() {
        switch (this.ioRc) {
            case 2: {
                this.errorGroup = 106;
                this.key = "RFC_ERROR_RESOURCE";
                break;
            }
            case 5: {
                this.errorGroup = 102;
                this.key = "RFC_ERROR_COMMUNICATION";
                break;
            }
            case 8: {
                this.errorGroup = 107;
                this.key = "RFC_ERROR_PROTOCOL";
                break;
            }
            case 10: 
            case 29: {
                this.errorGroup = 102;
                this.key = "RFC_ERROR_COMMUNICATION";
                break;
            }
            case 33: {
                this.errorGroup = 104;
                this.key = "RFC_ERROR_SYSTEM_FAILURE";
                break;
            }
            case 22: {
                this.errorGroup = 102;
                this.key = "RFC_ERROR_COMMUNICATION";
                break;
            }
            case 34: {
                this.errorGroup = 112;
                this.key = "RFC_ERROR_REQUEST_CANCELLED";
                break;
            }
            case 23: {
                this.errorGroup = 109;
                this.key = "RFC_ERROR_CANCELLED";
                break;
            }
            case 24: {
                this.errorGroup = 110;
                this.key = "RFC_ERROR_BUSY";
                break;
            }
            case 35: {
                this.errorGroup = 113;
                this.key = "RFC_ERROR_REGISTRATION_DENIED";
                break;
            }
            default: {
                this.errorGroup = 104;
                this.key = "RFC_ERROR_SYSTEM_FAILURE";
            }
        }
    }
}

