/*
 * Decompiled with CFR 0.152.
 */
package com.biz.core.exception;

import com.biz.core.exception.ExceptionType;
import org.springframework.util.StringUtils;

public class BusinessException
extends RuntimeException {
    private static final long serialVersionUID = -6076037770876023101L;
    private Integer code;
    private String description;
    private ExceptionType type;

    public BusinessException(ExceptionType type) {
        this(type.getCode(), type.getDescription(), type);
    }

    public BusinessException(ExceptionType type, Throwable cause) {
        this(type.getCode(), type.getDescription(), type, cause);
    }

    public BusinessException(ExceptionType type, String desc, Throwable cause) {
        this(type.getCode(), desc, type, cause);
    }

    public BusinessException(ExceptionType type, String desc) {
        this(type.getCode(), desc, type);
    }

    private BusinessException(Integer code, String description, ExceptionType type, Throwable cause) {
        super(description, cause);
        this.code = code;
        this.description = description;
        this.type = type;
    }

    private BusinessException(Integer code, String description, ExceptionType type) {
        super(description);
        this.code = code;
        this.description = description;
        this.type = type;
    }

    @Override
    public String getMessage() {
        return StringUtils.hasText((String)this.description) ? this.description : (StringUtils.hasText((String)this.type.getDescription()) ? this.type.getDescription() : "");
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public ExceptionType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BusinessException other = (BusinessException)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

