/*
 * Decompiled with CFR 0.152.
 */
package com.biz.core.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.codelogger.utils.MathUtils;
import org.codelogger.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T json2Obj(String jsonStr, Class<T> clazz) {
        if (jsonStr == null) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(jsonStr, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u53cd\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    public static <T> T json2Obj(String content, Class<T> clazzItem, Class ... classes) {
        if (StringUtils.isBlank((String)content)) {
            return null;
        }
        JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(clazzItem, classes);
        try {
            return (T)OBJECT_MAPPER.readValue(content, javaType);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u53cd\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    public static String obj2Json(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException("Json\u5e8f\u5217\u5316\u51fa\u9519", e);
        }
    }

    public static void printObjectJsonDemo(Object obj) {
        JsonUtil.fillValueToField(obj, true);
    }

    private static void fillValueToField(Object obj, Boolean isFirst) {
        if (obj == null) {
            logger.debug("null");
        } else {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = obj.getClass().getDeclaredFields()) {
                String fieldName = declaredField.getName();
                if (Modifier.isFinal(declaredField.getModifiers())) continue;
                declaredField.setAccessible(true);
                Type genericType = declaredField.getGenericType();
                try {
                    ConcurrentLinkedQueue value = declaredField.get(obj);
                    if (value == null) {
                        if (genericType == Integer.class || genericType == Integer.TYPE) {
                            value = MathUtils.randomInt();
                        } else if (genericType == Long.class || genericType == Long.TYPE) {
                            value = MathUtils.randomLong();
                        } else if (genericType == Double.class || genericType == Double.TYPE) {
                            value = MathUtils.randomDouble();
                        } else if (genericType == String.class) {
                            value = "valueOf" + StringUtils.firstCharToUpperCase((String)fieldName);
                        } else if (genericType == Boolean.class || genericType == Boolean.TYPE) {
                            value = MathUtils.randomInt() % 2 == 0;
                        } else if (genericType == Byte.class || genericType == Byte.TYPE) {
                            value = String.valueOf(StringUtils.getRandomAlphabetic()).getBytes()[0];
                        } else if (genericType == Short.class || genericType == Short.TYPE) {
                            value = (short)MathUtils.randomInt((int)1, (int)9);
                        } else if (genericType == Character.class || genericType == Character.TYPE) {
                            value = Character.valueOf(StringUtils.getRandomAlphabetic());
                        } else if (genericType == BigDecimal.class) {
                            value = new BigDecimal(MathUtils.randomInt());
                        } else if (genericType == List.class) {
                            value = Lists.newArrayList();
                        } else if (genericType == Set.class) {
                            value = Sets.newHashSet();
                        } else if (genericType == Map.class) {
                            value = Maps.newHashMap();
                        } else if (genericType == Queue.class) {
                            value = new ConcurrentLinkedQueue();
                        }
                        if (value == null && isFirst.booleanValue()) {
                            try {
                                value = Class.forName(genericType.toString().split("\\s")[1]).newInstance();
                                JsonUtil.fillValueToField(value, false);
                            }
                            catch (Exception ignored) {
                                ignored.printStackTrace();
                            }
                        }
                    } else if (isFirst.booleanValue()) {
                        try {
                            JsonUtil.fillValueToField(value, false);
                        }
                        catch (Exception ignored) {
                            ignored.printStackTrace();
                        }
                    }
                    if (value == null) continue;
                    declaredField.set(obj, value);
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            }
        }
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

