/*
 * Decompiled with CFR 0.152.
 */
package com.biz.core.spring.event;

import com.biz.core.asserts.SystemAsserts;
import com.biz.core.exception.SystemException;
import com.biz.core.spring.event.AsyncBizEventWrapper;
import com.biz.core.spring.event.BizEvent;
import com.biz.core.spring.event.SyncBizEventWrapper;
import com.biz.core.spring.jpatranaction.BizTranactionManager;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class BizEventPublisher
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void publishEvent(BizEvent event) {
        SystemAsserts.notNull((Object)event, "\u53d1\u5e03\u4e8b\u4ef6\u65f6\u4e8b\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3anull", new Object[0]);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new AsyncBizEventWrapper(event));
    }

    public void syncPublishEvent(BizEvent event) {
        SystemAsserts.notNull((Object)event, "\u53d1\u5e03\u4e8b\u4ef6\u65f6\u4e8b\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3anull", new Object[0]);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SyncBizEventWrapper(event));
    }

    public void publishEventUsingTransactionManager(BizEvent event) {
        SystemAsserts.notNull((Object)event, "\u53d1\u5e03\u4e8b\u4ef6\u65f6\u4e8b\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3anull", new Object[0]);
        try {
            BizTranactionManager.publishEvent(event, true);
        }
        catch (SystemException e) {
            throw new UnsupportedOperationException("\u4f60\u53ef\u80fd\u6ca1\u6709\u4f7f\u7528BizTranactionManager\u6765\u4f5c\u4e3a\u4e8b\u52a1\u7ba1\u7406\u5668", e);
        }
    }

    public void syncPublishEventUsingTransactionManager(BizEvent event) {
        SystemAsserts.notNull((Object)event, "\u53d1\u5e03\u4e8b\u4ef6\u65f6\u4e8b\u4ef6\u5bf9\u8c61\u4e0d\u80fd\u4e3anull", new Object[0]);
        try {
            BizTranactionManager.publishEvent(event, false);
        }
        catch (SystemException e) {
            throw new UnsupportedOperationException("\u4f60\u53ef\u80fd\u6ca1\u6709\u4f7f\u7528BizTranactionManager\u6765\u4f5c\u4e3a\u4e8b\u52a1\u7ba1\u7406\u5668", e);
        }
    }
}

