/*
 * Decompiled with CFR 0.152.
 */
package com.redis.utils;

import com.biz.core.utils.StringUtil;
import com.biz.core.zookeeper.ZkProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.util.Hashing;

public class ShardedJedisPoolLoad {
    private static final Logger log = LoggerFactory.getLogger(ShardedJedisPoolLoad.class);
    private static ShardedJedisPool shardedJedisPool;

    public static synchronized ShardedJedisPool getJedisPool() {
        return shardedJedisPool;
    }

    public static synchronized ShardedJedisPool getJedisPool(String zookeeperUrl, Boolean configByZookeeper, String localConfigPath) {
        if (shardedJedisPool == null) {
            log.debug("\u5f00\u59cb\u521d\u59cb\u5316redis\u6c60\u5bf9\u8c61");
            PropertiesConfiguration config = null;
            try {
                if (configByZookeeper.booleanValue() && StringUtils.isNotBlank((CharSequence)zookeeperUrl)) {
                    log.debug("zookeeper\u52a0\u8f7dredis\u914d\u7f6e\u6587\u4ef6");
                    ZkProperties zkProperties = new ZkProperties("/bozhi/config/redis.properties");
                    config = new PropertiesConfiguration();
                    config.load((InputStream)new ByteArrayInputStream(zkProperties.getPropertiesBytes()));
                } else {
                    config = new PropertiesConfiguration(localConfigPath);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u52a0\u8f7dredis\u914d\u7f6e\u51fa\u9519,-->", (Object)e.getMessage());
            }
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(config.getInt("redis.maxTotal"));
            poolConfig.setMaxIdle(config.getInt("redis.maxIdle"));
            poolConfig.setTimeBetweenEvictionRunsMillis(config.getLong("redis.timeBetweenEvictionRunsMillis"));
            poolConfig.setMinEvictableIdleTimeMillis(config.getLong("redis.minEvictableIdleTimeMillis"));
            poolConfig.setTestOnBorrow(config.getBoolean("redis.testOnBorrow"));
            log.debug("\u5f00\u59cb\u52a0\u8f7dredis\u4e3b\u673a\u5217\u8868");
            String hosts = config.getString("redis.host");
            String ports = config.getString("redis.port");
            String dbnames = config.getString("redis.name");
            String pwasswords = config.getString("redis.password");
            ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
            String[] hostArr = hosts.split("@");
            String[] portArr = ports.split("@");
            String[] dbnameArr = null;
            if (StringUtils.isNotBlank((CharSequence)dbnames)) {
                dbnameArr = dbnames.split("@");
            }
            String[] pwasswordArr = null;
            if (StringUtils.isNotBlank((CharSequence)pwasswords)) {
                pwasswordArr = pwasswords.split("@");
            }
            if (hostArr.length == portArr.length) {
                for (int i = 0; i < hostArr.length; ++i) {
                    String name;
                    String host = hostArr[i].trim();
                    int port = Integer.parseInt(portArr[i].trim());
                    String string = dbnameArr == null ? "" : (name = dbnameArr[i] == null ? "" : dbnameArr[i].trim());
                    String password = pwasswordArr == null ? "" : (pwasswordArr[i] == null ? "" : pwasswordArr[i].trim());
                    log.debug("redis\u4e3b\u673a, host: {}, port: {}, name: {}", new Object[]{host, port, name});
                    JedisShardInfo jedisShardInfo = null;
                    jedisShardInfo = StringUtil.isNullOrEmpty((String)name) ? new JedisShardInfo(host, port, config.getInt("redis.socketTimeout", 2000)) : new JedisShardInfo(host, port, config.getInt("redis.socketTimeout", 2000), name);
                    if (StringUtils.isNotBlank((CharSequence)password)) {
                        jedisShardInfo.setPassword(password);
                    }
                    shards.add(jedisShardInfo);
                }
            } else {
                log.error("redis\u914d\u7f6e\u6709\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5");
                throw new RuntimeException("redis\u914d\u7f6e\u6709\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5");
            }
            if (shards.isEmpty()) {
                log.error("\u8bf7\u6307\u5b9a\u81f3\u5c11\u4e00\u4e2aredis\u4e3b\u673a");
                throw new RuntimeException("\u8bf7\u6307\u5b9a\u81f3\u5c11\u4e00\u4e2aredis\u4e3b\u673a");
            }
            shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)poolConfig, shards);
        }
        return shardedJedisPool;
    }

    public static class ShardHashing
    implements Hashing {
        static final String keys = "global user shop colony timeline deal";

        public long hash(String key) {
            if (key.indexOf("SHARD-") == 0) {
                return 0L;
            }
            return keys.indexOf(StringUtils.substringBefore((String)key, (String)"*"));
        }

        public long hash(byte[] key) {
            return keys.indexOf(StringUtils.substringBefore((String)new String(key), (String)":"));
        }
    }
}

