/*
 * Decompiled with CFR 0.152.
 */
package com.redis.utils;

import com.biz.core.zookeeper.ZkProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisPoolLoad {
    private static final Logger log = LoggerFactory.getLogger(JedisPoolLoad.class);
    private static JedisPool jedisPool;

    public static synchronized JedisPool jedisPool() {
        return jedisPool;
    }

    public static synchronized JedisPool jedisPool(String zookeeperUrl, Boolean configByZookeeper, String localConfigPath) {
        if (jedisPool == null) {
            log.debug("\u5f00\u59cb\u521d\u59cb\u5316redis\u6c60\u5bf9\u8c61");
            PropertiesConfiguration config = null;
            try {
                if (configByZookeeper.booleanValue() && StringUtils.isNotBlank((CharSequence)zookeeperUrl)) {
                    log.debug("zookeeper\u52a0\u8f7dredis\u914d\u7f6e\u6587\u4ef6");
                    ZkProperties zkProperties = new ZkProperties("/bozhi/config/redis.properties");
                    config = new PropertiesConfiguration();
                    config.load((InputStream)new ByteArrayInputStream(zkProperties.getPropertiesBytes()));
                } else {
                    config = new PropertiesConfiguration(localConfigPath);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u52a0\u8f7dredis\u914d\u7f6e\u51fa\u9519,-->", (Object)e.getMessage());
            }
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(config.getInt("redis.maxTotal"));
            poolConfig.setMaxIdle(config.getInt("redis.maxIdle"));
            poolConfig.setTimeBetweenEvictionRunsMillis(config.getLong("redis.timeBetweenEvictionRunsMillis"));
            poolConfig.setMinEvictableIdleTimeMillis(config.getLong("redis.minEvictableIdleTimeMillis"));
            poolConfig.setTestOnBorrow(config.getBoolean("redis.testOnBorrow"));
            log.debug("\u5f00\u59cb\u52a0\u8f7dredis\u4e3b\u673a\u5217\u8868");
            String hosts = config.getString("redis.host");
            String ports = config.getString("redis.port");
            String[] hostArr = hosts.split("@");
            String[] portArr = ports.split("@");
            jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, hostArr[0].trim(), Integer.parseInt(portArr[0].trim()));
        }
        return jedisPool;
    }
}

