/*
 * Decompiled with CFR 0.152.
 */
package com.biz.support.web.util;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasConfig {
    private static final Logger logger = LoggerFactory.getLogger(CasConfig.class);
    private static final String CONF_PATH = "connection/cas.properties";
    private static final String LOGIN_URL_KEY = "cas.login.url";
    private static final String LOGIN_CHECK_URL_KEY = "cas.login.check.url";
    private static final String LOGOUT_URL_KEY = "cas.logout.url";
    private static final String VALID_URL_KEY = "cas.ticket.valid.url";
    private static final String DOMAIN_KEY = "cas.ticket.cookie.domain";
    private static final String TICKET_GRANTING_KEY = "cas.ticket.granting.cookie.key";
    private static final String CAS_SERVERNAME_KEY = "cas.servername";
    private static final String VENDOR_SERVERNAME_KEY = "vendor.servername";
    private static final String UI_SERVERNAME_KEY = "ui.servername";
    private static final String CUSTOMER_SERVERNAME_KEY = "customer.servername";
    private static final String OSS_REMOTEENDPOINT_KEY = "oss.remoteEndpoint";
    private static final String OSS_BUCKETNAME = "oss.bucketName";
    private static final String RESOURCE_SERVERNAME_KEY = "resource.servername";
    private static Properties conf = new Properties();

    public static String getLoginUrl() {
        return conf.getProperty(LOGIN_URL_KEY);
    }

    public static String getLoginCheckUrl() {
        return conf.getProperty(LOGIN_CHECK_URL_KEY);
    }

    public static String getValidUrl() {
        return conf.getProperty(VALID_URL_KEY);
    }

    public static String getDomain() {
        return conf.getProperty(DOMAIN_KEY);
    }

    public static String getTicketGrantingKey() {
        return conf.getProperty(TICKET_GRANTING_KEY);
    }

    public static String getLogoutUrl() {
        return conf.getProperty(LOGOUT_URL_KEY);
    }

    public static String getCasServername() {
        return conf.getProperty(CAS_SERVERNAME_KEY);
    }

    public static String getVendorServername() {
        return conf.getProperty(VENDOR_SERVERNAME_KEY);
    }

    public static String getUiServername() {
        return conf.getProperty(UI_SERVERNAME_KEY);
    }

    public static String getResourceServername() {
        return conf.getProperty(RESOURCE_SERVERNAME_KEY);
    }

    public static String getCustomerServername() {
        return conf.getProperty(CUSTOMER_SERVERNAME_KEY);
    }

    public static String getOssRemoteEndpoint() {
        return conf.getProperty(OSS_REMOTEENDPOINT_KEY);
    }

    public static String getOssBucketName() {
        return conf.getProperty(OSS_BUCKETNAME);
    }

    static {
        try {
            conf.load(CasConfig.class.getClassLoader().getResourceAsStream(CONF_PATH));
        }
        catch (IOException e) {
            logger.error("\u52a0\u8f7dcas\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }
}

