/*
 * Decompiled with CFR 0.152.
 */
package com.bozhi.filter;

import com.bozhi.util.JMetricUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsFilter.class);
    private static final String COUNT_METER_NAME = "rest.count.meter";
    private static final String FILTER_PARAM_HOST_NAME = "hostname";
    private String restCountMeter;

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.info("Filter [{}] init...", (Object)MetricsFilter.class.getName());
        String hostName = filterConfig.getInitParameter(FILTER_PARAM_HOST_NAME);
        this.restCountMeter = String.format("%s.%s", hostName, COUNT_METER_NAME);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        JMetricUtil.meter(this.restCountMeter).mark();
    }

    public void destroy() {
        LOGGER.info("Filter [{}] destroyed...", (Object)MetricsFilter.class.getName());
        JMetricUtil.stopReporter();
    }
}

