/*
 * Decompiled with CFR 0.152.
 */
package com.bozhi.mbean;

import com.bozhi.mbean.MonitorTomcatMXBean;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorTomcatMXBeanMBean
implements MonitorTomcatMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorTomcatMXBeanMBean.class);
    private long upTime;
    private String status;

    public MonitorTomcatMXBeanMBean() {
        MBeanServer server = this.getServer();
        try {
            ObjectName name = new ObjectName("Application:Name=Server,Type=Server");
            server.registerMBean(this, name);
            LOGGER.info("Register mbean[{}] to MBean Server Success", (Object)this.getClass().getName());
        }
        catch (Exception e) {
            LOGGER.error("Register mbean[{}] to MBean Server Failed", (Object)this.getClass().getName(), (Object)e);
        }
        this.status = "1";
        this.upTime = System.currentTimeMillis();
    }

    public String getStatus() {
        return this.status;
    }

    public long getUpTime() {
        return System.currentTimeMillis() - this.upTime;
    }

    private MBeanServer getServer() {
        MBeanServer mBeanServer = null;
        ArrayList<MBeanServer> mbServers = MBeanServerFactory.findMBeanServer(null);
        if (CollectionUtils.isNotEmpty(mbServers)) {
            mBeanServer = mbServers.get(0);
        }
        if (mBeanServer != null) {
            LOGGER.info("Found our MBean Server");
        } else {
            LOGGER.info("Not fount our MBean Server");
            mBeanServer = MBeanServerFactory.createMBeanServer();
        }
        return mBeanServer;
    }
}

