/*
 * Decompiled with CFR 0.152.
 */
package com.bozhi.util;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMetricUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMetricUtil.class);
    private static JmxReporter jmxReporter;
    private static final MetricRegistry METRIC_REGISTRY;

    private static void init() {
        try {
            jmxReporter = JmxReporter.forRegistry((MetricRegistry)METRIC_REGISTRY).build();
            jmxReporter.start();
            LOGGER.info("Initialized {}.", (Object)JMetricUtil.class.getName());
        }
        catch (Exception e) {
            LOGGER.error("Initialized {} error", (Object)JMetricUtil.class.getName(), (Object)e);
        }
    }

    public static void stopReporter() {
        if (jmxReporter != null) {
            jmxReporter.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Meter meter(String name) {
        MetricRegistry metricRegistry = METRIC_REGISTRY;
        synchronized (metricRegistry) {
            return METRIC_REGISTRY.meter(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timer timer(String name) {
        MetricRegistry metricRegistry = METRIC_REGISTRY;
        synchronized (metricRegistry) {
            return METRIC_REGISTRY.timer(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counter counter(String name) {
        MetricRegistry metricRegistry = METRIC_REGISTRY;
        synchronized (metricRegistry) {
            return METRIC_REGISTRY.counter(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Histogram histogram(String name) {
        MetricRegistry metricRegistry = METRIC_REGISTRY;
        synchronized (metricRegistry) {
            return METRIC_REGISTRY.histogram(name);
        }
    }

    static {
        METRIC_REGISTRY = new MetricRegistry();
        JMetricUtil.init();
    }
}

