/*
 * Decompiled with CFR 0.152.
 */
package com.biz.utils;

import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

public class CommonUtil {
    public static boolean isBlank(String str) {
        return str == null || str.trim().equals("");
    }

    public static boolean notBlank(String str) {
        return !CommonUtil.isBlank(str);
    }

    public static String strJoinAsIn(String[] strArray) {
        if (strArray == null) {
            return null;
        }
        return CommonUtil.strJoinAsIn(strArray, 0, strArray.length);
    }

    public static String strJoinAsIn(String[] strArray, int begin, int end) {
        if (strArray == null) {
            return null;
        }
        String str = "";
        String td = "";
        int length = strArray.length;
        for (int i = begin; i < length && i < end; ++i) {
            if (!CommonUtil.notBlank(strArray[i])) continue;
            str = str + td + "'" + strArray[i] + "'";
            td = ",";
        }
        return str;
    }

    public static Long[] strsToLong(String[] strs) {
        if (strs == null || strs.length == 0) {
            return new Long[0];
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (String str : strs) {
            if (!CommonUtil.notBlank(str)) continue;
            list.add(Long.valueOf(str.trim()));
        }
        return list.toArray(new Long[list.size()]);
    }

    public static JSONObject transJSONObject(JSONObject o1) {
        if (o1 == null) {
            return null;
        }
        JSONObject o2 = new JSONObject();
        Set keys = o1.keySet();
        for (String key : keys) {
            o2.put(key.toLowerCase(), o1.get((Object)key));
        }
        return o2;
    }

    public static String getTimeOfDate(Date date) {
        String time = null;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = df.format(date).split(" ")[1];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }

    public static String StringTODate(String date) {
        String hour = date.substring(0, 2);
        String minuete = date.substring(2, 4);
        String dtime = hour + ":" + minuete;
        return dtime;
    }

    public static Date timestampToDate(Timestamp timestamp) throws ParseException {
        return new Date(timestamp.getTime());
    }
}

