/**
 * 2017 
 * 2017年5月4日  
 * 下午3:51:52
 * BudgetService.java
 * com.chinayanghe.msp.budget.rpc
 * budget-rpc
 */
package com.chinayanghe.msp.budget.rpc;

import java.util.List;

import com.chinayanghe.msp.budget.vo.activitytype.out.FirstclassActivityTypeOutVo;
import com.chinayanghe.msp.budget.vo.billcanusebranch.in.BillCanuseBranchChannelInVo;
import com.chinayanghe.msp.budget.vo.billcanusebranch.out.BillCanuseBranchChannelOutVo;
import com.chinayanghe.msp.budget.vo.brandcategory.in.BrandCategoryInVo;
import com.chinayanghe.msp.budget.vo.brandcategory.out.BrandCategoryOutVo;
import com.chinayanghe.msp.budget.vo.budgetchannel.in.BudgetChannelInVo;
import com.chinayanghe.msp.budget.vo.budgetchannel.out.BudgetChannelOutVo;
import com.chinayanghe.msp.budget.vo.budgetyear.in.BudgetYearInVo;
import com.chinayanghe.msp.budget.vo.budgetyear.out.BudgetYearOutVo;
import com.chinayanghe.msp.budget.vo.canusebilltype.in.CanuseBillTypeInVo;
import com.chinayanghe.msp.budget.vo.canusebilltype.out.CanuseBillTypeOutVo;
import com.chinayanghe.msp.budget.vo.checkbudget.in.MarketActiveTitleInVo;
import com.chinayanghe.msp.budget.vo.checkbudget.out.CheckBudgetOutVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * @author yangshuo
 *
 */
public interface BudgetRpcService {
	/**
	 * QYX_BUD_INTF_0006	取得表单可用列支渠道
	 * @param vo 
	 * @return 返回code 1000代表成功
	 */
	public BizResponseJson<List<BillCanuseBranchChannelOutVo>> findBillCanuseBranchChannel(BillCanuseBranchChannelInVo vo);

	/**
	 * QYX_BUD_INTF_0007	取得表单可用费用类型
	 * @param vo
	 * @return 返回code 1000代表成功
	 */
	public BizResponseJson<List<CanuseBillTypeOutVo>> findCanuseBillType(CanuseBillTypeInVo vo);
	/**
	 * QYX_BUD_INTF_0008	取得预算年度
	 * @param vo
	 * @return
	 */
	public BizResponseJson<List<BudgetYearOutVo>> findBudgetYear(BudgetYearInVo vo);
	
	/**
	 * QYX_BUD_INTF_0009	取得品牌大类
	 * @param vo
	 * @return 返回code 1000代表成功
	 */
	public BizResponseJson<List<BrandCategoryOutVo>> findBrandCategory(BrandCategoryInVo vo);

	
	/**
	 * QYX_BUD_INTF_0010	取得渠道
	 * @param vo
	 * @return 返回code 1000代表成功
	 */
	public BizResponseJson<List<BudgetChannelOutVo>> findBudgetChannel (BudgetChannelInVo vo);
	/**
	 * QYX_BUD_INTF_0001	申请检查或提交 - 检查预算和冻结预算
	 * @param vo
	 * @return 返回code 1000代表成功
	 */
	public BizResponseJson<List<CheckBudgetOutVo>> checkBudget(MarketActiveTitleInVo vo);


	/**
	 * 通过二级活动编码查询一级活动
	 * @param code 二级活动code
	 * @return
	 */
	public   FirstclassActivityTypeOutVo  findBySecondCode(String code);
}
