/**
 * 2017 
 * 2017年5月8日  
 * 上午9:33:03
 * BudgetYearInVo.java
 * com.chinayanghe.msp.budget.vo.budgetyear
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.budgetyear.in;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.chinayanghe.msp.budget.vo.budgetyear.code.BudgetYearCode;
import com.chinayanghe.msp.budget.vo.budgetyear.out.BudgetYearOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * 查询年度预算 输入参数
 * @author yangshuo
 *
 */
public class BudgetYearInVo extends BaseVo implements Serializable, BudgetYearCode {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 3003820076273753098L;

	/**
	 * 日期
	 */
	private Date date;
	/* (non-Javadoc)
	 * @see com.chinayanghe.msp.budget.vo.in.BaseVo#validate()
	 */
	@Override
	public BizResponseJson<List<BudgetYearOutVo>> validate() {
		if(date==null){
			return new BizResponseJson<List<BudgetYearOutVo>>(DATE_NULL, null, "<日期>为必须字段，不能为空");
		}
		return new BizResponseJson<List<BudgetYearOutVo>>();
	}
	public Date getDate() {
		return date;
	}
	public void setDate(Date date) {
		this.date = date;
	}
 

}
