/**
 * 2017 
 * 2017年5月17日  
 * 上午9:34:24
 * ApplyBudgetTitleInVo.java
 * com.chinayanghe.msp.budget.vo.applybudget.in
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.applybudget.in;

import java.math.BigDecimal;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.applybudget.code.ApplyBudgetCode;
import com.chinayanghe.msp.budget.vo.applybudget.out.ApplyBudgetOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * 市场活动表单抬头数据
 * @author yangshuo
 *
 */
public class ApplyBudgetDetailInVo extends BaseVo implements ApplyBudgetCode{
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 7778916143789306176L;
	/**
	 * 品牌大类 必填
	 */
	private String   brandCategory;
	/**
	 * 渠道 必填
	 */
	private String   channel;
	/**
	 * 费用类型 必填
	 */
	private String   costType;
	/**
	 * 审核金额 必填 金额必须大于0
	 */
	private BigDecimal   amount;
	@Override
	public BizResponseJson<List<ApplyBudgetOutVo>> validate() {
		if(StringUtils.isBlank(brandCategory)){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(BRANDCATEGORY_NULL, null, "<品牌大类>为必须字段，不能为空");
		} 
		if(StringUtils.isBlank(channel)){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(BUDGETCHANNEL_NULL, null, "<渠道>为必须字段，不能为空");
		} 
		if(StringUtils.isBlank(costType)){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(COSTTYPE_NULL, null, "<费用类型>为必须字段，不能为空");
		} 
		if(null==amount){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(AMOUNT_NULL, null, "<申请金额>为必须字段，不能为空");
		} 
		if( amount.compareTo(new BigDecimal(0))==-1){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(AMOUNT_LESS_ZERO,null,"申请金额不能为负数");	

		} 
		if(amount.compareTo(new BigDecimal(amount.longValue()))!=0){
			//校验失败
			return new BizResponseJson<List<ApplyBudgetOutVo>>(AMOUNT_HAVE_POINT,null,"申请金额不能为小数");	
		}
		 //验证成功
		return new BizResponseJson<List<ApplyBudgetOutVo>>();
	}
	public String getBrandCategory() {
		return brandCategory;
	}
	public void setBrandCategory(String brandCategory) {
		this.brandCategory = brandCategory;
	}
	public String getChannel() {
		return channel;
	}
	public void setChannel(String channel) {
		this.channel = channel;
	}
	public String getCostType() {
		return costType;
	}
	public void setCostType(String costType) {
		this.costType = costType;
	}
	public BigDecimal getAmount() {
		return amount;
	}
	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}
}
