/**
 * 2017 
 * 2017年5月19日  
 * 上午10:34:19
 * CancleApplyBudgetTitleInVo.java
 * com.chinayanghe.msp.budget.vo.cancleapplybudget.in
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.cancleapplybudget.in;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.applybudget.out.ApplyBudgetOutVo;
import com.chinayanghe.msp.budget.vo.cancleapplybudget.code.CancleApplyBudgeCode;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * 
 * @author yangshuo
 *
 */
public class CancleApplyBudgetInVo extends BaseVo implements CancleApplyBudgeCode{
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 7625752352107596189L;
	/**
	 * 市场活动申请单   必填
	 */
	private String marketActiveNo;
	
	/**
	 * 审批驳回日期 必填
	 */
	private Date date;	
	/**
	 * 用户 必填
	 */
	private String user;


	@Override
	public BizResponseJson<?> validate() {
		if(StringUtils.isBlank(marketActiveNo)){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(MARKETACTIVENO_NULL,null,"<市场活动申请单号>为必须字段，不能为空");
		}
 
		if(null == date){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(SUBMMITDATE_NULL,null,"<审批驳回日期>为必须字段，不能为空");
		}
 
		if(StringUtils.isBlank(user)){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(USER_NULL,null,"<用户>为必须字段，不能为空");
		}
		//验证成功
		return new BizResponseJson<Object>();
	}


	public String getMarketActiveNo() {
		return marketActiveNo;
	}


	public void setMarketActiveNo(String marketActiveNo) {
		this.marketActiveNo = marketActiveNo;
	}


	public Date getDate() {
		return date;
	}


	public void setDate(Date date) {
		this.date = date;
	}


	public String getUser() {
		return user;
	}


	public void setUser(String user) {
		this.user = user;
	}

}
