/**
 * 2017 
 * 2017年5月9日  
 * 上午9:25:42
 * CheckBudgetInVo.java
 * com.chinayanghe.msp.budget.vo.checkbudget.in
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.checkbudget.in;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.checkbudget.code.MarketActiveDetailCode;
import com.chinayanghe.msp.budget.vo.checkbudget.out.CheckBudgetOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 *  QYX_BUD_INTF_0001	申请检查或提交 - 检查预算和冻结预算
 *  市场活动表单明细数据
 * @author yangshuo
 *
 */
public class MarketActiveDetailInVo extends BaseVo implements MarketActiveDetailCode {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -4763827282274902010L;
	/**
	 * 品牌大类 必填
	 */
	private String   brandCategory;
	/**
	 * 渠道 必填
	 */
	private String   channel;
	/**
	 * 费用类型 必填
	 */
	private String   costType;
	/**
	 * 申请金额 必填 金额必须大于0
	 */
	private BigDecimal   amount;
 
	
 
	@Override
	public BizResponseJson<List<CheckBudgetOutVo>> validate() {
		if(StringUtils.isBlank(brandCategory)){
			return new BizResponseJson<List<CheckBudgetOutVo>>(BRANDCATEGORY_NULL, null, "<品牌大类>为必须字段，不能为空");
		} 
		if(StringUtils.isBlank(channel)){
			return new BizResponseJson<List<CheckBudgetOutVo>>(BUDGETCHANNEL_NULL, null, "<渠道>为必须字段，不能为空");
		} 
		if(StringUtils.isBlank(costType)){
			return new BizResponseJson<List<CheckBudgetOutVo>>(COSTTYPE_NULL, null, "<费用类型>为必须字段，不能为空");
		} 
		if(null==amount){
			return new BizResponseJson<List<CheckBudgetOutVo>>(AMOUNT_NULL, null, "<申请金额>为必须字段，不能为空");
		} 
		if( amount.compareTo(new BigDecimal(0))==-1){
			return new BizResponseJson<List<CheckBudgetOutVo>>(MarketActiveDetailCode.AMOUNT_LESS_ZERO,null,"申请金额不能为负数");	

		} 
		if(amount.compareTo(new BigDecimal(amount.longValue()))!=0){
			//校验失败
			return new BizResponseJson<List<CheckBudgetOutVo>>(MarketActiveDetailCode.AMOUNT_HAVE_POINT,null,"申请金额不能为小数");	
		}
		 //验证成功
		return new BizResponseJson<List<CheckBudgetOutVo>>();
	}


	public String getBrandCategory() {
		return brandCategory;
	}


	public void setBrandCategory(String brandCategory) {
		this.brandCategory = brandCategory;
	}


 


	public String getCostType() {
		return costType;
	}


	public void setCostType(String costType) {
		this.costType = costType;
	}


	public BigDecimal getAmount() {
		return amount;
	}


	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}

	public static void main(String[] args) {
		System.out.println(new java.text.DecimalFormat("#.0000").format(3.1415926));
		BigDecimal a = new BigDecimal(new BigInteger("100"),2);
		BigDecimal b = new BigDecimal(new BigInteger("3"),2);
		BigDecimal c = a.divide(b,0,RoundingMode.HALF_UP);
		System.out.println(c);
		System.out.println(new java.text.DecimalFormat("#.0000").format(3.1415926));
	}


	public String getChannel() {
		return channel;
	}


	public void setChannel(String channel) {
		this.channel = channel;
	}
}
