/**
 * 2017 
 * 2017年5月20日  
 * 下午3:46:39
 * CloseApplyBudgetInVo.java
 * com.chinayanghe.msp.budget.vo.closeapplybudget.in
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.closeapplybudget.in;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.applybudget.out.ApplyBudgetOutVo;
import com.chinayanghe.msp.budget.vo.closeapplybudget.code.CloseApplyBudgetCode;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * @author yangshuo
 *
 */
public class CloseApplyBudgetInVo extends BaseVo implements CloseApplyBudgetCode {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -3366987979950171793L;
	/**
	 * 市场活动申请单   必填
	 */
	private String marketActiveNo;
	
	/**
	 * 关闭日期 必填
	 */
	private Date date;	
	/**
	 * 用户 必填
	 */
	private String user;
	
	/**
	 * 关闭原因        1000 - 人工关闭
				1001 - 申请全部核报关闭
	 */
	private String closeReason;

	/* (non-Javadoc)
	 * @see com.chinayanghe.msp.budget.vo.in.BaseVo#validate()
	 */
	@Override
	public BizResponseJson<?> validate() {
		if(StringUtils.isBlank(marketActiveNo)){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(MARKETACTIVENO_NULL,null,"<市场活动申请单号>为必须字段，不能为空");
		}
 
		if(null == date){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(SUBMMITDATE_NULL,null,"<关闭日期>为必须字段，不能为空");
		}
 
		if(StringUtils.isBlank(user)){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(USER_NULL,null,"<用户>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(closeReason)){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(CLOSEREASON_NULL,null,"<关闭原因>为必须字段，不能为空");
		}		
		//验证成功
		return new BizResponseJson<Object>();
	}

	public String getMarketActiveNo() {
		return marketActiveNo;
	}

	public void setMarketActiveNo(String marketActiveNo) {
		this.marketActiveNo = marketActiveNo;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getCloseReason() {
		return closeReason;
	}

	public void setCloseReason(String closeReason) {
		this.closeReason = closeReason;
	}

}
