/**
 * 2017
 * 下午1:34:20
 * 2017年5月25日
 * budget-rpc
 * com.chinayanghe.msp.budget.vo.applybudgettransfer.in
 * ApplyBudgetTransferTitleInVo.java
 * ApplyBudgetTransferTitleInVo
 */
package com.chinayanghe.msp.budget.vo.applybudgettransfer.in;

import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.applybudgettransfer.code.ApplyBudgetTransferCode;
import com.chinayanghe.msp.budget.vo.applybudgettransfer.out.ApplyBudgetTransferOutVo;
import com.chinayanghe.msp.budget.vo.checkbudget.out.CheckBudgetOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * QYX_BUD_INTF_0011_预算转移申请-检查预算和冻结预算
 * 预算转移申请单抬头
 * @author yangshuo
 *
 */
public class ApplyBudgetTransferTitleInVo extends BaseVo implements ApplyBudgetTransferCode {

	/**
	 * 
	 */
	private static final long serialVersionUID = 7817974566131209870L;

	/**
	 * 执行方式  必填
	 */
	private String execType;
	/**
	 * 预算年度 必填
	 */
	private Short budgetYear;
	
	/**
	 * 市场活动申请单   必填
	 */
	private String transferApplyNo;

	/**
	 * 提交审批日期 必填
	 */
	private Date submmitDate;
	
	/**
	 * 用户 必填
	 */
	private String user;
	
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 市场活动表单明细
	 */
	List<ApplyBudgetTransferDetailInVo> detail;
	/* (non-Javadoc)
	 * @see com.chinayanghe.msp.budget.vo.in.BaseVo#validate()
	 */
	@Override
	public BizResponseJson<List<ApplyBudgetTransferOutVo>> validate() {
		if(StringUtils.isBlank(execType)){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(EXECTYPE_NULL,null,"<执行方式>为必须字段，不能为空");
		}
		if(!(execType.equals(EXEC_TYPE_CHECK)||execType.equals(EXEC_TYPE_LOCK))){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(EXECTYPE_NULL,null,"<执行方式>只能是1或2");
		}
		if(execType.equals(EXEC_TYPE_LOCK) && StringUtils.isBlank(transferApplyNo)){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(MARKETACTIVENO_NULL,null,"<市场活动申请单号>为必须字段，不能为空");
		}
		if(null == budgetYear){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(BUDGETYEAR_NULL,null,"<预算年度>为必须字段，不能为空");
		}
		if(null == submmitDate){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(SUBMMITDATE_NULL,null,"<提交审批日期>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(user)){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(USER_NULL,null,"<用户>为必须字段，不能为空");
		}
		if(CollectionUtils.isEmpty(detail)){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(MARKETACTIVITYDETAIL_NULL,null,"<市场活动表单明细数据>为必须，不能为空");
		}
		// TODO Auto-generated method stub
		return null;
	}
	public String getExecType() {
		return execType;
	}
	public void setExecType(String execType) {
		this.execType = execType;
	}
	public Short getBudgetYear() {
		return budgetYear;
	}
	public void setBudgetYear(Short budgetYear) {
		this.budgetYear = budgetYear;
	}
	public String getTransferApplyNo() {
		return transferApplyNo;
	}
	public void setTransferApplyNo(String transferApplyNo) {
		this.transferApplyNo = transferApplyNo;
	}
	public Date getSubmmitDate() {
		return submmitDate;
	}
	public void setSubmmitDate(Date submmitDate) {
		this.submmitDate = submmitDate;
	}
	public String getUser() {
		return user;
	}
	public void setUser(String user) {
		this.user = user;
	}
	public String getRemark() {
		return remark;
	}
	public void setRemark(String remark) {
		this.remark = remark;
	}
	public List<ApplyBudgetTransferDetailInVo> getDetail() {
		return detail;
	}
	public void setDetail(List<ApplyBudgetTransferDetailInVo> detail) {
		this.detail = detail;
	}

}
