/**
 * 2017 
 * 2017年5月4日  
 * 下午3:51:52
 * BudgetService.java
 * com.chinayanghe.msp.budget.rpc
 * budget-rpc
 */
package com.chinayanghe.msp.budget.rpc;

import java.util.List;

import com.chinayanghe.msp.budget.vo.activitytype.out.FirstclassActivityTypeOutVo;
import com.chinayanghe.msp.budget.vo.applybudget.in.ApplyBudgetTitleInVo;
import com.chinayanghe.msp.budget.vo.applybudget.out.ApplyBudgetOutVo;
import com.chinayanghe.msp.budget.vo.applybudgettransfer.in.ApplyBudgetTransferTitleInVo;
import com.chinayanghe.msp.budget.vo.applybudgettransfer.out.ApplyBudgetTransferOutVo;
import com.chinayanghe.msp.budget.vo.auditapplybudget.in.AuditApplyBudgetTitleInVo;
import com.chinayanghe.msp.budget.vo.auditapplybudget.out.AuditApplyBudgetOutVo;
import com.chinayanghe.msp.budget.vo.auditbudgettransfer.in.AuditBudgetTransferInVo;
import com.chinayanghe.msp.budget.vo.billcanusebranch.in.BillCanuseBranchChannelInVo;
import com.chinayanghe.msp.budget.vo.billcanusebranch.out.BillCanuseBranchChannelOutVo;
import com.chinayanghe.msp.budget.vo.brandcategory.in.BrandCategoryInVo;
import com.chinayanghe.msp.budget.vo.brandcategory.out.BrandCategoryOutVo;
import com.chinayanghe.msp.budget.vo.budgetchannel.in.BudgetChannelInVo;
import com.chinayanghe.msp.budget.vo.budgetchannel.out.BudgetChannelOutVo;
import com.chinayanghe.msp.budget.vo.budgetchanneltree.in.BudgetChannelTreeInVo;
import com.chinayanghe.msp.budget.vo.budgetchanneltree.out.BudgetChannelTreeOutVo;
import com.chinayanghe.msp.budget.vo.budgetproject.in.BudgetProjectInVo;
import com.chinayanghe.msp.budget.vo.budgetproject.out.BudgetProjectOutVo;
import com.chinayanghe.msp.budget.vo.budgetyear.in.BudgetYearInVo;
import com.chinayanghe.msp.budget.vo.budgetyear.out.BudgetYearOutVo;
import com.chinayanghe.msp.budget.vo.cancleapplybudget.in.CancleApplyBudgetInVo;
import com.chinayanghe.msp.budget.vo.canusebilltype.in.CanuseBillTypeInVo;
import com.chinayanghe.msp.budget.vo.canusebilltype.out.CanuseBillTypeOutVo;
import com.chinayanghe.msp.budget.vo.checkbudget.in.MarketActiveTitleInVo;
import com.chinayanghe.msp.budget.vo.checkbudget.out.CheckBudgetOutVo;
import com.chinayanghe.msp.budget.vo.classactivitytypetree.out.ClassActivityTypeTreeOutVo;
import com.chinayanghe.msp.budget.vo.closeapplybudget.in.CloseApplyBudgetInVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;
import com.chinayanghe.msp.budget.vo.rejectbudgettransfer.in.RejectBudgetTransferInVo;

/**
 * @author yangshuo
 *
 */
public interface BudgetRpcService {
	/**
	 * QYX_BUD_INTF_0006	取得表单可用列支渠道
	 * @param vo 
	 * @return 返回code 1000代表成功
	 */
	public BizResponseJson<List<BillCanuseBranchChannelOutVo>> findBillCanuseBranchChannel(BillCanuseBranchChannelInVo vo);

	/**
	 * QYX_BUD_INTF_0007	取得表单可用费用类型
	 * @param vo
	 * @return 返回code 1000代表成功
	 */
	public BizResponseJson<List<CanuseBillTypeOutVo>> findCanuseBillType(CanuseBillTypeInVo vo);
	/**
	 * QYX_BUD_INTF_0008	取得预算年度
	 * @param vo
	 * @return
	 */
	public BizResponseJson<List<BudgetYearOutVo>> findBudgetYear(BudgetYearInVo vo);
	
	/**
	 * QYX_BUD_INTF_0009	取得品牌大类
	 * @param vo
	 * @return 返回code 1000代表成功
	 */
	public BizResponseJson<List<BrandCategoryOutVo>> findBrandCategory(BrandCategoryInVo vo);

	
	/**
	 * QYX_BUD_INTF_0010	取得渠道
	 * @param vo
	 * @return 返回code 1000代表成功
	 */
	public BizResponseJson<List<BudgetChannelOutVo>> findBudgetChannel (BudgetChannelInVo vo);
	/**
	 * QYX_BUD_INTF_0001	申请检查或提交 - 检查预算和冻结预算
	 * @param vo
	 * @return 返回code 1000代表成功
	 */
	public BizResponseJson<List<CheckBudgetOutVo>> checkBudget(MarketActiveTitleInVo vo);
	/**
	 * QYX_BUD_INTF_0002_申请审批 - 更改预算预留单
	 * @param vo
	 * @return
	 */
	public BizResponseJson<List<ApplyBudgetOutVo>> applyBudget(ApplyBudgetTitleInVo vo);
	
	/**
	 * QYX_BUD_INTF_0003_申请驳回 - 作废预算预留单 
	 * 申请审批驳回
	 * @param vo
	 * @return
	 */
	public BizResponseJson<Object> cancleApplyBudget(CancleApplyBudgetInVo vo);


	/**
	 * 通过二级活动编码查询一级活动
	 * @param code 二级活动code
	 * @return
	 */
	public   FirstclassActivityTypeOutVo  findBySecondCode(String code);
	
	/**
	 * 通过日期查询查询可用渠道树形结构
	 * @param vo
	 * @return
	 */
	public BizResponseJson<List<BudgetChannelTreeOutVo>> findBudgetChannelTree (BudgetChannelTreeInVo vo);
 
	/**
	 * 查询所有活动的树形结构
	 * @return
	 */
	public BizResponseJson<List<ClassActivityTypeTreeOutVo>> findClassActivityTypeTree ();

	/**
	 * QYX_BUD_INTF_0004_申请关闭 - 关闭预算预留单 
	 * @param vo
	 * @return
	 */
	public BizResponseJson<Object> closeApplyBudget(CloseApplyBudgetInVo vo);
	
	/**
	 * QYX_BUD_INTF_0005_核报审批 - 使用预算 
	 * @param vo
	 * @return
	 */
	public BizResponseJson<List<AuditApplyBudgetOutVo>> auditApplyBudget(AuditApplyBudgetTitleInVo vo);
	/**
	 * QYX_BUD_INTF_0013_预算转移申请-审批通过 
	 * @param vo
	 * @return
	 */
	public BizResponseJson<List<Object>> auditApplyBudgetTransfer(AuditBudgetTransferInVo vo);
	/**
	 * QYX_BUD_INTF_0014_预算转移申请-审批驳回
	 * @param vo
	 * @return
	 */
	public BizResponseJson<List<Object>> auditRejectBudgetTransfer(RejectBudgetTransferInVo vo);

	/**
	 * QYX_BUD_INTF_0011_预算转移申请-检查预算和冻结预算
	 * @param vo
	 * @return
	 */
	public BizResponseJson<List<ApplyBudgetTransferOutVo>> applyBudgetTransfer(ApplyBudgetTransferTitleInVo vo);
	/**
	 * QYX_BUD_INTF_0016	根据组织和经销商获取该组织下的预算维度信息
	 * @param vo
	 * @return
	 */
	public BizResponseJson<List<BudgetProjectOutVo>>  findBudgetProject(BudgetProjectInVo vo);
}
