/**
 * 2017
 * 下午1:33:08
 * 2017年5月25日
 * budget-rpc
 * com.chinayanghe.msp.budget.vo.applybudgettransfer.code
 * ApplyBudgetTransferCode.java
 * ApplyBudgetTransferCode
 */
package com.chinayanghe.msp.budget.vo.applybudgettransfer.code;

import java.io.Serializable;

/**
 * QYX_BUD_INTF_0011_预算转移申请-检查预算和冻结预算 状态码
 * @author yangshuo
 *
 */
public interface ApplyBudgetTransferCode extends Serializable {
	/**
	 * 执行方式为检查
	 */
	public final static String EXEC_TYPE_CHECK="1";
	/**
	 * 执行方式为冻结
	 */
	public final static String EXEC_TYPE_LOCK="2";
	
	/**
	 * 转入/转出标识  1-转出，2-转入
	 */
	public final static String MOVE_TYPE_OUT="1";
	/**
	 * 转入/转出标识  1-转出，2-转入
	 */
	public final static String MOVE_TYPE_IN="2";
	/*******************以下是错误返回状态***************/
	/**
	 * 执行方式参数为空
	 */
	public final static int EXECTYPE_NULL=1100;
	/**
	 * 市场活动申请单号参数为空
	 */
	public final static int MARKETACTIVENO_NULL=1101;
	/**
	 * 预算年度参数为空
	 */
	public final static int BUDGETYEAR_NULL=1102;
	/**
	 * 提交审批日期参数为空
	 */
	public final static int SUBMMITDATE_NULL=1103;
	/**
	 * 用户参数不能为空
	 */
	public final static int USER_NULL=1105;
	/**
	 * 市场活动单明细不能为空
	 */
	public final static int MARKETACTIVITYDETAIL_NULL=1106;
	
	
	/**
	 * 转入转出方式不能为空 只能为1或者2
	 */
	public final static int MOVETYPE_NULL =1107;
	/**
	 * 预算地址不能为空
	 */
	public final static int BUDGETADDRESSCODE_NULL =1108;
	/**
	 * <转移金额 >不能为0或负数
	 */
	public final static int TRANSFERMONEY_NULL =1109;
	
	
	/**
	 * 必须没有转出（转入转出标识为1）的行，否则返回消息：没有转出的预算项目
	 */
	public final static int OUTITEM_NULL =1110;
	/**
	 * 如果转出（转入转出标识为1）的有多行，返回消息：只能有一个转出的预算项目
	 */
	public final static int OUTITEM_MORE_THAN_ONE =1111;
	/**
	 * 如果传入明细的预算地址ID有重复，则返回消息：预算地址ID有重复，不允许
	 */
	public final static int ADDRESS_DUPLE =1112;
	
	/**
	 * 必须有转入（转入转出标识为2）的行，返回消息：没有转入的预算项目
	 */
	public final static int INITEM_NULL =1113;
	
	/**
	 * 转出汇总金额不等于转入汇总金额
	 */
	public final static int MONEY_NOT_EQ =1114;
	
	
	/***************数据库校验********************/
	
	/**
	 * 预算年度不存在
	 */
	public final static int BUDGET_YEAR_NOTEXITS =1120;
	/**
	 * 预算年度<预算年度>在提交审批日期<提交审批日期>不可用
	 */
	public final static int BUDGET_YEAR_NOT_CANUSE =1121;
	/**
	 * 预算年度<预算年度>在当前系统日期<当前日期>不可用
	 */
	public final static int BUDGET_YEAR_CURRENT_NOT_CANUSE =1122;
	/**
	 * 该申请单已经有对应的预算预留单<单号>
	 */
	public final static int BUDGET_BILL_HEAD_EXITS =1123;
	
	/**
	 * 预算项目不存在
	 */
	public final static int BUDGET_PROJECT_NOT_EXITS =1124;
	
	/**
	 * 预算项目在当前日期不可用，详见详细信息
	 */
	public final static int BUDGET_PROJECT_NOT_CANUSE =1125;
	/**
	 * 预算地址的预算年度和API传入的预算年度不同，详见详细消息
	 */
	public final static int BUDGET_YEAR_NOT_EQ =1126;
	
	/**
	 * 预算项目可用金额不足
	 */
	public final static int CAN_USE_MONEY_NOT_ENOUGH =1127;
}
