/**
 * 2017
 * 下午1:35:01
 * 2017年5月25日
 * budget-rpc
 * com.chinayanghe.msp.budget.vo.applybudgettransfer.in
 * ApplyBudgetTransferDetailInVo.java
 * ApplyBudgetTransferDetailInVo
 */
package com.chinayanghe.msp.budget.vo.applybudgettransfer.in;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.applybudgettransfer.code.ApplyBudgetTransferCode;
import com.chinayanghe.msp.budget.vo.applybudgettransfer.out.ApplyBudgetTransferOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * 市场活动表单明细
 * @author yangshuo
 *
 */
public class ApplyBudgetTransferDetailInVo extends BaseVo implements ApplyBudgetTransferCode {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3640288032494654578L;
	
	/**
	 * 转出转入标志  1-转出，2-转入
	 */
	private String moveType;
	/**
	 * 预算地址
	 */
	private String budgetAddressCode;
	
	/**
	 * 转移金额  正数
	 */
	private BigDecimal transferMoney;

	/* (non-Javadoc)
	 * @see com.chinayanghe.msp.budget.vo.in.BaseVo#validate()
	 */
	@Override
	public BizResponseJson<List<ApplyBudgetTransferOutVo>> validate() {
		if(StringUtils.isBlank(moveType)){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(MOVETYPE_NULL,null,"<转出转入标志>为必须字段，不能为空");
		}
		if(!(moveType.equals(MOVE_TYPE_OUT)&&moveType.equals(MOVE_TYPE_IN))){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(MOVETYPE_NULL,null,"<转出转入标志>只能是1或2");
		}
		if(StringUtils.isBlank(budgetAddressCode)){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(BUDGETADDRESSCODE_NULL,null,"<预算地址>为必须字段，不能为空");
		}
		if(null == transferMoney || transferMoney.compareTo(BigDecimal.ZERO)<=0){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(TRANSFERMONEY_NULL,null,"<转移金额 >不能为0或负数");
		}
		return new BizResponseJson<List<ApplyBudgetTransferOutVo>>();
	}

	public String getMoveType() {
		return moveType;
	}

	public void setMoveType(String moveType) {
		this.moveType = moveType;
	}

	public String getBudgetAddressCode() {
		return budgetAddressCode;
	}

	public void setBudgetAddressCode(String budgetAddressCode) {
		this.budgetAddressCode = budgetAddressCode;
	}

	public BigDecimal getTransferMoney() {
		return transferMoney;
	}

	public void setTransferMoney(BigDecimal transferMoney) {
		this.transferMoney = transferMoney;
	}

	 

}
