/**
 * 2017
 * 下午3:24:14
 * 2017年6月16日
 * budget-rpc
 * com.chinayanghe.msp.budget.vo.budgetcosttype.in
 * BudgetCostTypeInVo.java
 * BudgetCostTypeInVo
 */
package com.chinayanghe.msp.budget.vo.budgetcosttype.in;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.budgetcosttype.code.BudgetCostTypeCode;
import com.chinayanghe.msp.budget.vo.budgetcosttype.out.BudgetCostTypeOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * @author yangshuo
 *
 */
public class BudgetCostTypeInVo extends BaseVo implements BudgetCostTypeCode {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1483544370347944716L;
	
	/**
	 * 转入组织类型 必填
	 */
	private String orgTypeIn;
	
	/**
	 * 转入经销商编号
	 */
	private String franchiserCodeIn;
	
	/**
	 * 转出组织类型 必填
	 */
	private String orgTypeOut;
	
	/**
	 * 转出经销商编号
	 */
	private String franchiserCodeOut;
	
	/**
	 * 转出预算费用类型 必填
	 */
	private String budgetCostTypeOut;
	/* (non-Javadoc)
	 * @see com.chinayanghe.msp.budget.vo.in.BaseVo#validate()
	 */
	@Override
	public BizResponseJson<List<BudgetCostTypeOutVo>> validate() {
		if(StringUtils.isBlank(orgTypeIn)){
			return new BizResponseJson<List<BudgetCostTypeOutVo>>(ORGTYPEIN_NULL, null, "<转入组织类型>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(orgTypeOut)){
			return new BizResponseJson<List<BudgetCostTypeOutVo>>(ORGTYPEOUT_NULL, null, "<转出组织类型>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(budgetCostTypeOut)){
			return new BizResponseJson<List<BudgetCostTypeOutVo>>(BUDGETCOSTTYPEOUT_NULL, null, "<转出预算费用类型>为必须字段，不能为空");
			
		}
		return new BizResponseJson<List<BudgetCostTypeOutVo>>();
	}
	public String getOrgTypeIn() {
		return orgTypeIn;
	}
	public void setOrgTypeIn(String orgTypeIn) {
		this.orgTypeIn = orgTypeIn;
	}
	public String getFranchiserCodeIn() {
		return franchiserCodeIn;
	}
	public void setFranchiserCodeIn(String franchiserCodeIn) {
		this.franchiserCodeIn = franchiserCodeIn;
	}
	public String getOrgTypeOut() {
		return orgTypeOut;
	}
	public void setOrgTypeOut(String orgTypeOut) {
		this.orgTypeOut = orgTypeOut;
	}
	public String getFranchiserCodeOut() {
		return franchiserCodeOut;
	}
	public void setFranchiserCodeOut(String franchiserCodeOut) {
		this.franchiserCodeOut = franchiserCodeOut;
	}
	public String getBudgetCostTypeOut() {
		return budgetCostTypeOut;
	}
	public void setBudgetCostTypeOut(String budgetCostTypeOut) {
		this.budgetCostTypeOut = budgetCostTypeOut;
	}

}
