/**
 * 2017
 * 2017年5月22日
 * 下午2:28:39
 * budget-rpc
 * com.chinayanghe.msp.budget.vo.front.changplay.in
 * ChangePlanMoneyInVo.java
 */
package com.chinayanghe.msp.budget.vo.front.changplan.in;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Set;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * @author yangshuo
 *
 */
public class ChangePlanMoneyInVo extends BaseVo implements Serializable {
	
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 104064596126928764L;

	/**
	 * 计划变动金额map: key:预算地址code, value:变动金额 有正有负  正数为增加  负数为减少
	 */
	HashMap<String, BigDecimal> changeMap;
	
	/**
	 * 操作人员name
	 */
	private String userName;
	/**
	 * 操作人员id
	 */
	private String userId;
	 
	public HashMap<String, BigDecimal> getChangeMap() {
		return changeMap;
	}
	public void setChangeMap(HashMap<String, BigDecimal> changeMap) {
		this.changeMap = changeMap;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}

	@Override
	public BizResponseJson<Object> validate() {
		if(MapUtils.isEmpty(changeMap)){
			return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "项目调整参数不能为空");
		}
		Set<String> set = changeMap.keySet();
		for(String key :set){
			if(StringUtils.isBlank(key)){
				return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "项目调整参数不能为空");
			}
			if(null == changeMap.get(key)){
				return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "项目调整参数不能为空");
			}
		}
		if(StringUtils.isBlank(userId) && StringUtils.isBlank(userName)){
			return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "操作人员信息不能全为空");
		}
		return new BizResponseJson<Object>();
	}

}
