package com.chinayanghe.msp.budget.vo.transfercontrol.in;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;
import com.chinayanghe.msp.budget.vo.transfercontrol.code.TransferControlCode;
import com.chinayanghe.msp.budget.vo.transfercontrol.out.TransferControlOutVo;

/**
 * 预算转移控制规则  输入值
 */
public class TransferControlInVo  extends BaseVo implements TransferControlCode {

    /**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 8576801263631660909L;
	/**
     * 转入组织类型 必填
     */
    private String orgTypeIn;
    /**
     * 转出组织类型 必填
     */
    private String orgTypeOut;

    /**
     * 转入经销商编号
     */
    private String franchiserCodeIn;
    /**
     * 转出经销商编号
     */
    private String franchiserCodeOut;

    /**
     * 转出预算费用类型 必填
     */
    private String budgetCostTypeOut;


    /**
     * 预算年度 必填
     */
    private Short budgetYear;
    /**
     * 转入组织编码 必填
     */
    private String organizationCode;
    
    /**
     * 组织类型 例如：FGSLB001这种格式
     */
    private String organizationType;
    /**
     * 基本的验证输入VO的方法
     *
     * @return
     */
	/* (non-Javadoc)
	 * @see com.chinayanghe.msp.budget.vo.in.BaseVo#validate()
	 */
    @Override
    public BizResponseJson<List<TransferControlOutVo>> validate() {
        if(StringUtils.isBlank(orgTypeIn)){
            return new BizResponseJson<List<TransferControlOutVo>>(ORGTYPEIN_NULL, null, "<转入组织类型>为必须字段，不能为空");
        }
        if(StringUtils.isBlank(orgTypeOut)){
            return new BizResponseJson<List<TransferControlOutVo>>(ORGTYPEOUT_NULL, null, "<转出组织类型>为必须字段，不能为空");
        }
        if(StringUtils.isBlank(budgetCostTypeOut)){
            return new BizResponseJson<List<TransferControlOutVo>>(BUDGETCOSTTYPEOUT_NULL, null, "<转出预算费用类型>为必须字段，不能为空");

        }
        if(null == budgetYear){
            return new BizResponseJson<List<TransferControlOutVo>>(BUDGET_YEAR_NULL, null, "<预算年度>为必须字段，不能为空");
        }
        if(StringUtils.isBlank(organizationCode)){
            return new BizResponseJson<List<TransferControlOutVo>>(BUDGET_ORGANIZATION_CODE_NULL, null, "<组织编码>为必须字段，不能为空");
        }
        return new BizResponseJson<List<TransferControlOutVo>>();
    }

    public String getOrgTypeIn() {
        return orgTypeIn;
    }

    public void setOrgTypeIn(String orgTypeIn) {
        this.orgTypeIn = orgTypeIn;
    }

    public String getOrgTypeOut() {
        return orgTypeOut;
    }

    public void setOrgTypeOut(String orgTypeOut) {
        this.orgTypeOut = orgTypeOut;
    }

    public String getFranchiserCodeIn() {
        return franchiserCodeIn;
    }

    public void setFranchiserCodeIn(String franchiserCodeIn) {
        this.franchiserCodeIn = franchiserCodeIn;
    }

    public String getFranchiserCodeOut() {
        return franchiserCodeOut;
    }

    public void setFranchiserCodeOut(String franchiserCodeOut) {
        this.franchiserCodeOut = franchiserCodeOut;
    }

    public String getBudgetCostTypeOut() {
        return budgetCostTypeOut;
    }

    public void setBudgetCostTypeOut(String budgetCostTypeOut) {
        this.budgetCostTypeOut = budgetCostTypeOut;
    }

    public Short getBudgetYear() {
        return budgetYear;
    }

    public void setBudgetYear(Short budgetYear) {
        this.budgetYear = budgetYear;
    }

    public String getOrganizationCode() {
        return organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

	public String getOrganizationType() {
		return organizationType;
	}

	public void setOrganizationType(String organizationType) {
		this.organizationType = organizationType;
	}
}
