/**
 * 2017 
 * 2017年5月4日  
 * 下午4:05:20
 * CanuseBillTypeVo.java
 * com.chinayanghe.msp.budget.vo.in
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.canusebilltype.in;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.canusebilltype.code.CanUseBillTypeCode;
import com.chinayanghe.msp.budget.vo.canusebilltype.out.CanuseBillTypeOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * @author yangshuo
 * 取得表单可用费用类型  Vo   in
 *
 */
public class CanuseBillTypeInVo  extends BaseVo    implements CanUseBillTypeCode,Serializable {



	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -8879792614570030659L;
    /**
     * 二级活动类型
     */
    private String secondActiveTypeCode;
	/**
     * 活动日期 年月日
     */
    private Date canuseDate;
    
 
    public String getSecondActiveTypeCode() {
		return secondActiveTypeCode;
	}

	public void setSecondActiveTypeCode(String secondActiveTypeCode) {
		this.secondActiveTypeCode = secondActiveTypeCode;
	}

 


	public Date getCanuseDate() {
		return canuseDate;
	}

	public void setCanuseDate(Date canuseDate) {
		this.canuseDate = canuseDate;
	}



 
	@Override
	public BizResponseJson<List<CanuseBillTypeOutVo>> validate() {
		if(StringUtils.isBlank(secondActiveTypeCode)){
			return new BizResponseJson<List<CanuseBillTypeOutVo>>(SECONDACTIVETYPECODE_NULL, null, "<二级活动类型>为必须字段，不能为空");
		}
		if(null==canuseDate){
			return new BizResponseJson<List<CanuseBillTypeOutVo>>(CANUSEDATE_NULL, null, "<日期>为必须字段，不能为空");
		}
		return new BizResponseJson<List<CanuseBillTypeOutVo>>();
	}

}
