/**
 * 2017 
 * 2017年5月9日  
 * 上午9:25:10
 * CheckBudgetCode.java
 * com.chinayanghe.msp.budget.vo.checkbudget.code
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.checkbudget.code;

import java.io.Serializable;

/**
 *  QYX_BUD_INTF_0001	申请检查或提交 - 检查预算和冻结预算
 * 返回状态码
 * @author yangshuo
 *
 */
public interface MarketActiveDetailCode extends Serializable {

	/**
	 * 品牌大类参数为空
	 */
	public final static int BRANDCATEGORY_NULL=1130;
	
	/**
	 * 渠道参数为空
	 */
	public final static int BUDGETCHANNEL_NULL=1131;
	/**
	 * 费用类型参数为空
	 */
	public final static int COSTTYPE_NULL=1132;
	/**
	 * 申请金额参数为空
	 */
	public final static int AMOUNT_NULL=1133;
	/******************以下检查字段内容******************/
	/**
	 * 品牌大类不存在，详见返回详细消息
	 */
	public final static int BRANDCATEGORY_NOT_EXIT=1180;
	/**
	 * 渠道不存在，详见返回详细消息
	 */
	public final static int BUDGETCHANNEL_NOT_EXIT=1181;
	/**
	 * 费用类型不存在，详见返回详细消息
	 */
	public final static int COSTTYPE_NOT_EXIT=1182;
	/**
	 * 申请金额不能为负数，详见返回详细消息
	 */
	public final static int AMOUNT_LESS_ZERO=1183;
	/**
	 * 申请金额不能为小数，详见返回详细消息
	 */
	public final static int AMOUNT_HAVE_POINT=1184;
	
}
