/**
 * 2017
 * 2017年5月4日
 * 下午3:51:52
 * BudgetService.java
 * com.chinayanghe.msp.budget.rpc
 * budget-rpc
 */
package com.chinayanghe.msp.budget.rpc;

import com.chinayanghe.msp.budget.vo.activitytype.out.FirstclassActivityTypeOutVo;
import com.chinayanghe.msp.budget.vo.activitytype.out.SecondclassActivityTypeOutVo;
import com.chinayanghe.msp.budget.vo.applybudget.in.ApplyBudgetTitleInVo;
import com.chinayanghe.msp.budget.vo.applybudget.out.ApplyBudgetOutVo;
import com.chinayanghe.msp.budget.vo.applybudgettransfer.in.ApplyBudgetTransferTitleInVo;
import com.chinayanghe.msp.budget.vo.applybudgettransfer.out.ApplyBudgetTransferOutVo;
import com.chinayanghe.msp.budget.vo.auditapplybudget.in.AuditApplyBudgetTitleInVo;
import com.chinayanghe.msp.budget.vo.auditapplybudget.out.AuditApplyBudgetOutVo;
import com.chinayanghe.msp.budget.vo.auditbudgettransfer.in.AuditBudgetTransferInVo;
import com.chinayanghe.msp.budget.vo.auditbudgettransfer.out.AuditBudgetTransferOutVo;
import com.chinayanghe.msp.budget.vo.billcanusebranch.in.BillCanuseBranchChannelInVo;
import com.chinayanghe.msp.budget.vo.billcanusebranch.out.BillCanuseBranchChannelOutVo;
import com.chinayanghe.msp.budget.vo.brandcategory.in.BrandCategoryInVo;
import com.chinayanghe.msp.budget.vo.brandcategory.out.BrandCategoryOutVo;
import com.chinayanghe.msp.budget.vo.budegettransferobjectcontrol.in.BudegetTransferObjectControlInVo;
import com.chinayanghe.msp.budget.vo.budegettransferobjectcontrol.out.BudegetTransferObjectControlOutVo;
import com.chinayanghe.msp.budget.vo.budgetchannel.in.BudgetChannelInVo;
import com.chinayanghe.msp.budget.vo.budgetchannel.out.BudgetChannelOutVo;
import com.chinayanghe.msp.budget.vo.budgetchanneltree.in.BudgetChannelTreeInVo;
import com.chinayanghe.msp.budget.vo.budgetchanneltree.out.BudgetChannelTreeOutVo;
import com.chinayanghe.msp.budget.vo.budgetcosttype.in.BudgetCostTypeInVo;
import com.chinayanghe.msp.budget.vo.budgetcosttype.out.BudgetCostTypeOutVo;
import com.chinayanghe.msp.budget.vo.budgetproject.in.BudgetProjectInVo;
import com.chinayanghe.msp.budget.vo.budgetproject.out.BudgetProjectOutVo;
import com.chinayanghe.msp.budget.vo.budgettype.out.BudgetTypeOutVo;
import com.chinayanghe.msp.budget.vo.budgetyear.in.BudgetYearInVo;
import com.chinayanghe.msp.budget.vo.budgetyear.out.BudgetYearOutVo;
import com.chinayanghe.msp.budget.vo.cancleapplybudget.in.CancleApplyBudgetInVo;
import com.chinayanghe.msp.budget.vo.canusebilltype.in.CanuseBillTypeInVo;
import com.chinayanghe.msp.budget.vo.canusebilltype.out.CanuseBillTypeOutVo;
import com.chinayanghe.msp.budget.vo.checkbudget.in.MarketActiveTitleInVo;
import com.chinayanghe.msp.budget.vo.checkbudget.out.CheckBudgetOutVo;
import com.chinayanghe.msp.budget.vo.classactivitytypetree.out.ClassActivityTypeTreeOutVo;
import com.chinayanghe.msp.budget.vo.closeapplybudget.in.CloseApplyBudgetInVo;
import com.chinayanghe.msp.budget.vo.costtype.out.CostTypeOutVo;
import com.chinayanghe.msp.budget.vo.dealerTransfer.ProjectVo;
import com.chinayanghe.msp.budget.vo.human.HumanProcessVoIn;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;
import com.chinayanghe.msp.budget.vo.rejectbudgettransfer.in.RejectBudgetTransferInVo;
import com.chinayanghe.msp.budget.vo.transfercontrol.in.TransferControlInVo;
import com.chinayanghe.msp.budget.vo.transfercontrol.out.TransferControlOutVo;

import java.util.List;

/**
 * @author yangshuo
 */
public interface BudgetRpcService {
    /**
     * QYX_BUD_INTF_0006	取得表单可用列支渠道
     *
     * @param vo
     * @return 返回code 1000代表成功
     */
    public BizResponseJson<List<BillCanuseBranchChannelOutVo>> findBillCanuseBranchChannel(BillCanuseBranchChannelInVo vo);

    /**
     * QYX_BUD_INTF_0007	取得表单可用费用类型
     *
     * @param vo
     * @return 返回code 1000代表成功
     */
    public BizResponseJson<List<CanuseBillTypeOutVo>> findCanuseBillType(CanuseBillTypeInVo vo);

    /**
     * QYX_BUD_INTF_0008	取得预算年度
     *
     * @param vo
     * @return
     */
    public BizResponseJson<List<BudgetYearOutVo>> findBudgetYear(BudgetYearInVo vo);

    /**
     * QYX_BUD_INTF_0009	取得品牌大类
     *
     * @param vo
     * @return 返回code 1000代表成功
     */
    public BizResponseJson<List<BrandCategoryOutVo>> findBrandCategory(BrandCategoryInVo vo);


    /**
     * QYX_BUD_INTF_0010	取得渠道
     *
     * @param vo
     * @return 返回code 1000代表成功
     */
    public BizResponseJson<List<BudgetChannelOutVo>> findBudgetChannel(BudgetChannelInVo vo);

    /**
     * QYX_BUD_INTF_0001	申请检查或提交 - 检查预算和冻结预算
     *
     * @param vo
     * @return 返回code 1000代表成功
     */
    public BizResponseJson<List<CheckBudgetOutVo>> checkBudget(MarketActiveTitleInVo vo);


    /**
     * 临时新增接口 原有项目驳回（预算预留单作废）并冻结新的预算项目
     *
     * @param vo
     * @return
     */
    public BizResponseJson<List<CheckBudgetOutVo>> cancleAndCheckApplyBudget(MarketActiveTitleInVo vo);

    /**
     * QYX_BUD_INTF_0002_申请审批 - 更改预算预留单
     *
     * @param vo
     * @return
     */
    public BizResponseJson<List<ApplyBudgetOutVo>> applyBudget(ApplyBudgetTitleInVo vo);

    /**
     * QYX_BUD_INTF_0003_申请驳回 - 作废预算预留单
     * 申请审批驳回
     *
     * @param vo
     * @return
     */
    public BizResponseJson<Object> cancleApplyBudget(CancleApplyBudgetInVo vo);


    /**
     * 通过二级活动编码查询一级活动
     *
     * @param code 二级活动code
     * @return
     */
    public FirstclassActivityTypeOutVo findBySecondCode(String code);

    /**
     * 通过二级活动编码查询二级活动
     *
     * @param code 二级活动code
     * @return
     */
    public SecondclassActivityTypeOutVo findSecondActivityBySecondCode(String code);

    /**
     * 通过日期查询查询可用渠道树形结构
     *
     * @param vo
     * @return
     */
    public BizResponseJson<List<BudgetChannelTreeOutVo>> findBudgetChannelTree(BudgetChannelTreeInVo vo);

    /**
     * 查询所有活动的树形结构
     *
     * @return
     */
    public BizResponseJson<List<ClassActivityTypeTreeOutVo>> findClassActivityTypeTree();

    /**
     * QYX_BUD_INTF_0004_申请关闭 - 关闭预算预留单
     *
     * @param vo
     * @return
     */
    public BizResponseJson<Object> closeApplyBudget(CloseApplyBudgetInVo vo);

    /**
     * QYX_BUD_INTF_0005_核报审批 - 使用预算
     *
     * @param vo
     * @return
     */
    public BizResponseJson<List<AuditApplyBudgetOutVo>> auditApplyBudget(AuditApplyBudgetTitleInVo vo);


    /**
     * 临时新增接口 核报并关闭
     *
     * @param vo
     * @return
     */
    public BizResponseJson<List<AuditApplyBudgetOutVo>> auditCloseApplyBudget(AuditApplyBudgetTitleInVo vo);

    /**
     * QYX_BUD_INTF_0013_预算转移申请-审批通过
     *
     * @param vo
     * @return
     */
    public BizResponseJson<List<AuditBudgetTransferOutVo>> auditApplyBudgetTransfer(AuditBudgetTransferInVo vo);

    /**
     * QYX_BUD_INTF_0014_预算转移申请-审批驳回
     *
     * @param vo
     * @return
     */
    public BizResponseJson<List<Object>> cancleBudgetTransfer(RejectBudgetTransferInVo vo);

    /**
     * QYX_BUD_INTF_0011_预算转移申请-检查预算和冻结预算
     *
     * @param vo
     * @return
     */
    public BizResponseJson<List<ApplyBudgetTransferOutVo>> applyBudgetTransfer(ApplyBudgetTransferTitleInVo vo);

    /**
     * QYX_BUD_INTF_0016	根据组织和经销商获取该组织下的预算维度信息
     *
     * @param vo
     * @return
     */
    public BizResponseJson<List<BudgetProjectOutVo>> findBudgetProject(BudgetProjectInVo vo);


    /**
     * QYX_BUD_INTF_0018_取得预算类型
     *
     * @return
     */
    public BizResponseJson<List<BudgetTypeOutVo>> findBudgetType();

    /**
     * 预算转移规则
     *
     * @param vo
     * @return
     */
    public BizResponseJson<List<TransferControlOutVo>> findBudegetTransferControl(TransferControlInVo vo);

    /**
     * 方法作废掉了
     * QYX_BUD_INTF_0015_预算转移规则
     *
     * @return
     */
    @Deprecated
    public BizResponseJson<List<BudgetCostTypeOutVo>> findBudgetCostType(BudgetCostTypeInVo vo);

    /**
     * 方法作废掉了
     * 预算转移 是否可以转经销商或者分公司
     *
     * @param vo 转出组织 转出经销商
     * @return
     */
    @Deprecated
    public BizResponseJson<List<BudegetTransferObjectControlOutVo>> findBudegetTransferCosttypeControl(BudegetTransferObjectControlInVo vo);

    /**
     * 通过参数模糊查询
     *
     * @param costTypeCode 费用类型
     * @param costTypeName 费用名字
     * @return
     */
    public List<CostTypeOutVo> findCostTypeByLike(String costTypeCode, String costTypeName);

    /**
     * 通过费用类型code查询费用类型
     *
     * @param costTypeCode 费用类型code
     * @return
     */
    public CostTypeOutVo findCostTypeByCode(String costTypeCode);
    
    /**
     * 创建预算项目 预算金额为0 
     * @param vo
     * @return
     */
    public String createProject(ProjectVo vo);

    /**
     * 查询所有的表单费用类型
     * @return
     */
    public List<CostTypeOutVo> findBillCostType();

    /**
     * 人工干预预算
     * @param vo
     * @return
     */
    public BizResponseJson<String> humanProcess(HumanProcessVoIn vo);

}
