/**
 * 2017 
 * 2017年5月21日  
 * 下午1:34:13
 * AuditApplyBudgetDetailInVo.java
 * com.chinayanghe.msp.budget.vo.auditapplybudget.in
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.auditapplybudget.in;

import java.math.BigDecimal;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.auditapplybudget.code.AuditApplyBudgetCode;
import com.chinayanghe.msp.budget.vo.auditapplybudget.out.AuditApplyBudgetOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * @author yangshuo
 *
 */
public class AuditApplyBudgetDetailInVo extends BaseVo implements AuditApplyBudgetCode{
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -7447362200027637585L;
	/**
	 * 品牌大类 必填
	 */
	private String   brandCategory;
	/**
	 * 渠道 必填
	 */
	private String   channel;
	/**
	 * 费用类型 必填
	 */
	private String   costType;
	/**
	 * 审核金额 必填 金额必须大于0
	 */
	private BigDecimal   amount;

	/**
	 * 核报金额 必填 金额必须大于0
	 */
	private BigDecimal   reportAmount;

	/**
	 * 审核金额 必填 金额必须大于0
	 */
	private BigDecimal   auditAmount;

	/**
	 *  复核金额 必填 金额必须大于0
	 */
	private BigDecimal   reviewAmount;


	@Override
	public BizResponseJson<List<AuditApplyBudgetOutVo>> validate() {
		if(StringUtils.isBlank(brandCategory)){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(BRANDCATEGORY_NULL, null, "<品牌大类>为必须字段，不能为空");
		} 
		if(StringUtils.isBlank(channel)){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(BUDGETCHANNEL_NULL, null, "<渠道>为必须字段，不能为空");
		} 
		if(StringUtils.isBlank(costType)){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(COSTTYPE_NULL, null, "<费用类型>为必须字段，不能为空");
		} 
		if(null==amount){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(AMOUNT_NULL, null, "<申请金额>为必须字段，不能为空");
		} 
		if( amount.compareTo(BigDecimal.ZERO)==-1){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(AMOUNT_LESS_ZERO,null,"申请金额不能为负数");
		}
		if( auditAmount.compareTo(BigDecimal.ZERO)==-1){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(AMOUNT_LESS_ZERO,null,"审核金额不能为负数");
		}
		if( reportAmount.compareTo(BigDecimal.ZERO)==-1){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(AMOUNT_LESS_ZERO,null,"核报金额不能为负数");
		}
		if( reviewAmount.compareTo(BigDecimal.ZERO)==-1){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(AMOUNT_LESS_ZERO,null,"复核金额不能为负数");
		}

		if(amount.compareTo(new BigDecimal(amount.longValue()))!=0){
			//校验失败
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(AMOUNT_HAVE_POINT,null,"申请金额不能为小数");	
		}
		 //验证成功
		return new BizResponseJson<List<AuditApplyBudgetOutVo>>();
	}
	public String getBrandCategory() {
		return brandCategory;
	}
	public void setBrandCategory(String brandCategory) {
		this.brandCategory = brandCategory;
	}
	public String getChannel() {
		return channel;
	}
	public void setChannel(String channel) {
		this.channel = channel;
	}
	public String getCostType() {
		return costType;
	}
	public void setCostType(String costType) {
		this.costType = costType;
	}
	public BigDecimal getAmount() {
		return amount;
	}
	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}
	public BigDecimal getReportAmount() { return reportAmount;}
	public void setReportAmount(BigDecimal reportAmount) {this.reportAmount = reportAmount;}
	public BigDecimal getAuditAmount() {return auditAmount;}
	public void setAuditAmount(BigDecimal auditAmount) {this.auditAmount = auditAmount;}
	public BigDecimal getReviewAmount() {return reviewAmount;}
	public void setReviewAmount(BigDecimal reviewAmount) {this.reviewAmount = reviewAmount;}
}
